/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.pdu;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import com.gensee.pdu.AbsAnno;

public class AnnoPointer
extends AbsAnno {
    private static final int RADIUS = 15;
    protected float x;
    protected float y;

    public AnnoPointer() {
        this.setType(1);
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    @Override
    public void draw(Canvas canvas, Matrix matrix) {
        float[] values = new float[9];
        matrix.getValues(values);
        long tx = (long)(this.x * values[0] + values[2]);
        long ty = (long)(this.y * values[4] + values[5]);
        tx += 15L;
        ty += 15L;
        Paint p = new Paint();
        p.setDither(true);
        p.setAntiAlias(true);
        p.setColor(-16776961);
        p.setStyle(Paint.Style.STROKE);
        p.setStrokeCap(Paint.Cap.ROUND);
        p.setStrokeWidth(4.0f);
        canvas.drawCircle((float)tx, (float)ty, 15.0f, p);
        canvas.drawLine((float)(tx - 20L), (float)ty, (float)(tx + 20L), (float)ty, p);
        canvas.drawLine((float)tx, (float)(ty - 20L), (float)tx, (float)(ty + 20L), p);
        p.setColor(-65536);
        p.setStyle(Paint.Style.FILL);
        canvas.drawCircle((float)tx, (float)ty, 7.0f, p);
    }

    @Override
    public boolean contain(float x, float y) {
        return (x - this.x) * (x - this.x) + (y - this.y) * (y - this.y) <= 225.0f;
    }

    @Override
    public String toString() {
        return "AnnoPointer [id=" + this.id + ", filehandle=" + this.docId + ", blockhandle=" + this.pageId + ", owner=" + this.owner + ", x=" + this.x + ", y=" + this.y + super.toString() + "]";
    }

    @Override
    public void drawOnViewCanvas(Canvas canvas, Matrix matrix) {
        this.draw(canvas, matrix);
    }
}

