/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.pdu;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.RectF;
import com.gensee.pdu.AbsAnno;
import com.gensee.pdu.AnnoRect;

public class AnnoPicture
extends AnnoRect {
    private static final String TAG = "AnnoPicture";
    private String url;
    private String localPath;
    private Bitmap bitmap;
    private float pw;
    private float ph;

    public AnnoPicture() {
        this.setType(24);
        this.setArgbColor(-65536);
        this.setLinesize((byte)2);
    }

    public AnnoPicture(String url, String localPath) {
        this();
        Bitmap bitmap = BitmapFactory.decodeFile((String)localPath);
        float left = 0.0f;
        float top = 0.0f;
        float right = left + (float)bitmap.getWidth();
        float bottom = top + (float)bitmap.getHeight();
        this.setLeft(left);
        this.setTop(top);
        this.setRight(right);
        this.setBottom(bottom);
        this.setUrl(url);
        this.setBitmap(bitmap);
        this.setLocalPath(localPath);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    @Override
    public void draw(Canvas canvas, Matrix matrix) {
        Bitmap bitmap = this.getBitmap();
        if (bitmap != null) {
            float[] values = new float[9];
            matrix.getValues(values);
            RectF rf = new RectF(this.getX(values, this.getLeft()), this.getY(values, this.getTop()), this.getX(values, this.getRight()), this.getY(values, this.getBottom()));
            canvas.drawBitmap(bitmap, null, rf, new Paint());
            if (this.isSelected) {
                float segment = 5.0f;
                DashPathEffect effects = new DashPathEffect(new float[]{segment, segment, segment, segment}, 1.0f);
                this.getPaint().setPathEffect((PathEffect)effects);
                super.draw(canvas, matrix);
            }
        }
    }

    public void setBitmap(Bitmap bitmap) {
        this.bitmap = bitmap;
    }

    private Bitmap getBitmap() {
        if (this.bitmap != null) {
            return this.bitmap;
        }
        if (this.localPath != null) {
            this.bitmap = BitmapFactory.decodeFile((String)this.localPath);
        }
        return this.bitmap;
    }

    @Override
    public void touchDown(float x, float y) {
        this.downX = this.preX = x;
        this.downY = this.preY = y;
    }

    @Override
    public void touchMove(float x, float y) {
        float distanceX = x - this.preX;
        float distanceY = y - this.preY;
        float pNewLeft = this.getLeft() + distanceX;
        float pNewRight = this.getRight() + distanceX;
        float pNewTop = this.getTop() + distanceY;
        float pNewBottom = this.getBottom() + distanceY;
        if (pNewLeft <= 0.0f) {
            pNewLeft = 0.0f;
            pNewRight = this.getRight() - this.getLeft();
        } else if (pNewRight > this.pw) {
            pNewLeft = this.getLeft() + (this.pw - this.getRight());
            pNewRight = this.pw;
        }
        if (pNewTop < 0.0f) {
            pNewTop = 0.0f;
            pNewBottom = this.getBottom() - this.getTop();
        } else if (pNewBottom > this.ph) {
            pNewTop = this.getTop() + (this.ph - this.getBottom());
            pNewBottom = this.ph;
        }
        this.setLeft(pNewLeft);
        this.setRight(pNewRight);
        this.setTop(pNewTop);
        this.setBottom(pNewBottom);
        this.preX = x;
        this.preY = y;
        this.resetRect();
    }

    float getX(float[] values, float sx) {
        return sx * values[0] + values[2];
    }

    float getY(float[] values, float sy) {
        return sy * values[4] + values[5];
    }

    @Override
    public void touchDraw(Canvas canvas, Matrix matrix) {
        this.draw(canvas, matrix);
    }

    @Override
    public boolean contain(float x, float y) {
        return x <= this.getRight() && x >= this.getLeft() && y >= this.getTop() && y <= this.getBottom();
    }

    public void scall(float scale, float x, float y) {
        float left = this.getLeft();
        float right = this.getRight();
        float top = this.getTop();
        float bottom = this.getBottom();
        float newLeft = x - (x - left) * scale;
        float newRight = x + (right - x) * scale;
        float newTop = y - (y - top) * scale;
        float newBottom = y + (bottom - y) * scale;
        float xScale = scale;
        float leftScalX = x / (x - left);
        float rightScalX = (this.pw - x) / (right - x);
        if (newLeft <= 0.0f && newRight >= this.pw) {
            xScale = Math.min(leftScalX, rightScalX);
        } else if (newLeft <= 0.0f) {
            xScale = leftScalX;
        } else if (newRight >= this.pw) {
            xScale = rightScalX;
        }
        float yScale = scale;
        float topScalY = y / (y - top);
        float bottomScalY = (this.ph - y) / (bottom - y);
        if (newTop <= 0.0f && newBottom >= this.ph) {
            yScale = Math.min(topScalY, bottomScalY);
        } else if (newTop <= 0.0f) {
            yScale = y / (y - top);
        } else if (newBottom >= this.ph) {
            yScale = (this.ph - y) / (bottom - y);
        }
        scale = Math.min(xScale, yScale);
        this.setLeft(x - (x - left) * scale);
        this.setRight(x + (right - x) * scale);
        this.setTop(y - (y - top) * scale);
        bottom = y + (bottom - y) * scale;
        this.setBottom(bottom);
        this.resetRect();
    }

    private void resetRect() {
        Path path = this.getPath();
        path.reset();
        path.addRect(this.getLeft() + (float)this.getLinesize(), this.getTop() + (float)this.getLinesize(), this.getRight() - (float)this.getLinesize(), this.getBottom() - (float)this.getLinesize(), Path.Direction.CW);
    }

    public void updateFromOther(AbsAnno picture) {
        if (picture instanceof AnnoPicture) {
            AnnoPicture p = (AnnoPicture)picture;
            this.setLeft(p.getLeft());
            this.setRight(p.getRight());
            this.setTop(p.getTop());
            this.setBottom(p.getBottom());
            this.resetRect();
        }
    }

    public void setPageWidthAndHeight(float pw, float ph) {
        this.pw = pw;
        this.ph = ph;
    }
}

