/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.pdu;

import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import com.gensee.pdu.AnnoLine;

public class AnnoLineEx
extends AnnoLine {
    public static final short ANNO_LINE_NORMAL = 0;
    public static final short ANNO_LINE_DASH = 1;
    public static final short ANNO_LINE_ARROW = 2;
    private byte lineType = 0;

    public AnnoLineEx() {
        this.setType(8);
    }

    public short getLineType() {
        return this.lineType;
    }

    public void setLineType(byte lineType) {
        this.lineType = lineType;
    }

    @Override
    public void draw(Canvas canvas, Matrix matrix) {
        switch (this.lineType) {
            case 1: {
                Paint paint = this.getSourcePaint();
                int segment = this.getLinesize() + 5;
                DashPathEffect effects = new DashPathEffect(new float[]{segment, segment, segment, segment}, 1.0f);
                paint.setPathEffect((PathEffect)effects);
                Path path = new Path(this.getSourcePath());
                path.transform(matrix);
                canvas.drawPath(path, paint);
                break;
            }
            case 2: {
                float[] values = new float[9];
                matrix.getValues(values);
                int sx = (int)(this.getLeft() * values[0] + values[2]);
                int sy = (int)(this.getTop() * values[4] + values[5]);
                int ex = (int)(this.getRight() * values[0] + values[2]);
                int ey = (int)(this.getBottom() * values[4] + values[5]);
                this.drawAL(canvas, sx, sy, ex, ey);
                break;
            }
            default: {
                super.draw(canvas, matrix);
            }
        }
    }

    public void drawAL(Canvas canvas, int sx, int sy, int ex, int ey) {
        double H = 6 + this.getLinesize();
        double L = 3.5 + (double)this.getLinesize();
        double awrad = Math.atan(L / H);
        double arraow_len = Math.sqrt(L * L + H * H);
        double[] arrXY_1 = this.rotateVec(ex - sx, ey - sy, awrad, true, arraow_len);
        double[] arrXY_2 = this.rotateVec(ex - sx, ey - sy, -awrad, true, arraow_len);
        float x3 = (float)ex - (float)arrXY_1[0];
        float y3 = (float)ey - (float)arrXY_1[1];
        float x4 = (float)ex - (float)arrXY_2[0];
        float y4 = (float)ey - (float)arrXY_2[1];
        Paint p = this.getSourcePaint();
        p.setStyle(Paint.Style.STROKE);
        canvas.drawLine((float)sx, (float)sy, (float)ex, (float)ey, p);
        Path triangle = new Path();
        triangle.moveTo((float)ex, (float)ey);
        triangle.lineTo(x3, y3);
        triangle.lineTo(x4, y4);
        triangle.close();
        p.setStyle(Paint.Style.FILL);
        canvas.drawPath(triangle, p);
    }

    public double[] rotateVec(int px, int py, double ang, boolean isChLen, double newLen) {
        double[] mathstr = new double[2];
        double vx = (double)px * Math.cos(ang) - (double)py * Math.sin(ang);
        double vy = (double)px * Math.sin(ang) + (double)py * Math.cos(ang);
        if (isChLen) {
            double d = Math.sqrt(vx * vx + vy * vy);
            vx = vx / d * newLen;
            vy = vy / d * newLen;
            mathstr[0] = vx;
            mathstr[1] = vy;
        }
        return mathstr;
    }

    @Override
    public String toString() {
        return "AnnoLineEx [lineType=" + this.lineType + super.toString() + "]";
    }
}

