/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.pdu;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import com.gensee.pdu.AbsAnno;

public class AnnoLine
extends AbsAnno {
    protected int color;
    protected byte linesize;
    protected float left;
    protected float top;
    protected float right;
    protected float bottom;
    private Paint mPaint;
    private Path mPath;

    public AnnoLine() {
        this.setType(7);
    }

    protected Paint getSourcePaint() {
        if (this.mPaint == null) {
            if (this.argbColor == -1) {
                this.argbColor = this.agbrToArgb(this.color);
            }
            this.mPaint = new Paint();
            this.mPaint.setColor(this.argbColor);
            this.mPaint.setStrokeWidth((float)this.linesize);
            this.mPaint.setAntiAlias(true);
            this.mPaint.setDither(true);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeJoin(Paint.Join.ROUND);
            this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        }
        return this.mPaint;
    }

    protected Path getSourcePath() {
        if (this.mPath == null) {
            this.mPath = new Path();
            this.mPath.moveTo(this.left, this.top);
            this.mPath.lineTo(this.right, this.bottom);
        }
        return this.mPath;
    }

    @Override
    public void setPath(Path p) {
        this.mPath = p;
    }

    @Override
    public void draw(Canvas canvas, Matrix matrix) {
        if (canvas != null && matrix != null) {
            this.getSourcePaint();
            this.getSourcePath();
            Path p = new Path(this.mPath);
            p.transform(matrix);
            canvas.drawPath(p, this.mPaint);
        }
    }

    @Override
    public boolean contain(float x, float y) {
        float tl = this.left;
        float tt = this.top;
        float tr = this.right;
        float tb = this.bottom;
        if (this.left > this.right) {
            tl = this.right;
            tr = this.left;
        }
        if (this.top > this.bottom) {
            tt = this.bottom;
            tb = this.top;
        }
        if (x >= tl - 32.0f && x <= tr + 32.0f && y >= tt - 32.0f && y <= tb + 32.0f) {
            if (this.left == this.right) {
                return x == this.left;
            }
            if (this.top == this.bottom) {
                return y == this.top;
            }
            float k = (this.bottom - this.top) / (this.right - this.left);
            float c = this.top - k * this.left;
            float d = (float)Math.sqrt((k * x + c - y) * (k * x + c - y) / (k * k + 1.0f));
            return d <= 32.0f;
        }
        return false;
    }

    @Override
    public void touchDown(float x, float y) {
        this.left = this.right = x;
        this.top = this.bottom = y;
        this.getSourcePath();
    }

    @Override
    public void touchMove(float x, float y) {
        this.right = x;
        this.bottom = y;
        Path p = this.getSourcePath();
        p.reset();
        p.moveTo(this.left, this.top);
        p.lineTo(this.right, this.bottom);
    }

    @Override
    public void touchUp(float x, float y) {
        if (this.right == this.left) {
            this.right += 0.5f;
        }
        if (this.top == this.bottom) {
            this.bottom += 0.5f;
        }
        this.touchMove(this.right, this.bottom);
    }

    @Override
    public void touchDraw(Canvas canvas, Matrix matrix) {
        this.draw(canvas, matrix);
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public int setArgbColor(int argb) {
        this.argbColor = argb;
        this.color = super.setArgbColor(argb);
        return this.color;
    }

    public byte getLinesize() {
        return this.linesize;
    }

    @Override
    public void setLinesize(byte linesize) {
        this.linesize = linesize;
    }

    public float getLeft() {
        return this.left;
    }

    public void setLeft(float left) {
        this.left = left;
    }

    public float getTop() {
        return this.top;
    }

    public void setTop(float top) {
        this.top = top;
    }

    public float getRight() {
        return this.right;
    }

    public void setRight(float right) {
        this.right = right;
    }

    public float getBottom() {
        return this.bottom;
    }

    public void setBottom(float bottom) {
        this.bottom = bottom;
    }

    @Override
    public String toString() {
        return "AnnoLine [color=" + this.color + ", linesize=" + this.linesize + ", left=" + this.left + ", top=" + this.top + ", right=" + this.right + ", bottom=" + this.bottom + "," + super.toString() + "]";
    }
}

