/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.pdu;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import com.gensee.pdu.AnnoFPoint;
import com.gensee.pdu.AnnoFreepen;

public class AnnoFreepenEx
extends AnnoFreepen {
    public static final int STEP_COMPLETE = 0;
    public static final int STEP_BEGIN = 1;
    public static final int STEP_ADD = 2;
    public static final int STEP_END = 3;
    private int stepType;
    private static BitmapDrawable freepenExDrawable;
    private AnnoFPoint lastPoint;

    public AnnoFreepenEx() {
        this.setType(16);
    }

    public static AnnoFreepenEx create(AnnoFreepenEx source) {
        AnnoFreepenEx newPen = new AnnoFreepenEx();
        newPen.setHighLight(source.isHighLight());
        newPen.setLinesize((byte)source.getLinesize());
        newPen.setColor(source.getColor());
        newPen.setId(source.getId());
        newPen.setOwner(source.getOwner());
        newPen.setDocId(source.getDocId());
        newPen.setPageId(source.getPageId());
        return newPen;
    }

    public static BitmapDrawable getFreepenExDrawable() {
        return freepenExDrawable;
    }

    public static void setFreepenExDrawable(BitmapDrawable freepenExDrawable) {
        AnnoFreepenEx.freepenExDrawable = freepenExDrawable;
    }

    public boolean appendEX(AnnoFreepenEx ex) {
        if (ex == null) {
            return false;
        }
        int step = ex.getStepType();
        this.setStepType(step);
        AnnoFPoint[] points = ex.getPoints();
        if (2 == step) {
            this.appendPoints(points);
            this.lastPoint = points != null && points.length > 0 ? points[points.length - 1] : null;
        } else if (3 == step) {
            this.appendPoints(points);
            this.lastPoint = null;
        } else if (1 == step) {
            this.appendPoints(points);
            this.lastPoint = points != null && points.length > 0 ? points[points.length - 1] : null;
        } else if (0 == step) {
            this.clearPoints();
            this.appendPoints(points);
            this.lastPoint = null;
        }
        return true;
    }

    @Override
    protected boolean isEnd() {
        return 3 == this.getStepType();
    }

    @Override
    protected void setPoints(AnnoFPoint[] points) {
        if (points != null && points.length > 0) {
            super.setPoints(points);
            this.lastPoint = points[points.length - 1];
        }
    }

    @Override
    public void draw(Canvas canvas, Matrix matrix) {
        super.draw(canvas, matrix);
    }

    public int getStepType() {
        return this.stepType;
    }

    public void setStepType(int stepType) {
        this.stepType = stepType;
    }

    @Override
    public String toString() {
        return "AnnoFreepenEx [stepType=" + this.stepType + ", " + super.toString() + "]";
    }

    @Override
    public void drawOnViewCanvas(Canvas canvas, Matrix matrix) {
        Bitmap bitmap;
        this.draw(canvas, matrix);
        AnnoFPoint lastP = this.lastPoint;
        BitmapDrawable bd = freepenExDrawable;
        if (0 != this.getStepType() && 3 != this.getStepType() && bd != null && lastP != null && (bitmap = bd.getBitmap()) != null && !bitmap.isRecycled()) {
            float[] values = new float[9];
            matrix.getValues(values);
            long tx = (long)(lastP.x * values[0] + values[2]);
            long ty = (long)(lastP.y * values[4] + values[5]);
            canvas.drawBitmap(bitmap, (float)tx, (float)ty, new Paint());
        }
    }

    @Override
    public void touchUp(float x, float y) {
        super.touchUp(x, y);
        this.setStepType(3);
    }
}

