/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.pdu;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import com.gensee.pdu.AbsAnno;
import com.gensee.pdu.AnnoFPoint;
import com.gensee.utils.GenseeLog;
import java.util.ArrayList;
import java.util.List;

public class AnnoFreepen
extends AbsAnno {
    private static final String TAG = "AnnoFreepen";
    private List<AnnoFPoint> pts;
    public static float desity = 1.0f;
    protected int color;
    private boolean isHighLight;
    protected int delay;
    protected byte linesize;
    private Paint mPaint;
    private Path mPath;
    private Canvas canvas;
    private Matrix matrix;

    public AnnoFreepen() {
        this.setType(2);
        this.pts = new ArrayList<AnnoFPoint>(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Canvas canvas, Matrix matrix) {
        if (canvas != null && matrix != null) {
            Path tPath;
            this.canvas = canvas;
            this.matrix = matrix;
            if (this.mPaint == null) {
                this.mPaint = new Paint();
                if (this.argbColor == -1) {
                    this.argbColor = this.agbrToArgb(this.color);
                }
                this.mPaint.setColor(this.argbColor);
                this.mPaint.setStrokeWidth((float)(this.linesize < 3 ? 3 : (int)this.linesize) / desity + 0.5f);
                this.mPaint.setAntiAlias(true);
                this.mPaint.setDither(true);
                this.mPaint.setStyle(Paint.Style.STROKE);
                this.mPaint.setStrokeJoin(Paint.Join.ROUND);
                this.mPaint.setStrokeCap(Paint.Cap.ROUND);
            }
            AnnoFreepen annoFreepen = this;
            synchronized (annoFreepen) {
                tPath = new Path(this.initPath());
            }
            if (null != tPath) {
                tPath.transform(matrix);
                canvas.drawPath(tPath, this.mPaint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Path initPath() {
        if (this.mPath != null) return this.mPath;
        String string = TAG;
        synchronized (TAG) {
            if (this.mPath != null) return this.mPath;
            this.mPath = new Path();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mPath;
        }
    }

    private void moveTo(float x, float y) {
        this.initPath();
        this.mPath.reset();
        this.mPath.moveTo(x, y);
        this.preX = x;
        this.preY = y;
    }

    private void quadTo(float x, float y, boolean isLastPoint) {
        this.mPath.quadTo(this.preX, this.preY, (x + this.preX) / 2.0f, (y + this.preY) / 2.0f);
        this.preX = x;
        this.preY = y;
    }

    private void lineToEnd() {
        this.mPath.lineTo(this.preX, this.preY);
    }

    @Override
    public void setPath(Path p) {
        this.mPath = p;
    }

    public void addPoint(float x, float y) {
        this.pts.add(new AnnoFPoint(x, y));
    }

    public int getPointCount() {
        return this.pts.size();
    }

    protected void clearPoints() {
        this.pts.clear();
    }

    public boolean appendPoints(AnnoFPoint[] points) {
        if (points == null || points.length == 0) {
            return false;
        }
        int nLastSize = this.pts.size();
        for (AnnoFPoint pex : points) {
            this.pts.add(pex);
        }
        AnnoFPoint p = null;
        int size = this.pts.size();
        for (int i = nLastSize; i < size; ++i) {
            p = this.pts.get(i);
            this.buildPath(size, i, p);
        }
        boolean isEnd = this.isEnd();
        GenseeLog.d((String)TAG, (String)("appendPoints isEnd = " + isEnd + " id = " + this.id));
        if (isEnd) {
            this.lineToEnd();
        }
        return true;
    }

    protected boolean isEnd() {
        return true;
    }

    @Override
    public boolean contain(float x, float y) {
        for (AnnoFPoint p : this.pts) {
            float des;
            if (p == null || !((des = (float)Math.sqrt((x - p.x) * (x - p.x) + (y - p.y) * (y - p.y))) <= 32.0f)) continue;
            return true;
        }
        return false;
    }

    protected void setPoints(AnnoFPoint[] points) {
        if (points == null || points.length == 0) {
            GenseeLog.e((String)TAG, (String)"setPoints size = 0");
            return;
        }
        AnnoFPoint p = null;
        for (int i = 0; i < points.length; ++i) {
            p = points[i];
            this.buildPath(points.length, i, p);
            this.pts.add(p);
        }
        this.lineToEnd();
    }

    public AnnoFPoint[] getPoints() {
        AnnoFPoint[] arr = new AnnoFPoint[this.pts.size()];
        arr = this.pts.toArray(arr);
        return arr;
    }

    public List<AnnoFPoint> getPointList() {
        return this.pts;
    }

    private synchronized void buildPath(int size, int index, AnnoFPoint p) {
        if (size <= 2) {
            if (index == 0) {
                this.moveTo(p.x - 0.5f, p.y - 0.5f);
            } else {
                this.quadTo(p.x + 0.5f, p.y + 0.5f, size - index == 1);
            }
        } else if (index == 0) {
            this.moveTo(p.x, p.y);
        } else {
            this.quadTo(p.x, p.y, size - index == 1);
        }
    }

    public void setPoints(List<AnnoFPoint> points) {
        if (points != null) {
            int size = points.size();
            AnnoFPoint p = null;
            for (int i = 0; i < size; ++i) {
                p = points.get(i);
                this.buildPath(size, i, p);
                this.pts.add(p);
            }
            this.lineToEnd();
        }
    }

    @Override
    public boolean isHighLight() {
        return this.isHighLight;
    }

    @Override
    public void setHighLight(boolean isHighLight) {
        this.isHighLight = isHighLight;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public int setArgbColor(int argb) {
        this.argbColor = argb;
        this.color = super.setArgbColor(argb);
        return this.color;
    }

    public short getLinesize() {
        return this.linesize;
    }

    @Override
    public void setLinesize(byte linesize) {
        this.linesize = linesize;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    @Override
    public void clean() {
        if (this.pts != null) {
            this.pts.clear();
        }
    }

    @Override
    public String toString() {
        return "AnnoFreepen [" + super.toString() + " color=" + this.color + ", linesize=" + this.linesize + ", mPaint=" + this.mPaint + ", mPath=" + this.mPath + ",isHighLight=" + this.isHighLight + " delay=" + this.delay + "]";
    }

    @Override
    public void touchDown(float x, float y) {
        this.moveTo(x, y);
    }

    @Override
    public void touchMove(float x, float y) {
        this.quadTo(x, y, false);
        this.addPoint(x, y);
    }

    @Override
    public void touchUp(float x, float y) {
        this.preX = (float)((double)this.preX + 0.5);
        this.preY = (float)((double)this.preY + 0.5);
        this.lineToEnd();
    }

    @Override
    public void touchDraw(Canvas canvas, Matrix matrix) {
        this.draw(canvas, matrix);
    }
}

