/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.pdu;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.drawable.BitmapDrawable;
import com.gensee.pdu.PduBase;

public abstract class AbsAnno
extends PduBase {
    public static final int HIGH_LIGHT = -1761607680;
    protected float downX;
    protected float downY;
    protected float preX;
    protected float preY;
    private long timestamp;
    protected long id;
    protected int docId;
    protected int pageId;
    protected long owner;
    protected int argbColor = -1;
    protected boolean isSelected = false;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getDocId() {
        return this.docId;
    }

    public void setDocId(int docId) {
        this.docId = docId;
    }

    public int getPageId() {
        return this.pageId;
    }

    public void setPageId(int pageId) {
        this.pageId = pageId;
    }

    public long getOwner() {
        return this.owner;
    }

    public void setOwner(long owner) {
        this.owner = owner;
    }

    public abstract void draw(Canvas var1, Matrix var2);

    public abstract boolean contain(float var1, float var2);

    public void resetAnno(AbsAnno anno) {
    }

    public void setPath(Path p) {
    }

    public void setBitmapDrawable(BitmapDrawable bitmapDrawable) {
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    protected int agbrToArgb(int agbr) {
        int r = agbr & 0xFF;
        int g = agbr & 0xFF00;
        int b = agbr & 0xFF0000;
        int a = agbr & 0xFF000000;
        a = this.isHighLight() ? -1761607680 : -16777216;
        return a | r << 16 | g | b >> 16;
    }

    protected boolean isHighLight() {
        return false;
    }

    public void setHighLight(boolean hl) {
    }

    public int setArgbColor(int argb) {
        int a = 0;
        int r = Color.red((int)argb);
        int g = Color.green((int)argb);
        int b = Color.blue((int)argb);
        return a << 24 | b << 16 | g << 8 | r;
    }

    public void setLinesize(byte linesize) {
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbsAnno other = (AbsAnno)obj;
        return this.id == other.id;
    }

    @Override
    public String toString() {
        return "AbsAnno [id=" + this.id + ", docId=" + this.docId + ", pageId=" + this.pageId + ", owner=" + this.owner + ",timestamp=" + this.timestamp + ", type =" + this.type + "]";
    }

    public void clean() {
    }

    public void touchDown(float x, float y) {
        this.downX = this.preX = x;
        this.downY = this.preY = y;
    }

    public void touchMove(float x, float y) {
        this.preX = x;
        this.preY = y;
    }

    public void touchUp(float x, float y) {
        this.preX = x;
        this.preY = y;
    }

    public void touchDraw(Canvas canvas, Matrix matrix) {
    }

    public void drawOnViewCanvas(Canvas canvas, Matrix matrix) {
    }
}

