/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.parse;

import android.graphics.Color;
import com.gensee.parse.PullBase;
import com.gensee.pdu.AbsAnno;
import com.gensee.pdu.AnnoCircle;
import com.gensee.pdu.AnnoCleaner;
import com.gensee.pdu.AnnoFPoint;
import com.gensee.pdu.AnnoFreepen;
import com.gensee.pdu.AnnoFreepenEx;
import com.gensee.pdu.AnnoLineEx;
import com.gensee.pdu.AnnoPicture;
import com.gensee.pdu.AnnoPointerEx;
import com.gensee.pdu.AnnoRect;
import com.gensee.pdu.AnnoText;
import com.gensee.utils.GenseeLog;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnnotaionParse
extends PullBase {
    public static final String TAG_COMMAND = "command";
    public static final String TAG_P = "p";
    public static final String TAG_EP = "ep";
    private static final String TAG = "AnnoParse";
    private static AnnotaionParse parse;
    protected int cmdVer = 0;
    protected AbsAnno anno;
    protected List<AnnoFPoint> points;
    protected int type;
    private OnAnnoParseListener listener;

    public AnnotaionParse setOnAnnoParseListener(OnAnnoParseListener listener) {
        this.listener = listener;
        return this;
    }

    public static AnnotaionParse getParse() {
        if (parse == null) {
            parse = new AnnotaionParse();
        }
        return parse;
    }

    public AbsAnno parseAnnoXml(String xml) {
        XmlPullParser parser = this.builXmlPullParser(xml);
        if (parser != null) {
            this.parser(parser);
        }
        return this.anno;
    }

    protected void onStartTag(String nodeName, XmlPullParser parser) {
        if (TAG_COMMAND.equals(nodeName)) {
            this.startCommand(parser);
        } else if (TAG_P.equals(nodeName)) {
            this.startP(parser);
        } else if (TAG_EP.equals(nodeName)) {
            this.startEP(parser);
        }
    }

    protected void onStartText(XmlPullParser parser) {
        String str;
        if (this.type == 4 && this.anno instanceof AnnoText && (str = parser.getText()) != null && !"".equals(str = str.trim())) {
            ((AnnoText)this.anno).setText(str.trim());
        }
    }

    protected void onCDATA(XmlPullParser parser) {
        String str;
        if (this.type == 4 && this.anno instanceof AnnoText && (str = parser.getText()) != null && !"".equals(str)) {
            ((AnnoText)this.anno).setText(str);
        }
    }

    protected int nextEventType(XmlPullParser parser) {
        if (parser != null) {
            try {
                return parser.nextToken();
            }
            catch (XmlPullParserException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return 1;
    }

    protected void onEndTag(String nodeName, XmlPullParser parser) {
        if (TAG_COMMAND.equals(nodeName)) {
            this.endCommand(parser);
        } else if (TAG_P.equals(nodeName) || TAG_EP.equals(nodeName)) {
            // empty if block
        }
    }

    protected void endCommand(XmlPullParser parser) {
        switch (this.type) {
            case 2: 
            case 16: 
            case 18: {
                if (this.anno instanceof AnnoFreepenEx) {
                    ((AnnoFreepenEx)this.anno).setPoints(this.points);
                }
                this.points.clear();
                this.points = null;
                break;
            }
        }
        if (this.listener != null) {
            this.listener.onAnno(this.anno);
        }
    }

    protected void startEP(XmlPullParser parser) {
        AnnoFPoint p = this.parsePoint(parser);
        if (p == null) {
            return;
        }
        switch (this.type) {
            case 1: {
                break;
            }
            case 9: {
                break;
            }
            case 2: {
                break;
            }
            case 5: 
            case 22: {
                if (!(this.anno instanceof AnnoCircle)) break;
                ((AnnoCircle)this.anno).setRight(p.x);
                ((AnnoCircle)this.anno).setBottom(p.y);
                break;
            }
            case 7: 
            case 8: 
            case 21: {
                if (!(this.anno instanceof AnnoLineEx)) break;
                ((AnnoLineEx)this.anno).setRight(p.x);
                ((AnnoLineEx)this.anno).setBottom(p.y);
                break;
            }
            case 6: 
            case 20: {
                if (!(this.anno instanceof AnnoRect)) break;
                ((AnnoRect)this.anno).setRight(p.x);
                ((AnnoRect)this.anno).setBottom(p.y);
                break;
            }
            case 4: 
            case 19: {
                if (!(this.anno instanceof AnnoText)) break;
                ((AnnoText)this.anno).setRight(p.x);
                ((AnnoText)this.anno).setBottom(p.y);
                break;
            }
            case 24: {
                if (!(this.anno instanceof AnnoPicture)) break;
                ((AnnoPicture)this.anno).setRight(p.x);
                ((AnnoPicture)this.anno).setBottom(p.y);
                break;
            }
            case 3: {
                break;
            }
        }
    }

    protected void startP(XmlPullParser parser) {
        AnnoFPoint p = this.parsePoint(parser);
        if (p == null) {
            return;
        }
        switch (this.type) {
            case 1: 
            case 9: 
            case 17: {
                if (!(this.anno instanceof AnnoPointerEx)) break;
                AnnoPointerEx apex = (AnnoPointerEx)this.anno;
                apex.setX(p.x);
                apex.setY(p.y);
                break;
            }
            case 2: 
            case 16: 
            case 18: {
                if (this.points == null) {
                    this.points = new ArrayList<AnnoFPoint>(1);
                }
                this.points.add(p);
                break;
            }
            case 5: 
            case 22: {
                if (!(this.anno instanceof AnnoCircle)) break;
                ((AnnoCircle)this.anno).setLeft(p.x);
                ((AnnoCircle)this.anno).setTop(p.y);
                break;
            }
            case 7: 
            case 8: 
            case 21: {
                if (!(this.anno instanceof AnnoLineEx)) break;
                ((AnnoLineEx)this.anno).setLeft(p.x);
                ((AnnoLineEx)this.anno).setTop(p.y);
                break;
            }
            case 6: 
            case 20: {
                if (!(this.anno instanceof AnnoRect)) break;
                ((AnnoRect)this.anno).setLeft(p.x);
                ((AnnoRect)this.anno).setTop(p.y);
                break;
            }
            case 4: 
            case 19: {
                if (!(this.anno instanceof AnnoText)) break;
                ((AnnoText)this.anno).setLeft(p.x);
                ((AnnoText)this.anno).setTop(p.y);
                break;
            }
            case 3: {
                break;
            }
            case 24: {
                if (!(this.anno instanceof AnnoPicture)) break;
                ((AnnoPicture)this.anno).setLeft(p.x);
                ((AnnoPicture)this.anno).setTop(p.y);
                break;
            }
        }
    }

    protected void startCommand(XmlPullParser parser) {
        this.type = this.getAttrIntValue(parser, "type");
        this.cmdVer = this.getAttrIntValue(parser, "ver");
        switch (this.type) {
            case 1: 
            case 17: {
                this.type = 9;
            }
            case 9: {
                this.anno = this.parsePointerEx(parser);
                break;
            }
            case 2: 
            case 16: 
            case 18: {
                this.anno = this.parseFreepenEx(parser);
                break;
            }
            case 5: 
            case 22: {
                this.anno = this.parseCircle(parser);
                break;
            }
            case 7: 
            case 21: {
                this.type = 8;
            }
            case 8: {
                this.anno = this.parseLineEx(parser);
                break;
            }
            case 6: 
            case 20: {
                this.anno = this.parseRect(parser);
                break;
            }
            case 4: 
            case 19: {
                this.anno = this.parseText(parser);
                break;
            }
            case 3: 
            case 23: {
                this.anno = this.parseCleaner(parser);
                break;
            }
            case 24: {
                this.anno = this.parsePicAnno(parser);
                break;
            }
        }
    }

    private AbsAnno parsePicAnno(XmlPullParser parser) {
        AnnoPicture annoPicture = new AnnoPicture();
        this.parseCommen(annoPicture, parser);
        annoPicture.setUrl(this.getAttrStrValue(parser, "url"));
        return annoPicture;
    }

    private AnnoFPoint parsePoint(XmlPullParser parser) {
        String[] arr;
        int et = this.nextEventType(parser);
        String str = parser.getText();
        if (str != null && !"".equals(str) && (arr = str.split(",")) != null && arr.length == 2) {
            return new AnnoFPoint(this.strToFloat(arr[0]), this.strToFloat(arr[1]));
        }
        return null;
    }

    private AnnoCircle parseCircle(XmlPullParser parser) {
        AnnoCircle annoCircle = new AnnoCircle();
        this.parseCommen(annoCircle, parser);
        annoCircle.setLinesize(this.getAttrByteValue(parser, "linesize"));
        annoCircle.setArgbColor(this.parseColor(this.getAttrStrValue(parser, "color"), annoCircle));
        return annoCircle;
    }

    private AnnoCleaner parseCleaner(XmlPullParser parser) {
        AnnoCleaner cleaner = new AnnoCleaner();
        this.parseCommen(cleaner, parser);
        cleaner.setRemovedId(this.getAttrLongValue(parser, "removed"));
        return cleaner;
    }

    protected AnnoFreepenEx parseFreepenEx(XmlPullParser parser) {
        AnnoFreepenEx freepenEx = new AnnoFreepenEx();
        this.parseCommen(freepenEx, parser);
        freepenEx.setLinesize(this.getAttrByteValue(parser, "linesize"));
        freepenEx.setArgbColor(this.parseColor(this.getAttrStrValue(parser, "color"), freepenEx));
        freepenEx.setDelay(this.getAttrIntValue(parser, "delay"));
        String flag = this.getAttrStrValue(parser, "flag");
        if ("begin".equals(flag)) {
            freepenEx.setStepType(1);
        } else if ("add".equals(flag)) {
            freepenEx.setStepType(2);
        } else if ("end".equals(flag)) {
            freepenEx.setStepType(3);
        }
        return freepenEx;
    }

    private AnnoLineEx parseLineEx(XmlPullParser parser) {
        AnnoLineEx lineEx = new AnnoLineEx();
        this.parseCommen(lineEx, parser);
        lineEx.setLinesize(this.getAttrByteValue(parser, "linesize"));
        lineEx.setArgbColor(this.parseColor(this.getAttrStrValue(parser, "color"), lineEx));
        byte style = this.getAttrByteValue(parser, "style");
        if (style != -1) {
            lineEx.setLineType(style);
        }
        return lineEx;
    }

    private AnnoPointerEx parsePointerEx(XmlPullParser parser) {
        AnnoPointerEx pointerEx = new AnnoPointerEx();
        this.parseCommen(pointerEx, parser);
        byte style = this.getAttrByteValue(parser, "style");
        if (style != -1) {
            pointerEx.setPointerType((byte)((style + 1) % 2));
        }
        return pointerEx;
    }

    private AnnoRect parseRect(XmlPullParser parser) {
        AnnoRect rect = new AnnoRect();
        this.parseCommen(rect, parser);
        rect.setLinesize(this.getAttrByteValue(parser, "linesize"));
        rect.setArgbColor(this.parseColor(this.getAttrStrValue(parser, "color"), rect));
        return rect;
    }

    private AnnoText parseText(XmlPullParser parser) {
        AnnoText text = new AnnoText();
        this.parseCommen(text, parser);
        text.setFontsize(this.getAttrByteValue(parser, "fontsize"));
        text.setArgbColor(this.parseColor(this.getAttrStrValue(parser, "color"), text));
        return text;
    }

    private float strToFloat(String str) {
        if (str == null || "".equals(str)) {
            return 0.0f;
        }
        try {
            return Float.valueOf(str).floatValue();
        }
        catch (NumberFormatException e) {
            GenseeLog.e((String)TAG, (Throwable)e);
            return 0.0f;
        }
    }

    private void parseCommen(AbsAnno absAnno, XmlPullParser parser) {
        absAnno.setType(this.type);
        absAnno.setId(this.getAttrLongValue(parser, "id"));
        absAnno.setTimestamp(this.getAttrLongMcValue(parser, "timestamp"));
        absAnno.setDocId((int)this.getAttrLongValue(parser, "documentid"));
        absAnno.setPageId((int)this.getAttrLongValue(parser, "pageid"));
    }

    private int parseColor(String str, AbsAnno absAnno) {
        int color = 0;
        if (str != null && str.contains("#")) {
            String[] strArr = null;
            try {
                strArr = str.split(",");
            }
            catch (Exception e) {
                GenseeLog.e((String)TAG, (Throwable)e);
            }
            if (strArr != null && strArr.length > 0) {
                color = Color.parseColor((String)strArr[0]);
                if (strArr.length > 1 && !"1".equals(strArr[1]) && absAnno instanceof AnnoFreepen) {
                    color = color & 0xFFFFFF | 0x97000000;
                    absAnno.setHighLight(true);
                }
            }
        }
        return color;
    }

    protected void onEndDoc(XmlPullParser parser) {
    }

    protected void onStartDoc(XmlPullParser parser) {
    }

    public <T> T toParse(InputStream inputStream) {
        return null;
    }

    public static interface OnAnnoParseListener {
        public void onAnno(AbsAnno var1);
    }
}

