/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.media;

import android.media.AudioTimestamp;
import android.media.AudioTrack;

public class AudioTrackHelper {
    private final AudioTrack audioTrack;
    private long totalWrittenBytes = 0L;
    private int BYTES_PER_FRAME = 4;

    public AudioTrackHelper(AudioTrack audioTrack, int byteFrame) {
        this.audioTrack = audioTrack;
        this.BYTES_PER_FRAME = byteFrame;
    }

    public void addWrittenBytes(int writtenBytes) {
        this.totalWrittenBytes += (long)writtenBytes;
    }

    public long getUnplayedBytes() {
        AudioTimestamp timestamp = new AudioTimestamp();
        if (this.audioTrack.getTimestamp(timestamp)) {
            long playedFrames = timestamp.framePosition;
            long totalWrittenFrames = this.totalWrittenBytes / (long)this.BYTES_PER_FRAME;
            long unplayedFrames = totalWrittenFrames - playedFrames;
            return unplayedFrames * (long)this.BYTES_PER_FRAME;
        }
        return 0L;
    }
}

