/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.media;

import android.media.AudioTrack;
import android.os.Process;
import android.util.Log;
import com.gensee.common.GenseeConfig;
import com.gensee.heartbeat.GSWork;
import com.gensee.media.AVConfig;
import com.gensee.media.AudioTrackHelper;
import com.gensee.media.IVideoIndication;
import com.gensee.media.VideoData;
import com.gensee.parse.AnnotaionParse;
import com.gensee.pdu.GSDocView;
import com.gensee.pdu.PduPage;
import com.gensee.utils.GenseeLog;
import com.gensee.view.GSDocViewGx;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

public class AbsPlayer
extends GSWork {
    private static final String TAG = "AbsPlayer";
    private static final int MAX_CACHE_FRAME = 3;
    protected long nativeSink;
    protected String cachDir;
    protected IVideoIndication mVideoView;
    private int mH264Width;
    private int mH264Height;
    private int videoW;
    private int videoH;
    protected GSDocView mDocView;
    protected GSDocViewGx mGlDocView;
    protected PduPage mPage;
    protected AnnotaionParse parse;
    protected AudioTrack mTrack;
    private int nPlayerType = 0;
    private ExecutorService service;
    private List<VideoData> cacheVideoDataList;
    private List<AudioPkg> cacheAudioDataList;
    private byte[] byteDataCache;
    private AudioSynThread mSynThread;
    private int mAudioQueueSize = 0;
    private ViThread synViThread;
    private AudioTrackHelper audioHelper;
    private long lastRenderTime = -1L;

    protected void setPlayerType(int nPlayerType) {
        this.nPlayerType = nPlayerType;
    }

    public void setGSVideoView(IVideoIndication videoView) {
        GenseeLog.d((String)TAG, (String)("setGSVideoView " + videoView));
        this.mVideoView = videoView;
    }

    @Deprecated
    public void setDocView(GSDocView docView) {
        this.setGSDocView(docView);
    }

    public void setGSDocView(GSDocView docView) {
        GenseeLog.d((String)TAG, (String)("setGSDocView " + docView));
        this.mDocView = docView;
        if (null != this.mDocView && this.mPage != null) {
            this.mDocView.setDocPage(this.mPage);
        }
    }

    public void setGSDocViewGx(GSDocViewGx glDocView) {
        GenseeLog.d((String)TAG, (String)("setGSDocViewGx " + glDocView));
        this.mGlDocView = glDocView;
        if (null != this.mGlDocView && this.mPage != null) {
            this.mGlDocView.showDocPage(this.mPage);
        }
    }

    protected void initAudioPlayer() {
        if (this.mSynThread == null) {
            this.mSynThread = new AudioSynThread("AudioSynThread-1"){

                @Override
                protected void onRunStart() {
                    if (AbsPlayer.this.mTrack == null) {
                        int streamType = 3;
                        int frequence = AVConfig.getSampleRate();
                        if (frequence == 0 && (frequence = AudioTrack.getNativeOutputSampleRate((int)streamType)) > 48000) {
                            frequence = 16000;
                        }
                        int channelConfig = 2;
                        int audioEncoding = 2;
                        int bufferSize = AudioTrack.getMinBufferSize((int)frequence, (int)channelConfig, (int)audioEncoding);
                        AbsPlayer.this.mTrack = new AudioTrack(streamType, frequence, channelConfig, audioEncoding, bufferSize * 2, 1);
                        GenseeLog.d((String)AbsPlayer.TAG, (String)("initAudioPlayer frequence = " + frequence + " bufferSize = " + bufferSize + " streamtype = " + streamType));
                        int channelCount = AbsPlayer.this.mTrack.getChannelCount();
                        AbsPlayer.this.audioHelper = new AudioTrackHelper(AbsPlayer.this.mTrack, channelCount * 2);
                    }
                    if (3 != AbsPlayer.this.mTrack.getPlayState() && AbsPlayer.this.mTrack.getState() != 0) {
                        AbsPlayer.this.mTrack.play();
                    } else if (AbsPlayer.this.mTrack.getState() == 0) {
                        GenseeLog.e((String)AbsPlayer.TAG, (String)"initAudioPlayer error: AudioTrack UNINITIALIZED");
                    }
                    AbsPlayer.this.onAudioTrackCreated();
                }

                @Override
                protected void onRunEnd() {
                    if (AbsPlayer.this.mTrack != null) {
                        AbsPlayer.this.mTrack.release();
                    }
                    AbsPlayer.this.mTrack = null;
                    GenseeLog.i((String)AbsPlayer.TAG, (String)"release audioTrack");
                }
            };
            this.mSynThread.start();
        } else if (3 != this.mTrack.getPlayState() && this.mTrack.getState() != 0) {
            GenseeLog.e((String)TAG, (String)"initAudioPlayer error: AudioTrack UNINITIALIZED");
            this.mTrack.play();
        }
    }

    protected void onAudioTrackCreated() {
    }

    protected int getAudioState() {
        return this.mTrack == null ? -1 : this.mTrack.getPlayState();
    }

    protected void audioResume() {
        GenseeLog.d((String)TAG, (String)"audioResume");
        if (this.mTrack != null) {
            if (this.mTrack.getState() == 0) {
                GenseeLog.e((String)TAG, (String)"audioResume error: AudioTrack UNINITIALIZED");
                return;
            }
            int ps = this.mTrack.getPlayState();
            if (2 == ps || 1 == ps) {
                this.mTrack.play();
                GenseeLog.d((String)TAG, (String)"audioResume mTrack.play()");
            }
        }
    }

    protected void audioPause() {
        GenseeLog.d((String)TAG, (String)"audioPause");
        if (this.mTrack != null && 3 == this.mTrack.getPlayState()) {
            this.mTrack.pause();
            GenseeLog.d((String)TAG, (String)"audioPause mTrack.pause()");
        }
    }

    protected boolean audioDataPlay(ByteBuffer buffer, int len) {
        if (buffer == null) {
            return false;
        }
        if (null != this.mSynThread) {
            this.mSynThread.putPkg(this.wrapAudioData(buffer, len));
        }
        return false;
    }

    private AudioPkg wrapAudioData(ByteBuffer byteBuffer, int len) {
        AudioPkg data = null;
        if (null == this.cacheAudioDataList) {
            this.cacheAudioDataList = Collections.synchronizedList(new ArrayList());
        }
        for (int i = 0; i < this.cacheAudioDataList.size(); ++i) {
            AudioPkg tmp = this.cacheAudioDataList.get(i);
            if (!tmp.isUsed || tmp.buffer == null || tmp.buffer.length < byteBuffer.remaining()) continue;
            tmp.isUsed = false;
            tmp.len = len;
            byteBuffer.get(tmp.buffer, 0, len);
            data = tmp;
            break;
        }
        if (data == null) {
            byte[] b = new byte[byteBuffer.remaining()];
            byteBuffer.get(b, 0, b.length);
            data = new AudioPkg(len, b);
            this.cacheAudioDataList.add(data);
        }
        return data;
    }

    private boolean audioDataWrite(byte[] buffer, int len) {
        try {
            int sp;
            if (len > 0 && this.mTrack != null && 3 == (sp = this.mTrack.getPlayState())) {
                long t = System.currentTimeMillis();
                int writtenBytes = this.mTrack.write(buffer, 0, len);
                this.audioHelper.addWrittenBytes(writtenBytes);
                long l = System.currentTimeMillis();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    protected void audioStop() {
        int sp;
        if (this.mTrack != null && 1 != (sp = this.mTrack.getPlayState())) {
            this.mTrack.stop();
        }
    }

    protected void audioRelease() {
        this.mAudioQueueSize = 0;
        AudioSynThread tmp = this.mSynThread;
        this.mSynThread = null;
        if (tmp != null) {
            tmp.release();
        }
    }

    protected int getAudioQueueLen() {
        return this.mAudioQueueSize;
    }

    protected int getAudioDataSize() {
        int totalSize = 0;
        if (this.mSynThread != null) {
            totalSize = this.mSynThread.queueDataByteSize;
        }
        if (this.audioHelper != null) {
            totalSize = (int)((long)totalSize + this.audioHelper.getUnplayedBytes());
        }
        if (totalSize < 0) {
            GenseeLog.e((String)("getAudioDataSize \uff1atotalSize < 0 is" + totalSize));
        }
        return totalSize;
    }

    protected void audioQueueClear() {
        if (this.mSynThread != null) {
            this.mSynThread.dataQueueClear();
        }
    }

    protected void setVideoSize(int w, int h, boolean isReal) {
        if (isReal) {
            this.mH264Width = w;
            this.mH264Height = h;
            if (this.videoW == 0 || this.videoH == 0) {
                this.videoW = w;
                this.videoH = h;
            }
        } else {
            this.videoW = w;
            this.videoH = h;
        }
        if (this.synViThread == null) {
            ViThread t = this.synViThread = new ViThread("SynViThread-1");
            t.start();
            this.synViThread = t;
        }
    }

    protected void renderVideo(ByteBuffer byteBuffer) {
        VideoData wrapData;
        if (null == byteBuffer) {
            return;
        }
        if (null == this.byteDataCache || this.byteDataCache.length != byteBuffer.limit()) {
            this.byteDataCache = new byte[byteBuffer.limit()];
        }
        byteBuffer.position(0);
        byteBuffer.get(this.byteDataCache, 0, this.byteDataCache.length);
        if (this.synViThread != null && null != (wrapData = this.wrapVideoData(this.byteDataCache, this.mH264Width, this.mH264Height, this.videoW, this.videoH))) {
            this.synViThread.putPkg(wrapData);
        }
    }

    private VideoData wrapVideoData(byte[] byteData, int mH264Width, int mH264Height, int videoW, int videoH) {
        VideoData data = null;
        if (null == this.cacheVideoDataList) {
            this.cacheVideoDataList = Collections.synchronizedList(new ArrayList());
        }
        for (int i = 0; i < this.cacheVideoDataList.size(); ++i) {
            VideoData tmp = this.cacheVideoDataList.get(i);
            if (null != tmp.data && tmp.data.length != byteData.length) {
                this.cacheVideoDataList.clear();
                break;
            }
            if (!tmp.isUsed || tmp.data == null) continue;
            tmp.isUsed = false;
            System.arraycopy(byteData, 0, tmp.data, 0, byteData.length);
            tmp.userId = 0L;
            tmp.width = mH264Width;
            tmp.height = mH264Height;
            tmp.displayW = videoW;
            tmp.displayH = videoH;
            data = tmp;
            break;
        }
        if (data == null) {
            byte[] b = new byte[byteData.length];
            System.arraycopy(byteData, 0, b, 0, byteData.length);
            data = new VideoData(b, 0L, mH264Width, mH264Height, videoW, videoH);
            this.cacheVideoDataList.add(data);
        }
        if (this.cacheVideoDataList.size() > 5) {
            this.cacheVideoDataList.remove(0);
        }
        return data;
    }

    protected void renderPage(byte[] data, int dwLen, int dwPageW, int dwPageH) {
        if (data != null && dwLen > 0) {
            String path = new String(data);
            this.renderPage(path, dwPageW, dwPageH);
        } else {
            GenseeLog.w((String)"renderPage data is null");
        }
    }

    protected void renderPage(byte[] data, int dwLen, int dwPageW, int dwPageH, String sAnimationPath) {
        if (System.currentTimeMillis() - this.lastRenderTime <= 100L) {
            GenseeLog.d((String)TAG, (String)("drop msg ,interval: " + (System.currentTimeMillis() - this.lastRenderTime) + "ms"));
            return;
        }
        this.lastRenderTime = System.currentTimeMillis();
        if (data != null && dwLen > 0) {
            String path = new String(data);
            this.renderPage(path, dwPageW, dwPageH, sAnimationPath);
            GenseeLog.d((String)TAG, (String)("renderPage swf swfpath = " + path + " sAnimationPath = " + sAnimationPath));
        } else {
            GenseeLog.w((String)"renderPage data is null");
        }
    }

    protected void renderPage(String path, int dwPageW, int dwPageH) {
        if (this.mPage != null) {
            this.mPage.clear();
        }
        this.mPage = new PduPage();
        if (this.nPlayerType == 0) {
            this.mPage.setSdkType(1);
        } else {
            this.mPage.setSdkType(2);
        }
        this.mPage.setPageId((int)System.currentTimeMillis());
        this.mPage.setImgWidth((short)dwPageW);
        this.mPage.setImgHeight((short)dwPageH);
        if (path != null) {
            this.mPage.setPath(this.checkPng(path));
        } else {
            GenseeLog.w((String)TAG, (String)"renderPage path data is null");
        }
        if (this.mDocView != null) {
            this.mDocView.setDocPage(this.mPage);
        }
    }

    private String checkPng(String oldPath) {
        File f;
        if (oldPath != null && oldPath.endsWith(".png.1") && !(f = new File(oldPath)).exists()) {
            return oldPath.substring(0, oldPath.length() - 2);
        }
        return oldPath;
    }

    protected void renderPage(final String swfPath, int dwPageW, int dwPageH, String annimationPath) {
        GenseeLog.d((String)TAG, (String)("renderPage path = " + swfPath + " anim = " + annimationPath));
        PduPage tmp = this.mPage;
        if (tmp != null) {
            tmp.clear();
        }
        tmp = this.mPage = new PduPage();
        if (this.nPlayerType == 0) {
            tmp.setSdkType(1);
        } else {
            tmp.setSdkType(2);
        }
        tmp.setPageId((int)System.currentTimeMillis());
        tmp.setImgWidth((short)dwPageW);
        tmp.setImgHeight((short)dwPageH);
        if (swfPath != null) {
            tmp.setPath(this.checkPng(swfPath));
            tmp.setAnimationPath(annimationPath);
        } else {
            GenseeLog.w((String)TAG, (String)"renderPage path data is null");
        }
        final PduPage page = tmp;
        this.postPool(new Runnable(){

            @Override
            public void run() {
                if (swfPath != null && swfPath.endsWith(".swf")) {
                    AbsPlayer.this.mGlDocView.showDocPage(page);
                } else {
                    AbsPlayer.this.mDocView.showDocPage(page);
                }
            }
        });
    }

    protected void renderPageAnimation(int step) {
        PduPage p = this.mPage;
        if (null != p) {
            p.setAniStep(step);
        }
    }

    protected void renderAnno(String strAnnoXML) {
        if (this.mPage == null) {
            return;
        }
        this.mPage.receiveAnno(strAnnoXML, this.checkAnno());
    }

    protected boolean checkAnno() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void postPool(Runnable r) {
        if (this.service == null) {
            Class<AbsPlayer> clazz = AbsPlayer.class;
            // MONITORENTER : com.gensee.media.AbsPlayer.class
            if (this.service == null) {
                this.service = Executors.newSingleThreadExecutor();
            }
            // MONITOREXIT : clazz
        }
        this.service.submit(r);
    }

    protected void shutdownTreadPool() {
        ExecutorService s = this.service;
        this.service = null;
        if (s != null) {
            s.shutdown();
        }
    }

    public boolean release() {
        Log.i((String)TAG, (String)"release: ");
        this.mVideoView = null;
        this.mDocView = null;
        this.mGlDocView = null;
        this.mPage = null;
        this.videoW = 0;
        this.videoH = 0;
        this.byteDataCache = null;
        ViThread t = this.synViThread;
        this.synViThread = null;
        if (null != this.cacheVideoDataList) {
            this.cacheVideoDataList.clear();
            this.cacheVideoDataList = null;
        }
        if (t != null) {
            t.release();
        }
        return true;
    }

    public static class PlayerType {
        public static final int RTMP_PLAYER_TYPE = 0;
        public static final int VOD_PLAYER_TYPE = 1;
    }

    private class AudioSynThread
    extends DataThread<AudioPkg> {
        int queueDataByteSize;

        public AudioSynThread(String name) {
            super(name);
            this.queueDataByteSize = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onOutData(AudioPkg pkg) {
            if (pkg.buffer != null) {
                Object object = this.lock;
                synchronized (object) {
                    this.queueDataByteSize -= pkg.len;
                }
                AbsPlayer.this.audioDataWrite(pkg.buffer, pkg.len);
                pkg.isUsed = true;
            }
        }

        @Override
        protected void onQueneSize(int size) {
            AbsPlayer.this.mAudioQueueSize = size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean onPutPkg(LinkedList<AudioPkg> dataQue, AudioPkg dataPkg) {
            Object object = this.lock;
            synchronized (object) {
                this.queueDataByteSize += dataPkg.len;
            }
            return super.onPutPkg(dataQue, dataPkg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            Object object = this.lock;
            synchronized (object) {
                this.dataQue.clear();
                this.queueDataByteSize = 0;
                this.lock.notifyAll();
            }
            this.onRunEnd();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dataQueueClear() {
            Object object = this.lock;
            synchronized (object) {
                this.dataQue.clear();
                this.queueDataByteSize = 0;
            }
        }
    }

    private class ViThread
    extends DataThread<VideoData> {
        private Random random;

        public ViThread(String name) {
            super(name);
        }

        @Override
        protected void onOutData(VideoData data) {
            byte[] buff = data.getData();
            IVideoIndication view = AbsPlayer.this.mVideoView;
            if (view != null && buff != null) {
                int videoLen = buff.length;
                if (videoLen == 0) {
                    GenseeLog.w((String)("renderVideo fail , videoData length err " + videoLen + " w = " + AbsPlayer.this.mH264Width + " h = " + AbsPlayer.this.mH264Height));
                } else {
                    view.onReceiveFrame(data);
                }
            } else {
                GenseeLog.w((String)"renderVideo fail , view / buff is null");
            }
            data.isUsed = true;
        }

        @Override
        protected void onRunStart() {
            Process.setThreadPriority((int)-8);
        }

        @Override
        protected boolean onPutPkg(LinkedList<VideoData> dataQue, VideoData dataPkg) {
            int size = dataQue.size();
            if (!GenseeConfig.isPVHardDecode && GenseeConfig.viColorSpace != 255 && size >= 3) {
                if (this.random == null) {
                    this.random = new Random();
                }
                int rd = this.random.nextInt(3);
                VideoData removed = dataQue.remove(rd);
                removed.isUsed = true;
                GenseeLog.d((String)AbsPlayer.TAG, (String)("onPutPkg video size = " + size + " random = " + rd));
            }
            return super.onPutPkg(dataQue, dataPkg);
        }
    }

    private static abstract class DataThread<T>
    extends Thread {
        protected final Object lock = new Object();
        protected final AtomicBoolean isRunning = new AtomicBoolean(false);
        protected final LinkedList<T> dataQue = new LinkedList();

        public DataThread(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.onRunStart();
            this.isRunning.set(true);
            this.dataQue.clear();
            while (this.isRunning.get()) {
                T pkg = null;
                Object object = this.lock;
                synchronized (object) {
                    block8: {
                        try {
                            int mQueueSize = this.dataQue.size();
                            this.onQueneSize(mQueueSize);
                            if (mQueueSize > 0) {
                                pkg = this.dataQue.pop();
                                break block8;
                            }
                            if (this.isRunning.get()) {
                                this.lock.wait();
                                break block8;
                            }
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (pkg == null || !this.isRunning.get()) continue;
                this.onOutData(pkg);
            }
            this.onRunEnd();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            this.isRunning.set(false);
            Object object = this.lock;
            synchronized (object) {
                this.dataQue.clear();
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean putPkg(T dataPkg) {
            Object object = this.lock;
            synchronized (object) {
                if (this.isRunning.get()) {
                    boolean ret = this.onPutPkg(this.dataQue, dataPkg);
                    this.lock.notifyAll();
                    return ret;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dataQueueClear() {
            Object object = this.lock;
            synchronized (object) {
                this.dataQue.clear();
            }
        }

        protected boolean onPutPkg(LinkedList<T> dataQue, T dataPkg) {
            return dataQue.add(dataPkg);
        }

        protected void onQueneSize(int size) {
        }

        protected abstract void onOutData(T var1);

        protected void onRunStart() {
        }

        protected void onRunEnd() {
        }
    }

    private static class AudioPkg {
        protected byte[] buffer;
        public boolean isUsed;
        public int len;

        private AudioPkg(int len, byte[] buffer) {
            this.len = len;
            this.buffer = buffer;
        }
    }
}

