/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.method.BaseMovementMethod;
import android.text.method.MovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import com.gensee.chat.gif.GifDrawalbe;
import com.gensee.chat.gif.SpanResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MyTextViewEx
extends TextView
implements GifDrawalbe.UpdateUIListen {
    private Vector<Drawable> drawables = new Vector();
    private static final String SPAN_LOWER_START = "<span>";
    private static final String SPAN_LOWER_END = "</span>";
    private static final String SPAN_UPER_START = "<SPAN>";
    private static final String SPAN_UPER_END = "</SPAN>";
    private long downTime;
    private long moveTime;
    private long upTime;
    private boolean canLongClick;
    private MyTextViewExClickListener onMyTextViewExClickListener;

    public MyTextViewEx(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setMyClickListener(MyTextViewExClickListener onMyTextViewExClickListener) {
        this.onMyTextViewExClickListener = onMyTextViewExClickListener;
    }

    public MyTextViewEx(Context context, AttributeSet attr) {
        this(context, attr, 0);
    }

    public MyTextViewEx(Context context) {
        this(context, null);
    }

    private List<LinkBean> getLinkFromText(Spanned text) {
        String regexp = "((http[s]{0,1})://[a-zA-Z0-9\\.\\-]+\\.([a-zA-Z]{2,4})(:\\d+)?(/[a-zA-Z0-9\\.\\-~!@#$%^&*+?:_/=<>]*)?)|(www.[a-zA-Z0-9\\.\\-]+\\.([a-zA-Z]{2,4})(:\\d+)?(/[a-zA-Z0-9\\.\\-~!@#$%^&*+?:_/=<>]*)?)";
        Pattern pattern = Pattern.compile(regexp);
        ArrayList<LinkBean> linkBeans = new ArrayList<LinkBean>();
        Matcher matcher = pattern.matcher((CharSequence)text);
        while (matcher.find()) {
            String url = matcher.group();
            linkBeans.add(new LinkBean(url, matcher.start(), matcher.end()));
        }
        return linkBeans;
    }

    public void setRichText(String richText) {
        this.insertGif(richText);
    }

    public void setRichTextEnableLink(String richText, int linkColor, final SpanClickCallback clickCallback) {
        if (richText == null) {
            Log.w((String)"Gensee", (String)"MyTextViewEx insertGif chat message is null");
            return;
        }
        if (null == this.drawables) {
            this.drawables = new Vector();
        }
        Spanned spanned = SpanResource.convetRichToExpression(this.getContext(), richText, this.drawables);
        this.setClickableMovementMethod();
        SpannableStringBuilder sp = new SpannableStringBuilder((CharSequence)spanned);
        List<LinkBean> linkBeans = this.getLinkFromText(spanned);
        for (int i = 0; i < linkBeans.size(); ++i) {
            final LinkBean lb = linkBeans.get(i);
            sp.setSpan((Object)new ClickableSpan(){

                public void onClick(View widget) {
                    clickCallback.onSpanClick(lb.textUrl);
                }
            }, lb.startIndex, lb.endIndex, 33);
            sp.setSpan((Object)new ForegroundColorSpan(linkColor), lb.startIndex, lb.endIndex, 33);
        }
        this.setText((CharSequence)sp, TextView.BufferType.SPANNABLE);
        for (Drawable gifDrawable : this.drawables) {
            if (!(gifDrawable instanceof GifDrawalbe)) break;
            ((GifDrawalbe)gifDrawable).addListen(this);
            ((GifDrawalbe)gifDrawable).readFrames(true);
        }
    }

    private void setClickableMovementMethod() {
        this.setMovementMethod((MovementMethod)ClickableMovementMethod.getInstance());
        this.setFocusable(false);
        this.setClickable(false);
        this.setLongClickable(false);
    }

    public void setChatContent(String text, String richText) {
        if (text == null && richText == null) {
            return;
        }
        if (richText == null) {
            this.setChatText(text);
            return;
        }
        if (richText.equals(text)) {
            this.setChatText(text);
        } else {
            this.setRichText(richText);
        }
    }

    private void setChatText(String text) {
        String string = text = text == null ? "" : text;
        if (text.startsWith(SPAN_LOWER_START) && text.endsWith(SPAN_LOWER_END) || text.startsWith(SPAN_UPER_START) && text.endsWith(SPAN_UPER_END)) {
            text = text.substring(SPAN_LOWER_START.length(), text.length() - SPAN_LOWER_END.length());
        }
        this.setText(text);
    }

    private void insertGif(String str) {
        if (str == null) {
            Log.w((String)"Gensee", (String)"MyTextViewEx insertGif chat message is null");
            return;
        }
        if (null == this.drawables) {
            this.drawables = new Vector();
        }
        Spanned spannableString = SpanResource.convetRichToExpression(this.getContext(), str, this.drawables);
        this.setText((CharSequence)spannableString);
        for (Drawable gifDrawable : this.drawables) {
            if (!(gifDrawable instanceof GifDrawalbe)) break;
            ((GifDrawalbe)gifDrawable).addListen(this);
            ((GifDrawalbe)gifDrawable).readFrames(true);
        }
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (visibility == 8 && null != this.drawables) {
            for (Drawable gifDrawable : this.drawables) {
                if (!(gifDrawable instanceof GifDrawalbe)) break;
                ((GifDrawalbe)gifDrawable).removeListen(this);
            }
            this.destroy();
        }
    }

    private void destroy() {
        this.drawables.clear();
        this.drawables = null;
    }

    @Override
    public void updateUI() {
        this.postInvalidate();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 0) {
            this.canLongClick = true;
            this.downTime = System.currentTimeMillis();
        } else if (event.getAction() == 2) {
            this.moveTime = System.currentTimeMillis();
            if (this.moveTime - this.downTime > 500L && this.canLongClick) {
                this.canLongClick = false;
                if (this.onMyTextViewExClickListener != null) {
                    this.onMyTextViewExClickListener.onLongClick();
                }
                return false;
            }
        } else if (event.getAction() == 1) {
            this.upTime = System.currentTimeMillis();
            if (this.upTime - this.downTime < 250L && this.onMyTextViewExClickListener != null) {
                this.onMyTextViewExClickListener.onClick("empty url");
            }
        }
        return super.onTouchEvent(event);
    }

    public static interface MyTextViewExClickListener {
        public void onLongClick();

        public void onClick(String var1);
    }

    public static class ClickableMovementMethod
    extends BaseMovementMethod {
        private static ClickableMovementMethod sInstance;
        long actionDown;
        long actionUp;

        public static ClickableMovementMethod getInstance() {
            if (sInstance == null) {
                sInstance = new ClickableMovementMethod();
            }
            return sInstance;
        }

        public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
            int action = event.getActionMasked();
            if (action == 1 || action == 0) {
                int line;
                if (action == 0) {
                    this.actionDown = System.currentTimeMillis();
                }
                int x = (int)event.getX();
                int y = (int)event.getY();
                x -= widget.getTotalPaddingLeft();
                y -= widget.getTotalPaddingTop();
                Layout layout = widget.getLayout();
                int off = layout.getOffsetForHorizontal(line = layout.getLineForVertical(y += widget.getScrollY()), (float)(x += widget.getScrollX()));
                ClickableSpan[] link = (ClickableSpan[])buffer.getSpans(off, off, ClickableSpan.class);
                if (link.length > 0) {
                    if (action == 1) {
                        this.actionUp = System.currentTimeMillis();
                        if (this.actionUp - this.actionDown > 500L) {
                            return false;
                        }
                        link[0].onClick((View)widget);
                    } else {
                        Selection.setSelection((Spannable)buffer, (int)buffer.getSpanStart((Object)link[0]), (int)buffer.getSpanEnd((Object)link[0]));
                    }
                    return true;
                }
                Selection.removeSelection((Spannable)buffer);
            }
            return false;
        }

        public void initialize(TextView widget, Spannable text) {
            Selection.removeSelection((Spannable)text);
        }
    }

    public static class LinkBean {
        public String textUrl;
        public int startIndex;
        public int endIndex;

        public LinkBean(String textUrl, int startIndex, int endIndex) {
            this.textUrl = textUrl;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }
    }

    public static interface SpanClickCallback {
        public void onSpanClick(String var1);
    }
}

