/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.content.Context;
import android.text.InputFilter;
import android.text.Spanned;
import android.util.AttributeSet;
import android.widget.EditText;
import com.gensee.chat.gif.IStrFilter;
import com.gensee.chat.gif.SpanResource;
import com.gensee.chatfilter.GSFilterMannager;
import com.gensee.chatfilter.IGSTextFilter;
import com.gensee.chatfilter.OnFilterSendText;
import com.gensee.entity.SendText;
import com.gensee.utils.GenseeLog;

public class ChatEditText
extends EditText {
    private static final String TAG = "ChatEditText";
    private OnSensitiveWordFilter mfilter;
    private SendText mSendText;
    private int contentMaxLen = 512;
    private int avaterMaxCount = 20;
    private int style = 0;

    public ChatEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public ChatEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ChatEditText(Context context) {
        super(context);
        this.init();
    }

    public void insertAvatar(String avatar, int resId) {
        this.getText().insert(this.getSelectionStart(), (CharSequence)SpanResource.convetToSpan(avatar, this.getContext()));
    }

    private void init() {
        this.setFilters(new InputFilter[]{new InputFilter(){

            public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
                int[] nAvatarCountOld = SpanResource.getAvatarCount(dest.toString());
                int totalCountOld = dest.toString().length() - nAvatarCountOld[1] + nAvatarCountOld[0];
                int[] nAvatarCountNew = SpanResource.getAvatarCount(source.toString());
                int totalCountNew = source.toString().length() - nAvatarCountNew[1] + nAvatarCountNew[0];
                int totalAvatarCount = nAvatarCountOld[0] + nAvatarCountNew[0];
                int totalCount = totalCountOld + totalCountNew;
                if (totalAvatarCount > ChatEditText.this.avaterMaxCount || totalCount > ChatEditText.this.contentMaxLen) {
                    return "";
                }
                return source;
            }
        }});
    }

    @Deprecated
    public String getChatText() {
        return this.getSendText().getChatText();
    }

    @Deprecated
    public String getRichText() {
        return this.getSendText().getRichText();
    }

    public SendText getSendText() {
        String text;
        if (this.mSendText == null) {
            this.mSendText = new SendText();
        }
        if ((text = this.getText().toString()).equals(this.mSendText.getSrc())) {
            return this.mSendText;
        }
        this.mSendText.setSrc(text);
        String chatText = "";
        String richText = "";
        this.mSendText.setRichText(richText);
        this.mSendText.setChatText(chatText);
        if (!"".equals(text)) {
            SpanResource.convertToSendText(text, this.mSendText, this.mfilter, this.getCurrentTextColor(), this.style == 3 || this.style == 1, this.style == 2 || this.style == 3);
        }
        return this.mSendText;
    }

    public void setTypeface(int style) {
        this.style = style;
        this.setTypeface(this.getTypeface(), style);
    }

    public void getSendText(OnFilterSendText onFilterSendText) {
        String text;
        IGSTextFilter onWordFilter = GSFilterMannager.getIns().getOnWordFilter();
        if (null == onFilterSendText) {
            GenseeLog.d((String)TAG, (String)"onFilterSendText=null");
            this.getSendText();
            return;
        }
        if (null == onWordFilter) {
            GenseeLog.d((String)TAG, (String)"onWordFilter=null");
            SendText sendText = this.getSendText();
            onFilterSendText.sendText(sendText.getChatText(), sendText.getRichText());
            return;
        }
        if (this.mSendText == null) {
            this.mSendText = new SendText();
        }
        if ((text = this.getText().toString()).equals(this.mSendText.getSrc())) {
            onFilterSendText.sendText(this.mSendText.getChatText(), this.mSendText.getRichText());
            return;
        }
        this.mSendText.setSrc(text);
        String chatText = "";
        String richText = "";
        this.mSendText.setRichText(richText);
        this.mSendText.setChatText(chatText);
        if (!"".equals(text)) {
            SpanResource.textFilter(text, this.mSendText, onFilterSendText, this.getCurrentTextColor(), this.style == 3 || this.style == 1, this.style == 2 || this.style == 3);
        }
    }

    public void setOnSensitiveWordFilter(OnSensitiveWordFilter mfilter) {
        this.mfilter = mfilter;
    }

    public void setContentCharMax(int max) {
        this.contentMaxLen = max;
    }

    public void setAvaterMax(int max) {
        this.avaterMaxCount = max;
    }

    public static interface OnSensitiveWordFilter
    extends IStrFilter {
    }
}

