/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.chat.gif;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Html;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.style.ImageSpan;
import android.util.Log;
import com.gensee.chat.gif.IStrFilter;
import com.gensee.chatfilter.GSFilterMannager;
import com.gensee.chatfilter.IGSTextFilter;
import com.gensee.chatfilter.OnFilterSendText;
import com.gensee.chatfilter.OnGSTextFilterListener;
import com.gensee.entity.FilterText;
import com.gensee.entity.SendText;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SpanResource {
    private static final String RICH_BROW = "<IMG src=\"emotion\\%s\" custom=\"false\">";
    public static String matchString;
    private static Map<String, Drawable> uiMap;
    private static Map<String, Integer> browMap;
    private static Map<String, String> richSendMap;
    private static Map<String, String> textMap;
    private static Map<String, Drawable> gifMap;
    private static List<String> textTipList;
    private static Map<Character, String> htmlEscapeCharacter;
    private static List<FilterText> filterTexts;
    private static ConcurrentLinkedQueue<FilterBean> filterList;
    private static AtomicBoolean isFiltering;
    public static final int CONTEXT_MAX = 512;
    public static final int CONTEXT_AVATAR_MAX = 20;
    private static Html.ImageGetter extraImageGetter;

    static void setExtraImageGetter(Html.ImageGetter extraImageGetter) {
        SpanResource.extraImageGetter = extraImageGetter;
    }

    public static Map<String, Drawable> getBrowMap(Context context) {
        return uiMap;
    }

    public static void resetState() {
        isFiltering.set(false);
    }

    static void initTextTipList(List<String> textList) {
        if (null == textTipList) {
            textTipList = new ArrayList<String>();
        }
        textTipList.clear();
        textTipList.addAll(textList);
    }

    static void initTextMap(HashMap<String, String> mapValue) {
        if (null == textMap) {
            textMap = new HashMap<String, String>(18);
        }
        textMap.clear();
        textMap.putAll(mapValue);
    }

    static void initUiMap(HashMap<String, Drawable> mapValue) {
        if (null == uiMap) {
            uiMap = new LinkedHashMap<String, Drawable>(18);
        }
        uiMap.clear();
        uiMap.putAll(mapValue);
    }

    static void initBrowSource(LinkedHashMap<String, Integer> mapValue) {
        if (browMap == null) {
            browMap = new LinkedHashMap<String, Integer>(18);
        }
        browMap.clear();
        browMap.putAll(mapValue);
    }

    static void putGifDrawable(String key, Drawable gifDrawable) {
        if (gifMap == null) {
            gifMap = new HashMap<String, Drawable>(18);
        }
        gifMap.put(key, gifDrawable);
    }

    static void initSendRichMap(HashMap<String, String> mapValue) {
        if (matchString == null) {
            matchString = SpanResource.initMachString(uiMap.keySet());
            matchString = matchString.substring(0, matchString.length() - 1);
        }
        if (richSendMap == null) {
            richSendMap = new HashMap<String, String>(18);
        }
        richSendMap.clear();
        richSendMap.putAll(mapValue);
    }

    private static synchronized String initMachString(Set<String> keyset) {
        StringBuilder sb = new StringBuilder();
        for (String key : keyset) {
            sb.append(key).append('|');
        }
        return sb.toString();
    }

    public static Spannable convetToSpan(String content, Context context) {
        StringBuilder sb = new StringBuilder();
        String strContent = sb.append(' ').append(content).toString();
        strContent = content;
        SpannableStringBuilder spBuilder = new SpannableStringBuilder((CharSequence)strContent);
        if (null == uiMap || uiMap.size() <= 0) {
            return spBuilder;
        }
        Pattern mPattern = Pattern.compile(matchString);
        Matcher matcher = mPattern.matcher(strContent);
        while (matcher.find()) {
            Drawable drawable = uiMap.get(matcher.group());
            drawable.setBounds(0, 0, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
            ImageSpan ispan = new ImageSpan(drawable, 0);
            spBuilder.setSpan((Object)ispan, matcher.start(), matcher.end(), 33);
        }
        return spBuilder;
    }

    public static int[] getAvatarCount(String content) {
        int[] nCount = new int[3];
        if (null != matchString) {
            StringBuilder sb = new StringBuilder();
            String strContent = sb.append(' ').append(content).toString();
            strContent = content;
            Pattern mPattern = Pattern.compile(matchString);
            Matcher matcher = mPattern.matcher(strContent);
            while (matcher.find()) {
                nCount[0] = nCount[0] + 1;
                nCount[1] = nCount[1] + matcher.group().length();
                nCount[2] = matcher.group().length();
            }
        }
        return nCount;
    }

    public static Spanned convetRichToExpression(Context context, String rich, final Vector<Drawable> drawables) {
        Html.ImageGetter imageGetter = new Html.ImageGetter(){

            public Drawable getDrawable(String source) {
                if (null == source) {
                    return null;
                }
                int index = source.lastIndexOf("\\");
                String lastStr = source.substring(index + 1);
                String keyStr = "\u3010" + lastStr + "\u3011";
                Drawable mSmile = null;
                if (source.endsWith(".gif")) {
                    if (gifMap != null) {
                        mSmile = (Drawable)gifMap.get(keyStr);
                        if (null != drawables && mSmile != null && !drawables.contains(mSmile)) {
                            drawables.add(mSmile);
                        }
                    } else {
                        SpanResource.log("convetRichToExpression", "gifMap is null, that expression un install");
                    }
                } else if (uiMap != null) {
                    mSmile = (Drawable)uiMap.get(keyStr);
                } else {
                    SpanResource.log("convetRichToExpression", "uiMap is null, that expression un install");
                }
                if (mSmile == null && extraImageGetter != null) {
                    mSmile = extraImageGetter.getDrawable(source);
                }
                return mSmile;
            }
        };
        if (Build.VERSION.SDK_INT < 24) {
            return Html.fromHtml((String)rich, (Html.ImageGetter)imageGetter, null);
        }
        return Html.fromHtml((String)rich, (int)256, (Html.ImageGetter)imageGetter, null);
    }

    public static void convertToSendText(String content, SendText sendText, IStrFilter filter, int color, boolean bold, boolean italic) {
        Log.i((String)"mSendText", (String)("convertToSendText content=[" + content + "],content.length()=[" + content.length() + "],sendText=[" + sendText + "],filter=[" + filter + "]"));
        StringBuilder textBuilder = new StringBuilder();
        StringBuilder richBuilder = new StringBuilder();
        String filterStr = content;
        if (matchString != null) {
            Pattern mPattern = Pattern.compile(matchString);
            Matcher matcher = mPattern.matcher(content);
            int pos = 0;
            while (matcher.find()) {
                filterStr = content.substring(pos, matcher.start());
                pos = matcher.end();
                String group = matcher.group();
                if (filter != null) {
                    filterStr = filter.onFilter(filterStr);
                }
                if (textMap != null && textMap.containsKey(group)) {
                    textBuilder.append(filterStr).append(textMap.get(group));
                } else {
                    textBuilder.append(filterStr).append(group);
                }
                filterStr = SpanResource.escapeStr(filterStr);
                if (richSendMap != null && richSendMap.containsKey(group)) {
                    richBuilder.append(filterStr).append(String.format(RICH_BROW, richSendMap.get(matcher.group())));
                    continue;
                }
                richBuilder.append(filterStr).append(group);
            }
            filterStr = content.substring(pos, content.length());
        }
        if (filter != null) {
            filterStr = filter.onFilter(filterStr);
        }
        textBuilder.append(filterStr);
        richBuilder.append(SpanResource.escapeStr(filterStr));
        sendText.setChatText(textBuilder.toString());
        String richtext = SpanResource.roundSpan(richBuilder.toString(), color, bold, italic);
        sendText.setRichText(richtext);
        Log.i((String)"mSendText", (String)("convertToSendText rich " + richtext));
    }

    private static String escapeStr(String content) {
        if (content == null || content.length() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Map<Character, String> map = SpanResource.htmlEscapeCharacterMap();
        for (int index = 0; index < content.length(); ++index) {
            char c = content.charAt(index);
            if (map.containsKey(Character.valueOf(c))) {
                sb.append(map.get(Character.valueOf(c)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static void log(String func, String msg) {
        GenseeLog.w((String)"Gensee", (String)(func + " > " + msg));
    }

    public static String filterRichText(String richText, IStrFilter filter) {
        int pos = 0;
        int len = richText.length();
        StringBuilder sb = new StringBuilder();
        int preTag = 0;
        while (pos < len) {
            char c = richText.charAt(pos);
            ++pos;
            switch (c) {
                case '<': {
                    if (preTag > 0 && pos > preTag + 2) {
                        String sub = richText.substring(preTag + 1, pos - 1);
                        SpanResource.filterStrOfRichHtml(sub, sb, filter);
                    }
                    sb.append(c);
                    preTag = pos = SpanResource.endLable(pos, richText, '>', sb);
                    break;
                }
            }
        }
        String sub = richText.substring(preTag == 0 ? 0 : preTag + 1, len);
        SpanResource.filterStrOfRichHtml(sub, sb, filter);
        return sb.toString();
    }

    private static void filterStrOfRichHtml(String src, StringBuilder sb, IStrFilter filter) {
        if (filter != null) {
            Set<Map.Entry<Character, String>> sets = SpanResource.htmlEscapeCharacterMap().entrySet();
            for (Map.Entry<Character, String> set : sets) {
                src = src.replace(set.getValue(), String.valueOf(set.getKey()));
            }
            src = filter.onFilter(src);
            src = SpanResource.escapeStr(src);
        }
        sb.append(src);
    }

    private static int endLable(int pos, String src, char endLableChar, StringBuilder sb) {
        int len = src.length();
        while (pos < len) {
            char c = src.charAt(pos);
            sb.append(c);
            if (c == endLableChar) break;
            ++pos;
        }
        return pos;
    }

    private static Map<Character, String> htmlEscapeCharacterMap() {
        if (htmlEscapeCharacter == null) {
            htmlEscapeCharacter = new HashMap<Character, String>(6);
            htmlEscapeCharacter.put(Character.valueOf('&'), "&amp;");
            htmlEscapeCharacter.put(Character.valueOf('<'), "&lt;");
            htmlEscapeCharacter.put(Character.valueOf('>'), "&gt;");
            htmlEscapeCharacter.put(Character.valueOf(' '), "&nbsp;");
            htmlEscapeCharacter.put(Character.valueOf('\n'), "<br>");
            htmlEscapeCharacter.put(Character.valueOf('\"'), "&quot;");
        }
        return htmlEscapeCharacter;
    }

    public static void textFilter(String content, SendText sendText, OnFilterSendText filterText, int color, boolean bold, boolean italic) {
        FilterBean bean = new FilterBean(content, sendText, filterText, color, bold, italic);
        if (isFiltering.get()) {
            filterList.offer(bean);
        } else {
            isFiltering.set(true);
            SpanResource.textFiltering(bean);
        }
    }

    private static void textFiltering(final FilterBean filterBean) {
        IGSTextFilter wordFilter = GSFilterMannager.getIns().getOnWordFilter();
        String contentFilter = filterBean.content;
        if (StringUtil.isEmpty((String)contentFilter) || wordFilter == null) {
            SpanResource.filterToSendText(filterBean.content, filterBean);
            SpanResource.nextTextFilter();
            return;
        }
        wordFilter.textFilter(contentFilter, new OnGSTextFilterListener(){

            public void onTextFilter(String content) {
                SpanResource.filterToSendText(content, filterBean);
                SpanResource.nextTextFilter();
            }
        });
    }

    private static void nextTextFilter() {
        if (filterList.size() > 0) {
            SpanResource.textFiltering(filterList.poll());
        } else {
            isFiltering.set(false);
        }
    }

    private static String findFilterText(String content) {
        filterTexts.clear();
        StringBuilder textBuilder = new StringBuilder();
        String filterStr = content;
        if (matchString != null) {
            Pattern mPattern = Pattern.compile(matchString);
            Matcher matcher = mPattern.matcher(content);
            int pos = 0;
            while (matcher.find()) {
                filterStr = content.substring(pos, matcher.start());
                pos = matcher.end();
                String group = matcher.group();
                textBuilder.append(filterStr);
                filterTexts.add(new FilterText(group, matcher.start(), matcher.end()));
            }
            filterStr = content.substring(pos);
        }
        textBuilder.append(filterStr);
        String contentFilter = textBuilder.toString();
        SpanResource.log("findFilterText", "filterStr=[" + filterStr + "],filterTexts.size()=[" + filterTexts.size() + "],contentFilter=[" + contentFilter + "]");
        return contentFilter;
    }

    private static void filterToSendText(String filterContent, FilterBean filterBean) {
        SendText sendText = filterBean.sendText;
        OnFilterSendText iFilterText = filterBean.onFilterSendText;
        int color = filterBean.color;
        boolean bold = filterBean.bold;
        boolean italic = filterBean.italic;
        StringBuilder richBuilder = new StringBuilder();
        StringBuilder textMapBuilder = new StringBuilder();
        String filterStr = filterContent;
        if (matchString != null) {
            Pattern mPattern = Pattern.compile(matchString);
            Matcher matcher = mPattern.matcher(filterContent);
            int pos = 0;
            while (matcher.find()) {
                filterStr = filterContent.substring(pos, matcher.start());
                pos = matcher.end();
                String group = matcher.group();
                if (textMap != null && textMap.containsKey(group)) {
                    textMapBuilder.append(filterStr).append(textMap.get(group));
                } else {
                    textMapBuilder.append(filterStr).append(group);
                }
                filterStr = SpanResource.escapeStr(filterStr);
                if (richSendMap != null && richSendMap.containsKey(group)) {
                    richBuilder.append(filterStr).append(String.format(RICH_BROW, richSendMap.get(matcher.group())));
                    continue;
                }
                richBuilder.append(filterStr).append(group);
            }
            filterStr = filterContent.substring(pos);
        }
        textMapBuilder.append(filterStr);
        richBuilder.append(SpanResource.escapeStr(filterStr));
        String richText = SpanResource.roundSpan(richBuilder.toString(), color, bold, italic);
        String chatText = textMapBuilder.toString();
        if (sendText != null) {
            sendText.setChatText(chatText);
            sendText.setRichText(richText);
        }
        if (iFilterText != null) {
            iFilterText.sendText(chatText, richText);
        }
    }

    public static String roundSpan(String content, int color, boolean bold, boolean italic) {
        return String.format("<SPAN style=\"FONT-WEIGHT: %s; COLOR: #%s; FONT-STYLE: %s\">", bold ? "bold" : "normal", Integer.toHexString(color).substring(2), italic ? "italic" : "normal") + content + "</SPAN>";
    }

    static {
        filterTexts = new ArrayList<FilterText>();
        filterList = new ConcurrentLinkedQueue();
        isFiltering = new AtomicBoolean(false);
        extraImageGetter = null;
    }

    private static class FilterBean {
        String content;
        SendText sendText;
        OnFilterSendText onFilterSendText;
        int color;
        boolean bold;
        boolean italic;

        public FilterBean(String content, SendText sendText, OnFilterSendText onFilterSendText, int color, boolean bold, boolean italic) {
            this.content = content;
            this.sendText = sendText;
            this.onFilterSendText = onFilterSendText;
            this.color = color;
            this.bold = bold;
            this.italic = italic;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public SendText getSendText() {
            return this.sendText;
        }

        public void setSendText(SendText sendText) {
            this.sendText = sendText;
        }

        public OnFilterSendText getOnFilterSendText() {
            return this.onFilterSendText;
        }

        public void setOnFilterSendText(OnFilterSendText onFilterSendText) {
            this.onFilterSendText = onFilterSendText;
        }

        public String toString() {
            return "FilterBean{content='" + this.content + '\'' + ", sendText=" + this.sendText + ", onFilterSendText=" + this.onFilterSendText + '}';
        }
    }
}

