/*
 * Decompiled with CFR 0.152.
 */
package cn.robotpen.model.symbol;

import cn.robotpen.model.symbol.DeviceType;

public enum SceneType {
    NOTHING(0),
    ELITE_PLUS(1),
    ELITE(2),
    ELITE_PLUS_H(3),
    ELITE_H(4),
    CUSTOM(5),
    INCH_116(6),
    INCH_116_horizontal(7),
    P1(8),
    P1_H(9),
    P7(10),
    S7_JD(26),
    S7_JD_M3(39),
    S7_SD(36),
    P7_H(11);

    private final int value;

    private SceneType(int value) {
        this.value = value;
    }

    public static SceneType toSceneType(int value) {
        if (value >= 0 && value < SceneType.values().length) {
            return SceneType.values()[value];
        }
        return NOTHING;
    }

    public static SceneType getSceneType(boolean isHorizontal, DeviceType deviceType) {
        if (deviceType == DeviceType.P7 || deviceType == DeviceType.S7_JD || deviceType == DeviceType.S7_JD_M3 || deviceType == DeviceType.S7_SD || deviceType == DeviceType.T7_A || deviceType == DeviceType.T7C_BN || deviceType == DeviceType.T7_HI || deviceType == DeviceType.T7B_HF || deviceType == DeviceType.J7B_HF || deviceType == DeviceType.T8S || deviceType == DeviceType.T8B_D2 || deviceType == DeviceType.J7B || deviceType == DeviceType.J7B_ZY || deviceType == DeviceType.T7) {
            return isHorizontal ? P7_H : P7;
        }
        if (deviceType == DeviceType.T7P) {
            return isHorizontal ? ELITE_PLUS_H : ELITE_PLUS;
        }
        return isHorizontal ? P1_H : P1;
    }

    public final int getValue() {
        return this.value;
    }

    public boolean isHorizontal() {
        return this != NOTHING && this != CUSTOM && this != ELITE_PLUS && this != ELITE && this != P1 && this != INCH_116 && this != S7_JD && this != S7_JD_M3 && this != S7_SD && this != P7;
    }

    public SceneType getHorizontalType() {
        switch (this) {
            case ELITE_PLUS: {
                return ELITE_PLUS_H;
            }
            case ELITE: {
                return ELITE_H;
            }
            case P1: {
                return P1_H;
            }
            case P7: {
                return P7_H;
            }
            case INCH_116: {
                return INCH_116_horizontal;
            }
        }
        return this;
    }
}

