/*
 * Decompiled with CFR 0.152.
 */
package cn.robotpen.model.symbol;

import cn.robotpen.utils.FileUtils;
import java.net.URLDecoder;

public enum FileType {
    ALL,
    PDF,
    PPT,
    WORD,
    EXCEL,
    PHOTO,
    VIDEO;


    public static FileType getSuffixType(String path) {
        String suffix = FileUtils.getFileSuffix((String)path);
        return FileType.getType(suffix);
    }

    public static FileType getType(String type) {
        if ("pdf".equals(type)) {
            return PDF;
        }
        if ("doc".equals(type) || "docx".equals(type)) {
            return WORD;
        }
        if ("ppt".equals(type) || "pptx".equals(type)) {
            return PPT;
        }
        if ("jpg".equals(type) || "png".equals(type)) {
            return PHOTO;
        }
        if ("mp4".equals(type)) {
            return VIDEO;
        }
        return ALL;
    }

    public static FileType parsePath(String path) {
        if (path != null && !path.isEmpty()) {
            if ((path = URLDecoder.decode(path)).indexOf("/PDF/") > 0) {
                return PDF;
            }
            if (path.indexOf("/WORD/") > 0) {
                return WORD;
            }
            if (path.indexOf("/PPT/") > 0) {
                return PPT;
            }
            if (path.indexOf("/PHOTO/") > 0) {
                return PHOTO;
            }
            if (path.indexOf("/VIDEO/") > 0) {
                return VIDEO;
            }
        }
        return ALL;
    }

    public static FileType toFileType(String value) {
        if (value != null && !value.isEmpty()) {
            if (value.equals("PDF")) {
                return PDF;
            }
            if (value.equals("WORD")) {
                return WORD;
            }
            if (value.equals("PPT")) {
                return PPT;
            }
            if (value.equals("PHOTO")) {
                return PHOTO;
            }
            if (value.equals("VIDEO")) {
                return VIDEO;
            }
        }
        return ALL;
    }
}

