/*
 * Decompiled with CFR 0.152.
 */
package cn.robotpen.model.symbol;

import android.text.TextUtils;

public enum DeviceType {
    TOUCH(0),
    P7(1),
    T7(2),
    T7_A(28),
    T7C_BN(54),
    T7_HI(29),
    T7B_HF(32),
    J7B_HF(46),
    T8S(48),
    T8B_D2(63),
    J7B(49),
    J7B_ZY(47),
    T7P(3),
    P1(4),
    T7P_NEW(5),
    T7PL(14),
    K7_HW(51),
    K7W(53),
    T7E(15),
    S1_DE(44),
    T7_TS(16),
    T7_LW(17),
    T8A(6),
    T8B(30),
    T8C(35),
    ELITE_XINYUAN(7),
    J0_A5(8),
    J0_A4(11),
    T9B_YD2(43),
    G1(9),
    D1(10),
    D1_CY(23),
    W7(25),
    T7E_NEW(37),
    T7E_HFHH(38),
    P1_CX_M3(40),
    T9A_EN(41),
    T9W_TY(42),
    T9W_B(61),
    T9B_ZXB(62),
    T9W_YJ(55),
    J7E(45),
    J0_A4_P(19),
    T9_J0(18),
    T9A(12),
    T9W_B_KZ(59),
    T9W(34),
    T9W_WX(57),
    T9W_QX(50),
    T9B_YD(31),
    X8(13),
    X8E_A5(33),
    T9E(20),
    J0_T9(21),
    C7(24),
    T7_CY(22),
    S7_JD(26),
    S7_JD_M3(39),
    S7_SD(36),
    DM6(27),
    TEST(100);

    private final int value;

    private DeviceType(int value) {
        this.value = value;
    }

    public static DeviceType getBleType(int type) {
        if (type == 2) {
            return T7;
        }
        if (type == 28) {
            return T7_A;
        }
        if (type == 54) {
            return T7C_BN;
        }
        if (type == 29) {
            return T7_HI;
        }
        if (type == 32) {
            return T7B_HF;
        }
        if (type == 46) {
            return J7B_HF;
        }
        if (type == 48) {
            return T8S;
        }
        if (type == 63) {
            return T8B_D2;
        }
        if (type == 49) {
            return J7B;
        }
        if (type == 47) {
            return J7B_ZY;
        }
        if (type == 3) {
            return T7P;
        }
        if (type == 5) {
            return T7P_NEW;
        }
        if (type == 6) {
            return T8A;
        }
        if (type == 30) {
            return T8B;
        }
        if (type == 35) {
            return T8C;
        }
        if (type == 31) {
            return T9B_YD;
        }
        if (type == 43) {
            return T9B_YD2;
        }
        if (type == 7) {
            return ELITE_XINYUAN;
        }
        if (type == 8) {
            return J0_A5;
        }
        if (type == 11) {
            return J0_A4;
        }
        if (type == 12) {
            return T9A;
        }
        if (type == 59) {
            return T9W_B_KZ;
        }
        if (type == 57) {
            return T9W_WX;
        }
        if (type == 41) {
            return T9A_EN;
        }
        if (type == 34) {
            return T9W;
        }
        if (type == 50) {
            return T9W_QX;
        }
        if (type == 42) {
            return T9W_TY;
        }
        if (type == 61) {
            return T9W_B;
        }
        if (type == 62) {
            return T9B_ZXB;
        }
        if (type == 57) {
            return T9W_YJ;
        }
        if (type == 13) {
            return X8;
        }
        if (type == 33) {
            return X8E_A5;
        }
        if (type == 100) {
            return TEST;
        }
        if (type == 14) {
            return T7PL;
        }
        if (type == 51) {
            return K7_HW;
        }
        if (type == 53) {
            return K7W;
        }
        if (type == 15) {
            return T7E;
        }
        if (type == 37) {
            return T7E_NEW;
        }
        if (type == 45) {
            return J7E;
        }
        if (type == 38) {
            return T7E_HFHH;
        }
        if (type == 40) {
            return P1_CX_M3;
        }
        if (type == 44) {
            return S1_DE;
        }
        if (type == 25) {
            return W7;
        }
        if (type == 16) {
            return T7_TS;
        }
        if (type == 17) {
            return T7_LW;
        }
        if (type == 18) {
            return T9_J0;
        }
        if (type == 19) {
            return J0_A4_P;
        }
        if (type == 20) {
            return T9E;
        }
        if (type == 21) {
            return J0_T9;
        }
        if (type == 24) {
            return C7;
        }
        if (type == 26) {
            return S7_JD;
        }
        if (type == 39) {
            return S7_JD_M3;
        }
        if (type == 36) {
            return S7_SD;
        }
        if (type == 22) {
            return T7_CY;
        }
        return P7;
    }

    public static DeviceType toDeviceType(String deviceIdent) {
        if (!TextUtils.isEmpty((CharSequence)deviceIdent)) {
            for (DeviceType type : DeviceType.values()) {
                if (!deviceIdent.startsWith(type.getDeviceIdent())) continue;
                return type;
            }
        }
        return TOUCH;
    }

    public static DeviceType toDeviceType(int value) {
        DeviceType[] devices = DeviceType.values();
        if (value >= 0 && value <= devices[devices.length - 1].getValue()) {
            for (DeviceType device : devices) {
                if (device.getValue() != value) continue;
                return device;
            }
            return TOUCH;
        }
        return TOUCH;
    }

    public final int getValue() {
        return this.value;
    }

    public boolean isBleDevice() {
        return this == P7 || this == S7_JD || this == S7_SD || this == S7_JD_M3 || this.isElite();
    }

    public boolean isElite() {
        return this == T7 || this == T7_A || this == T7C_BN || this == T7_HI || this == T7B_HF || this == J7B_HF || this == J7B || this == J7B_ZY || this == ELITE_XINYUAN || this == X8 || this == X8E_A5 || this == T7_LW || this == T7E || this == K7_HW || this == T7E_NEW || this == J7E || this == T7E_HFHH || this == P1_CX_M3 || this == S1_DE || this == W7 || this == T7_TS || this == T7_CY || this == C7 || this.isElitePlus();
    }

    public boolean isElitePlus() {
        return this == TEST || this == T8A || this == T8C || this == T8B || this == T9B_YD || this == T8S || this == T8B_D2 || this == T9B_YD2 || this == X8 || this == X8E_A5 || this == T9A || this == T9W_B_KZ || this == T9W_WX || this == T9A_EN || this == T9W || this == T9W_QX || this == T9W_TY || this == T9W_B || this == T9B_ZXB || this == T9W_YJ || this == J0_A4 || this == K7W || this == T9_J0 || this == T9E || this == J0_A4_P || this == J0_T9 || this == J0_A5 || this == T7P || this == T7P_NEW;
    }

    public boolean isReverse() {
        return this == T7P || this == T8A || this == T8B || this == T8C || this == T9B_YD || this == T8S || this == T8B_D2 || this == T9B_YD2 || this == T9E || this == S1_DE || this == J0_A4 || this == T9_J0 || this == J0_A4_P || this == J0_T9 || this == TEST || this == T9W || this == T9W_QX || this == T9W_TY || this == T9W_B || this == T9B_ZXB || this == T9W_YJ || this == K7W || this == T9A || this == T9W_B_KZ || this == T9W_WX || this == W7 || this == T9A_EN;
    }

    public String getDeviceIdent() {
        if (this == P1) {
            return "P1_";
        }
        if (this == S7_JD) {
            return "S7_JD_";
        }
        if (this == S7_JD_M3) {
            return "S7_JD_M3";
        }
        if (this == S7_SD) {
            return "S7_SD_";
        }
        if (this == P7) {
            return "P7_";
        }
        if (this == T7) {
            return "T7_";
        }
        if (this == T7_A) {
            return "T7A_";
        }
        if (this == T7C_BN) {
            return "T7C_BN_";
        }
        if (this == T9W_B) {
            return "T9W_B_";
        }
        if (this == T9B_ZXB) {
            return "T9B_ZXB_";
        }
        if (this == T7_HI) {
            return "T7-HI_";
        }
        if (this == T7B_HF) {
            return "T7B-HF_";
        }
        if (this == J7B_HF) {
            return "J7B-HF_";
        }
        if (this == T8S) {
            return "T8S_";
        }
        if (this == T8B_D2) {
            return "T8B_D2_";
        }
        if (this == J7B) {
            return "J7B_";
        }
        if (this == J7B_ZY) {
            return "J7B-ZY_";
        }
        if (this == T7_CY) {
            return "T7-CY_";
        }
        if (this == T7P || this == T7P_NEW) {
            return "T7P_";
        }
        if (this == ELITE_XINYUAN) {
            return "XINYUAN_";
        }
        if (this == J0_A4) {
            return "J0-A4_";
        }
        if (this == J0_A5) {
            return "J0-A5_";
        }
        if (this == T8A) {
            return "T8A_";
        }
        if (this == T8B) {
            return "T8B_";
        }
        if (this == T8C) {
            return "T8C_";
        }
        if (this == T9B_YD) {
            return "T9B_YD_";
        }
        if (this == T9B_YD2) {
            return "T9B_YD2_";
        }
        if (this == T9A_EN) {
            return "T9A_EN_";
        }
        if (this == T9A) {
            return "T9A_";
        }
        if (this == T9W_B_KZ) {
            return "T9W_B_KZ_";
        }
        if (this == T9W) {
            return "T9W_";
        }
        if (this == T9W_WX) {
            return "T9W_WX_";
        }
        if (this == T9W_QX) {
            return "T9W_QX_";
        }
        if (this == T9W_YJ) {
            return "T9W_YJ_";
        }
        if (this == X8) {
            return "X8_";
        }
        if (this == X8E_A5) {
            return "X8E_A5_";
        }
        if (this == T7PL) {
            return "T7PL_";
        }
        if (this == K7_HW) {
            return "K7_HW_";
        }
        if (this == K7W) {
            return "K7W_";
        }
        if (this == T7E) {
            return "T7E_";
        }
        if (this == T7E_NEW) {
            return "T7E_NEW_";
        }
        if (this == J7E) {
            return "J7E_";
        }
        if (this == T7E_HFHH) {
            return "T7E_HFHH_";
        }
        if (this == P1_CX_M3) {
            return "P1_CX_M3_";
        }
        if (this == S1_DE) {
            return "S1_DE_";
        }
        if (this == W7) {
            return "W7_";
        }
        if (this == T7_TS) {
            return "T7_TS_";
        }
        if (this == T7_LW) {
            return "T7_LW_";
        }
        if (this == T9_J0) {
            return "T9_J0_";
        }
        if (this == J0_A4_P) {
            return "J0_A4_P_";
        }
        if (this == J0_T9) {
            return "J0_T9_";
        }
        if (this == T9E) {
            return "T9E_";
        }
        if (this == C7) {
            return "C7_";
        }
        if (this == TEST) {
            return "TEST_";
        }
        if (this == DM6) {
            return "DM6_";
        }
        return "TOUCH_";
    }
}

