/*
 * Decompiled with CFR 0.152.
 */
package cn.robotpen.model.entity.trails;

import android.util.Base64;
import cn.robotpen.model.DevicePoint;
import cn.robotpen.model.entity.note.NoteEntity;
import cn.robotpen.model.entity.note.PointEntity;
import cn.robotpen.model.entity.note.TrailsEntity;
import com.google.gson.annotations.SerializedName;

public class Trail {
    @SerializedName(value="trail_key")
    private String trailKey;
    @SerializedName(value="block")
    private String blockKey;
    @SerializedName(value="type")
    private int type;
    @SerializedName(value="color")
    private int color;
    @SerializedName(value="ext")
    private String extInfo;
    @SerializedName(value="data")
    private String data;
    @SerializedName(value="start_at")
    private double startTime;
    @SerializedName(value="end_at")
    private double endTime;

    public void setTrailKey(String trailKey) {
        this.trailKey = trailKey;
    }

    public void setBlockKey(String blockKey) {
        this.blockKey = blockKey;
    }

    public String getData() {
        return this.data;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public void fromEntity(TrailsEntity entity, NoteEntity noteEntity) {
        this.blockKey = entity.getBlock();
        this.type = entity.getTrailType();
        this.color = entity.getColor();
        this.extInfo = entity.getExtInfo();
        DevicePoint devicePoint = new DevicePoint();
        devicePoint.setDeviceType(noteEntity.getDeviceType());
        devicePoint.setIsHorizontal(noteEntity.getIsHorizontal() > 0);
        for (PointEntity point : entity.getTrails()) {
            devicePoint.setOriginalX(point.getX());
            devicePoint.setOriginalY(point.getY());
            point.setX(devicePoint.getWindowX());
            point.setY(devicePoint.getWindowY());
        }
        this.data = Base64.encodeToString((byte[])entity.getTrailsData(true), (int)2);
        this.startTime = entity.getStartTime();
        this.endTime = entity.getEndTime();
    }
}

