/*
 * Decompiled with CFR 0.152.
 */
package cn.robotpen.model.entity.note;

import android.os.Parcel;
import android.os.Parcelable;
import cn.robotpen.model.entity.note.PhotoEntity;
import cn.robotpen.model.entity.note.PointEntity;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;

public class TrailsEntity
implements Parcelable {
    public static final int TYPE_NOTHING = -1;
    public static final int TYPE_TRAILS = 0;
    public static final int TYPE_PHOTO = 1;
    public static final int TYPE_PAGE = 2;
    public static final int TYPE_BG = 3;
    public static final int TYPE_CLEAR_SCREEN = 10;
    public static final int TYPE_CLEAR_PHOTO = 11;
    public static final int TYPE_CLEAR_SHAPE = 12;
    public static final int TYPE_CLEAR_TRAILS = 13;
    public static final int TYPE_DELETE_PHOTO = 21;
    public static final int TYPE_DELETE_BLOCK = 22;
    public static final int TYPE_REQUEST_WRITE = 100;
    public static final int TYPE_REQUEST_SPEAK = 101;
    public static final int TYPE_GRANT_WRITE = 200;
    public static final int TYPE_GRANT_SPEAK = 201;
    public static final int TYPE_GRANT_QUIT = 210;
    public static final int TYPE_UPDATE_LIVE_HOUR = 300;
    public static final int TYPE_UPDATE_LIVE_NUM = 301;
    public static final int TYPE_UPDATE_LIVE_START = 302;
    public static final int TYPE_UPDATE_LIVE_STOP = 303;
    public static final int TYPE_UPDATE_LIVE_BLOCKS = 304;
    public static final int TYPE_HANDLER_MSG_MAX = 399;
    public static final int TYPE_REFRESH_ALL = 1000;
    @Expose(serialize=false, deserialize=false)
    @SerializedName(value="trailid")
    private Long trailID;
    @Expose
    @SerializedName(value="ext")
    private String extInfo;
    @Expose
    @SerializedName(value="block")
    private String block;
    @Expose
    @SerializedName(value="color")
    private int color = -16777216;
    @Expose
    @SerializedName(value="type")
    private int trailType;
    @Expose
    @SerializedName(value="user")
    private Long userId;
    @Expose
    @SerializedName(value="start_at")
    private Long startTime;
    @Expose
    @SerializedName(value="end_at")
    private Long endTime;
    @Expose(serialize=false, deserialize=false)
    private byte[] data;
    @Expose
    @SerializedName(value="data")
    private List<PointEntity> trails;
    public static final Parcelable.Creator<TrailsEntity> CREATOR = new Parcelable.Creator<TrailsEntity>(){

        public TrailsEntity createFromParcel(Parcel source) {
            return new TrailsEntity(source);
        }

        public TrailsEntity[] newArray(int size) {
            return new TrailsEntity[size];
        }
    };

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeValue((Object)this.getTrailID());
        dest.writeByteArray(this.getData());
        dest.writeString(this.getExtInfo());
        dest.writeString(this.getBlock());
        dest.writeInt(this.getColor());
        dest.writeInt(this.getTrailType());
        dest.writeValue((Object)this.getUserId());
        dest.writeValue((Object)this.getStartTime());
        dest.writeValue((Object)this.getEndTime());
    }

    public TrailsEntity() {
    }

    private TrailsEntity(Parcel in) {
        this.trailID = (Long)in.readValue(Long.class.getClassLoader());
        in.readByteArray(this.data);
        this.extInfo = in.readString();
        this.block = in.readString();
        this.color = in.readInt();
        this.trailType = in.readInt();
        this.userId = (Long)in.readValue(Long.class.getClassLoader());
        this.startTime = (Long)in.readValue(Long.class.getClassLoader());
        this.endTime = (Long)in.readValue(Long.class.getClassLoader());
    }

    public TrailsEntity(Long trailID, String extInfo, String block, int color, int trailType, Long userId, Long startTime, Long endTime, byte[] data) {
        this.trailID = trailID;
        this.extInfo = extInfo;
        this.block = block;
        this.color = color;
        this.trailType = trailType;
        this.userId = userId;
        this.startTime = startTime;
        this.endTime = endTime;
        this.data = data;
    }

    public String toString() {
        return "TrailsEntity{, trailID=" + this.trailID + ", extInfo='" + this.extInfo + '\'' + ", block=" + this.block + ", color=" + this.color + ", trailType=" + this.trailType + ", userId=" + this.userId + ", startTime=" + this.startTime + ", endTime=" + this.endTime + '}';
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getTrailID() {
        return this.trailID;
    }

    public void setTrailID(Long trailID) {
        this.trailID = trailID;
    }

    public byte[] getData() {
        if (this.data == null && this.trails != null && this.trails.size() > 0) {
            int size = this.isPhoto() ? 28 : 20;
            this.data = new byte[this.trails.size() * size];
            for (int i = 0; i < this.trails.size(); ++i) {
                System.arraycopy(this.trails.get(i).toByteArray(), 0, this.data, i * size, size);
            }
        }
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public String getExtInfo() {
        return this.extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }

    public String getBlock() {
        return this.block;
    }

    public void setBlock(String block) {
        this.block = block;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public int getTrailType() {
        return this.trailType;
    }

    public void setTrailType(int trailType) {
        this.trailType = trailType;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public long getStartTime() {
        return this.startTime * 1000L;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime * 1000L;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public List<PointEntity> getTrails() {
        if (this.trails == null && this.data != null) {
            int size = this.isPhoto() ? 28 : 20;
            this.trails = new ArrayList<PointEntity>(this.data.length / size);
            byte[] buffer = new byte[size];
            for (int i = 0; i < this.data.length; i += size) {
                System.arraycopy(this.data, i, buffer, 0, size);
                PointEntity point = this.isPhoto() ? new PhotoEntity(buffer) : new PointEntity(buffer);
                this.trails.add(point);
            }
        }
        return this.trails;
    }

    public void setTrails(List<PointEntity> trails) {
        this.trails = trails;
    }

    public void setTrail(PointEntity trail) {
        if (this.trails != null) {
            this.trails.clear();
        }
        this.addTrail(trail);
    }

    public void addTrail(PointEntity trail) {
        if (this.trails == null) {
            this.trails = new ArrayList<PointEntity>();
        }
        this.trails.add(trail);
    }

    public byte[] getTrailsData(boolean little) {
        byte[] result = null;
        if (this.trails != null && this.trails.size() > 0) {
            int size = this.isPhoto() ? 28 : 20;
            result = new byte[this.trails.size() * size];
            for (int i = 0; i < this.trails.size(); ++i) {
                System.arraycopy(this.trails.get(i).toByteArray(little), 0, result, i * size, this.trails.get(i).toByteArray(little).length);
            }
        }
        return result;
    }

    public boolean isPhoto() {
        return this.trailType == 1;
    }
}

