/*
 * Decompiled with CFR 0.152.
 */
package cn.robotpen.model.entity.note;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import cn.robotpen.model.symbol.DeviceType;
import com.google.gson.annotations.SerializedName;
import java.util.UUID;

public class NoteEntity
implements Parcelable {
    public static final String KEY_NOTEKEY_PREFIX = "android_";
    public static final String KEY_NOTEKEY_TMP = "android_tmp";
    @SerializedName(value="NoteID")
    private Long noteID;
    @SerializedName(value="NoteKey")
    private String noteKey;
    @SerializedName(value="UserId")
    private Long userId = 0L;
    @SerializedName(value="Title")
    private String title;
    @SerializedName(value="DeviceType")
    private int deviceType = DeviceType.TOUCH.getValue();
    @SerializedName(value="IsHorizontal")
    private int isHorizontal;
    @SerializedName(value="CreateTime")
    private int createTime;
    @SerializedName(value="UpdateTime")
    private int updateTime = this.createTime = (int)(System.currentTimeMillis() / 1000L);
    public static final Parcelable.Creator<NoteEntity> CREATOR = new Parcelable.Creator<NoteEntity>(){

        public NoteEntity createFromParcel(Parcel source) {
            return new NoteEntity(source);
        }

        public NoteEntity[] newArray(int size) {
            return new NoteEntity[size];
        }
    };

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeValue((Object)this.noteID);
        dest.writeString(this.noteKey);
        dest.writeValue((Object)this.userId);
        dest.writeString(this.title);
        dest.writeInt(this.deviceType);
        dest.writeInt(this.isHorizontal);
        dest.writeInt(this.createTime);
        dest.writeInt(this.updateTime);
    }

    public static String newNoteKey() {
        return KEY_NOTEKEY_PREFIX + UUID.randomUUID();
    }

    public Long getNoteID() {
        return this.noteID;
    }

    public void setNoteID(Long noteID) {
        this.noteID = noteID;
    }

    public String getNoteKey() {
        return this.noteKey;
    }

    public void setNoteKey(String noteKey) {
        this.noteKey = noteKey;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getTitle() {
        if (TextUtils.isEmpty((CharSequence)this.title)) {
            return this.noteKey;
        }
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(int deviceType) {
        this.deviceType = deviceType;
    }

    public int getIsHorizontal() {
        return this.isHorizontal;
    }

    public void setIsHorizontal(int isHorizontal) {
        this.isHorizontal = isHorizontal;
    }

    public int getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(int createTime) {
        this.createTime = createTime;
    }

    public int getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(int updateTime) {
        this.updateTime = updateTime;
    }

    public NoteEntity() {
    }

    protected NoteEntity(Parcel in) {
        this.noteID = (Long)in.readValue(Long.class.getClassLoader());
        this.noteKey = in.readString();
        this.userId = (Long)in.readValue(Long.class.getClassLoader());
        this.title = in.readString();
        this.deviceType = in.readInt();
        this.isHorizontal = in.readInt();
        this.createTime = in.readInt();
        this.updateTime = in.readInt();
    }

    public NoteEntity(Long noteID, String noteKey, Long userId, String title, int deviceType, int isHorizontal, int createTime, int updateTime) {
        this.noteID = noteID;
        this.noteKey = noteKey;
        this.userId = userId;
        this.title = title;
        this.deviceType = deviceType;
        this.isHorizontal = isHorizontal;
        this.createTime = createTime;
        this.updateTime = updateTime;
    }

    public String toString() {
        return "NoteEntity{noteID=" + this.noteID + ", noteKey='" + this.noteKey + '\'' + ", userId=" + this.userId + ", title='" + this.title + '\'' + ", deviceType=" + this.deviceType + ", isHorizontal=" + this.isHorizontal + ", createTime=" + this.createTime + ", updateTime=" + this.updateTime + '}';
    }
}

