/*
 * Decompiled with CFR 0.152.
 */
package cn.robotpen.model.entity;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import cn.robotpen.model.entity.TagEntity;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;

public class VideoEntity
implements Parcelable {
    public static final Parcelable.Creator<VideoEntity> CREATOR = new Parcelable.Creator<VideoEntity>(){

        public VideoEntity createFromParcel(Parcel source) {
            return new VideoEntity(source);
        }

        public VideoEntity[] newArray(int size) {
            return new VideoEntity[size];
        }
    };
    @SerializedName(value="Tags")
    public TagEntity[] tags;
    @SerializedName(value="VideoID")
    private Long videoID;
    @SerializedName(value="Name")
    private String name;
    @SerializedName(value="Path")
    private String path;
    @SerializedName(value="PlayCount")
    private int playCount;
    @SerializedName(value="UpdateTime")
    private Long updateTime = 0L;
    @SerializedName(value="Width")
    private int width;
    @SerializedName(value="Height")
    private int height;
    @SerializedName(value="Size")
    private Long size = 0L;
    @SerializedName(value="Length")
    private Long length = 0L;
    @SerializedName(value="IsComment")
    private int isComment;
    @SerializedName(value="MyLike")
    private int isMyLike;
    @SerializedName(value="MyUserLike")
    private int myUserLike;
    @SerializedName(value="VideoLike")
    private int videoLike;
    @SerializedName(value="UserLike")
    private int userLike;
    @SerializedName(value="Snapshot")
    private String snapshot;
    @SerializedName(value="CommentCount")
    private int commentCount;
    @SerializedName(value="Createdtime")
    private Long createdTime = 0L;
    @SerializedName(value="About")
    private String about;

    public VideoEntity() {
    }

    public VideoEntity(Long videoID, String name, String path, int width, int height, Long size, Long length, Long createdTime) {
        this.videoID = videoID;
        this.name = name;
        this.path = path;
        this.width = width;
        this.height = height;
        this.size = size;
        this.length = length;
        this.createdTime = createdTime;
    }

    protected VideoEntity(Parcel in) {
        this.videoID = (Long)in.readValue(Long.class.getClassLoader());
        this.name = in.readString();
        this.path = in.readString();
        this.playCount = in.readInt();
        this.updateTime = (Long)in.readValue(Long.class.getClassLoader());
        this.width = in.readInt();
        this.height = in.readInt();
        this.size = (Long)in.readValue(Long.class.getClassLoader());
        this.length = (Long)in.readValue(Long.class.getClassLoader());
        this.isComment = in.readInt();
        this.isMyLike = in.readInt();
        this.myUserLike = in.readInt();
        this.videoLike = in.readInt();
        this.userLike = in.readInt();
        this.snapshot = in.readString();
        this.commentCount = in.readInt();
        this.createdTime = (Long)in.readValue(Long.class.getClassLoader());
        this.about = in.readString();
        this.tags = (TagEntity[])in.createTypedArray(TagEntity.CREATOR);
    }

    public TagEntity[] getTags() {
        return this.tags;
    }

    public void setTags(TagEntity ... tags) {
        this.tags = tags;
    }

    public Long getVideoID() {
        return this.videoID;
    }

    public void setVideoID(Long videoID) {
        this.videoID = videoID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getPlayCount() {
        return this.playCount;
    }

    public void setPlayCount(int playCount) {
        this.playCount = playCount;
    }

    public Long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public Long getLength() {
        return this.length;
    }

    public void setLength(Long length) {
        this.length = length;
    }

    public int getIsComment() {
        return this.isComment;
    }

    public void setIsComment(int isComment) {
        this.isComment = isComment;
    }

    public int getIsMyLike() {
        return this.isMyLike;
    }

    public void setIsMyLike(int isMyLike) {
        this.isMyLike = isMyLike;
    }

    public int getMyUserLike() {
        return this.myUserLike;
    }

    public void setMyUserLike(int myUserLike) {
        this.myUserLike = myUserLike;
    }

    public int getVideoLike() {
        return this.videoLike;
    }

    public void setVideoLike(int videoLike) {
        this.videoLike = videoLike;
    }

    public int getUserLike() {
        return this.userLike;
    }

    public void setUserLike(int userLike) {
        this.userLike = userLike;
    }

    public String getSnapshot() {
        if (TextUtils.isEmpty((CharSequence)this.snapshot)) {
            return "http://avatar.robotpen.cn/VIDEO/" + this.getVideoID() + ".jpg?t=" + this.updateTime;
        }
        return this.snapshot;
    }

    public void setSnapshot(String snapshot) {
        this.snapshot = snapshot;
    }

    public int getCommentCount() {
        return this.commentCount;
    }

    public void setCommentCount(int commentCount) {
        this.commentCount = commentCount;
    }

    public Long getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Long createdTime) {
        this.createdTime = createdTime;
    }

    public String toString() {
        return "VideoEntity{tags=" + Arrays.toString(this.tags) + ", videoID=" + this.videoID + ", name='" + this.name + '\'' + ", path='" + this.path + '\'' + ", playCount=" + this.playCount + ", updateTime=" + this.updateTime + ", width=" + this.width + ", height=" + this.height + ", size=" + this.size + ", length=" + this.length + ", isComment=" + this.isComment + ", isMyLike=" + this.isMyLike + ", myUserLike=" + this.myUserLike + ", videoLike=" + this.videoLike + ", userLike=" + this.userLike + ", snapshot='" + this.snapshot + '\'' + ", commentCount=" + this.commentCount + ", createdTime=" + this.createdTime + ", about='" + this.about + '\'' + '}';
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String tagsToString() {
        if (this.tags != null && this.tags.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (TagEntity tag : this.tags) {
                sb.append("," + tag.getTag());
            }
            return sb.substring(1);
        }
        return "";
    }

    public String getAbout() {
        return this.about;
    }

    public void setAbout(String about) {
        this.about = about;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeValue((Object)this.videoID);
        dest.writeString(this.name);
        dest.writeString(this.path);
        dest.writeInt(this.playCount);
        dest.writeValue((Object)this.updateTime);
        dest.writeInt(this.width);
        dest.writeInt(this.height);
        dest.writeValue((Object)this.size);
        dest.writeValue((Object)this.length);
        dest.writeInt(this.isComment);
        dest.writeInt(this.isMyLike);
        dest.writeInt(this.myUserLike);
        dest.writeInt(this.videoLike);
        dest.writeInt(this.userLike);
        dest.writeString(this.snapshot);
        dest.writeInt(this.commentCount);
        dest.writeValue((Object)this.createdTime);
        dest.writeString(this.about);
        dest.writeTypedArray((Parcelable[])this.tags, flags);
    }
}

