/*
 * Decompiled with CFR 0.152.
 */
package cn.robotpen.model.entity;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.gson.annotations.SerializedName;

public class UserEntity
implements Parcelable {
    @SerializedName(value="UserID")
    private Long userID;
    @SerializedName(value="Session")
    private String session;
    @SerializedName(value="UserName")
    private String userName;
    @SerializedName(value="ExtSource")
    private int extSource;
    @SerializedName(value="ExtID")
    private String extID;
    @SerializedName(value="FileIdent")
    private String fileIdent;
    @SerializedName(value="Sex")
    private int sex;
    @SerializedName(value="Avatar")
    private String avatar;
    @SerializedName(value="Email")
    private String email;
    @SerializedName(value="PhoneNumber")
    private String phoneNumber;
    @SerializedName(value="UpdateTime")
    private Long updateTime;
    @SerializedName(value="About")
    private String about;
    @SerializedName(value="LikeCount")
    private int likeCount;
    @SerializedName(value="VideoCount")
    private int videoCount;
    @SerializedName(value="LiveHour")
    private int liveHour;
    @SerializedName(value="error")
    private String error;
    public static final Parcelable.Creator<UserEntity> CREATOR = new Parcelable.Creator<UserEntity>(){

        public UserEntity createFromParcel(Parcel source) {
            return new UserEntity(source);
        }

        public UserEntity[] newArray(int size) {
            return new UserEntity[size];
        }
    };

    public UserEntity(String userKey) {
        this.userID = 0L;
        this.fileIdent = userKey;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public Long getUserID() {
        return this.userID == null ? 0L : this.userID;
    }

    public void setUserID(Long userID) {
        this.userID = userID;
    }

    public boolean isEmpty() {
        return this.userID == null || this.userID <= 0L || TextUtils.isEmpty((CharSequence)this.session);
    }

    public String getSession() {
        return this.session;
    }

    public void setSession(String session) {
        this.session = session;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public int getExtSource() {
        return this.extSource;
    }

    public void setExtSource(int extSource) {
        this.extSource = extSource;
    }

    public String getExtID() {
        return this.extID;
    }

    public void setExtID(String extID) {
        this.extID = extID;
    }

    public String getFileIdent() {
        return this.fileIdent;
    }

    public void setFileIdent(String fileIdent) {
        this.fileIdent = fileIdent;
    }

    public int getSex() {
        return this.sex;
    }

    public void setSex(int sex) {
        this.sex = sex;
    }

    public String getAvatar() {
        if (TextUtils.isEmpty((CharSequence)this.avatar)) {
            return "http://avatar.robotpen.cn/PHOTO/" + this.getFileIdent() + "/" + this.getUserID() + ".jpg?t=" + this.getUpdateTime();
        }
        if (this.avatar.contains("avatar.robotpen.cn/")) {
            return this.avatar + "?t=" + this.getUpdateTime();
        }
        return this.avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public Long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
    }

    public String getAbout() {
        return this.about;
    }

    public void setAbout(String about) {
        this.about = about;
    }

    public String toString() {
        return "UserEntity{userID=" + this.userID + ", session='" + this.session + '\'' + ", userName='" + this.userName + '\'' + ", extSource=" + this.extSource + ", extID='" + this.extID + '\'' + ", fileIdent='" + this.fileIdent + '\'' + ", sex=" + this.sex + ", avatar='" + this.avatar + '\'' + ", email='" + this.email + '\'' + ", phoneNumber='" + this.phoneNumber + '\'' + ", updateTime=" + this.updateTime + ", about='" + this.about + '\'' + ", likeCount=" + this.likeCount + ", videoCount=" + this.videoCount + ", liveHour=" + this.liveHour + ", error='" + this.error + '\'' + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeValue((Object)this.userID);
        dest.writeString(this.session);
        dest.writeString(this.userName);
        dest.writeInt(this.extSource);
        dest.writeString(this.extID);
        dest.writeString(this.fileIdent);
        dest.writeInt(this.sex);
        dest.writeString(this.avatar);
        dest.writeString(this.email);
        dest.writeString(this.phoneNumber);
        dest.writeValue((Object)this.updateTime);
        dest.writeString(this.about);
        dest.writeInt(this.likeCount);
        dest.writeInt(this.videoCount);
        dest.writeInt(this.liveHour);
        dest.writeString(this.error);
    }

    public int getLikeCount() {
        return this.likeCount;
    }

    public void setLikeCount(int likeCount) {
        this.likeCount = likeCount;
    }

    public int getVideoCount() {
        return this.videoCount;
    }

    public void setVideoCount(int videoCount) {
        this.videoCount = videoCount;
    }

    public int getLiveHour() {
        return this.liveHour;
    }

    public void setLiveHour(int liveHour) {
        this.liveHour = liveHour;
    }

    protected UserEntity(Parcel in) {
        this.userID = (Long)in.readValue(Long.class.getClassLoader());
        this.session = in.readString();
        this.userName = in.readString();
        this.extSource = in.readInt();
        this.extID = in.readString();
        this.fileIdent = in.readString();
        this.sex = in.readInt();
        this.avatar = in.readString();
        this.email = in.readString();
        this.phoneNumber = in.readString();
        this.updateTime = (Long)in.readValue(Long.class.getClassLoader());
        this.about = in.readString();
        this.likeCount = in.readInt();
        this.videoCount = in.readInt();
        this.liveHour = in.readInt();
        this.error = in.readString();
    }

    public UserEntity(Long userID, String session, String userName, String fileIdent, String avatar, Long updateTime, String about, int likeCount, int videoCount, int liveHour) {
        this.userID = userID;
        this.session = session;
        this.userName = userName;
        this.fileIdent = fileIdent;
        this.avatar = avatar;
        this.updateTime = updateTime;
        this.about = about;
        this.likeCount = likeCount;
        this.videoCount = videoCount;
        this.liveHour = liveHour;
    }

    public UserEntity() {
    }
}

