/*
 * Decompiled with CFR 0.152.
 */
package cn.robotpen.model.entity;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Parcel;
import android.os.Parcelable;

public class SettingEntity
implements Parcelable {
    private static final String KEY_VIDEO_QUALITY = "video_quality";
    private static final String KEY_DIRECTION = "direction";
    private static final String KEY_PRESSURE = "pressure";
    private final int[] videoQualityValues = new int[]{22, 12, 2};
    private int videoQuality;
    private boolean direction;
    private boolean pressure = true;
    private SharedPreferences sp;
    public static final Parcelable.Creator<SettingEntity> CREATOR = new Parcelable.Creator<SettingEntity>(){

        public SettingEntity createFromParcel(Parcel source) {
            return new SettingEntity(source);
        }

        public SettingEntity[] newArray(int size) {
            return new SettingEntity[size];
        }
    };

    public SettingEntity(Context ctx) {
        this.sp = ctx.getSharedPreferences("SETTING_CONFIGURATION", 0);
        this.videoQuality = this.sp.getInt(KEY_VIDEO_QUALITY, 1);
        this.direction = this.sp.getBoolean(KEY_DIRECTION, false);
        this.pressure = this.sp.getBoolean(KEY_PRESSURE, true);
    }

    protected SettingEntity(Parcel in) {
        this.videoQuality = in.readInt();
        this.direction = in.readByte() != 0;
        this.pressure = in.readByte() != 0;
    }

    public int getVideoQualityValue() {
        if (this.videoQuality >= 0 && this.videoQuality < this.videoQualityValues.length) {
            return this.videoQualityValues[this.videoQuality];
        }
        return this.videoQualityValues[1];
    }

    public int getVideoQuality() {
        return this.videoQuality;
    }

    public void setVideoQuality(int v) {
        this.videoQuality = v;
        this.sp.edit().putInt(KEY_VIDEO_QUALITY, this.videoQuality).apply();
    }

    public boolean isDirection() {
        return this.direction;
    }

    public void setDirection(boolean d) {
        this.direction = d;
        this.sp.edit().putBoolean(KEY_DIRECTION, this.direction).apply();
    }

    public boolean isPressure() {
        return this.pressure;
    }

    public void setPressure(boolean p) {
        this.pressure = p;
        this.sp.edit().putBoolean(KEY_PRESSURE, this.pressure).apply();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.videoQuality);
        dest.writeByte(this.direction ? (byte)1 : 0);
        dest.writeByte(this.pressure ? (byte)1 : 0);
    }
}

