/*
 * Decompiled with CFR 0.152.
 */
package cn.robotpen.model.entity;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import cn.robotpen.model.entity.TagEntity;
import cn.robotpen.model.entity.UserEntity;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Arrays;

public class LiveEntity
implements Parcelable {
    @SerializedName(value="LiveID", alternate={"id"})
    private int liveId;
    @SerializedName(value="LiveSession")
    private Long liveSession;
    @SerializedName(value="Name")
    private String name;
    @SerializedName(value="DeviceType")
    private int deviceType;
    @SerializedName(value="IsHorizontal")
    private int isHorizontal;
    @SerializedName(value="IsEncrypt")
    private int isEncrypt;
    @SerializedName(value="IsComment")
    private int isComment;
    @SerializedName(value="IsWrite")
    private int isWrite;
    @SerializedName(value="IsSpeak")
    private int isSpeak;
    @SerializedName(value="IsStart")
    private int isStart;
    @SerializedName(value="UpdateTime")
    private long updateTime;
    @SerializedName(value="LiveLike")
    private int liveLike;
    @SerializedName(value="User")
    private UserEntity user;
    @SerializedName(value="Block")
    private String block;
    @SerializedName(value="Blocks")
    private String[] blocks;
    @SerializedName(value="Online")
    private int online;
    @SerializedName(value="Cover")
    private String cover;
    @SerializedName(value="About")
    private String about;
    @SerializedName(value="Tags")
    private TagEntity[] tags;
    @SerializedName(value="Channel")
    private String channel;
    public static final Parcelable.Creator<LiveEntity> CREATOR = new Parcelable.Creator<LiveEntity>(){

        public LiveEntity createFromParcel(Parcel source) {
            return new LiveEntity(source);
        }

        public LiveEntity[] newArray(int size) {
            return new LiveEntity[size];
        }
    };

    public LiveEntity() {
    }

    public TagEntity[] getTags() {
        return this.tags;
    }

    public void setTags(TagEntity ... tags) {
        this.tags = tags;
    }

    public void setTags(String tags) {
        if (TextUtils.isEmpty((CharSequence)tags)) {
            this.tags = null;
        } else {
            ArrayList<TagEntity> tagList = new ArrayList<TagEntity>();
            for (String s : tags.split(",")) {
                if (TextUtils.isEmpty((CharSequence)s)) continue;
                tagList.add(new TagEntity(s));
            }
            this.setTags(tagList.toArray(new TagEntity[0]));
        }
    }

    public String getCover() {
        if (TextUtils.isEmpty((CharSequence)this.cover)) {
            return "http://avatar.robotpen.cn/LIVE/" + this.getLiveId() + ".jpg";
        }
        return this.cover;
    }

    public int getOnline() {
        return this.online;
    }

    public String getChannel() {
        return this.channel;
    }

    public int getLiveId() {
        return this.liveId;
    }

    public long getLiveSession() {
        return this.liveSession;
    }

    public void setLiveSession(long value) {
        this.liveSession = value;
    }

    public String getName() {
        return this.name;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(int deviceType) {
        this.deviceType = deviceType;
    }

    public int getIsHorizontal() {
        return this.isHorizontal;
    }

    public void setIsHorizontal(int isHorizontal) {
        this.isHorizontal = isHorizontal;
    }

    public int getIsEncrypt() {
        return this.isEncrypt;
    }

    public int getIsComment() {
        return this.isComment;
    }

    public int getIsWrite() {
        return this.isWrite;
    }

    public void setIsWrite(int isWrite) {
        this.isWrite = isWrite;
    }

    public int getIsSpeak() {
        return this.isSpeak;
    }

    public void setIsSpeak(int isSpeak) {
        this.isSpeak = isSpeak;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAbout(String about) {
        this.about = about;
    }

    public int getIsStart() {
        return this.isStart;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public int getLiveLike() {
        return this.liveLike;
    }

    public void setOnline(int online) {
        this.online = online;
    }

    public UserEntity getUser() {
        return this.user;
    }

    public void setUser(UserEntity user) {
        this.user = user;
    }

    public String getAbout() {
        return this.about;
    }

    public String getBlock() {
        return this.block;
    }

    public String[] getBlocks() {
        return this.blocks;
    }

    public String toString() {
        return "LiveEntity{liveId=" + this.liveId + ", liveSession=" + this.liveSession + ", name='" + this.name + '\'' + ", deviceType=" + this.deviceType + ", isHorizontal=" + this.isHorizontal + ", isEncrypt=" + this.isEncrypt + ", isComment=" + this.isComment + ", isWrite=" + this.isWrite + ", isSpeak=" + this.isSpeak + ", isStart=" + this.isStart + ", updateTime=" + this.updateTime + ", liveLike=" + this.liveLike + ", user=" + this.user + ", block='" + this.block + '\'' + ", blocks=" + Arrays.toString(this.blocks) + ", online='" + this.online + '\'' + ", cover='" + this.cover + '\'' + ", about='" + this.about + '\'' + ", channel='" + this.channel + '\'' + ", tags='" + Arrays.toString(this.tags) + '\'' + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.liveId);
        dest.writeValue((Object)this.liveSession);
        dest.writeString(this.name);
        dest.writeInt(this.deviceType);
        dest.writeInt(this.isHorizontal);
        dest.writeInt(this.isEncrypt);
        dest.writeInt(this.isComment);
        dest.writeInt(this.isWrite);
        dest.writeInt(this.isSpeak);
        dest.writeInt(this.isStart);
        dest.writeLong(this.updateTime);
        dest.writeInt(this.liveLike);
        dest.writeParcelable((Parcelable)this.user, flags);
        dest.writeString(this.block);
        dest.writeStringArray(this.blocks);
        dest.writeInt(this.online);
        dest.writeString(this.cover);
        dest.writeString(this.about);
        dest.writeTypedArray((Parcelable[])this.tags, flags);
        dest.writeString(this.channel);
    }

    protected LiveEntity(Parcel in) {
        this.liveId = in.readInt();
        this.liveSession = (Long)in.readValue(Long.class.getClassLoader());
        this.name = in.readString();
        this.deviceType = in.readInt();
        this.isHorizontal = in.readInt();
        this.isEncrypt = in.readInt();
        this.isComment = in.readInt();
        this.isWrite = in.readInt();
        this.isSpeak = in.readInt();
        this.isStart = in.readInt();
        this.updateTime = in.readLong();
        this.liveLike = in.readInt();
        this.user = (UserEntity)in.readParcelable(UserEntity.class.getClassLoader());
        this.block = in.readString();
        this.blocks = in.createStringArray();
        this.online = in.readInt();
        this.cover = in.readString();
        this.about = in.readString();
        this.tags = (TagEntity[])in.createTypedArray(TagEntity.CREATOR);
        this.channel = in.readString();
    }

    public String tagsToString() {
        if (this.tags != null && this.tags.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (TagEntity tag : this.tags) {
                sb.append("," + tag.getTag());
            }
            return sb.substring(1);
        }
        return "";
    }
}

