/*
 * Decompiled with CFR 0.152.
 */
package cn.robotpen.model.entity;

import android.bluetooth.BluetoothDevice;
import android.hardware.usb.UsbDevice;
import android.os.Parcel;
import android.os.Parcelable;
import cn.robotpen.model.symbol.DeviceType;

public class DeviceEntity
implements Parcelable {
    public static final Parcelable.Creator<DeviceEntity> CREATOR = new Parcelable.Creator<DeviceEntity>(){

        public DeviceEntity createFromParcel(Parcel source) {
            return new DeviceEntity(source);
        }

        public DeviceEntity[] newArray(int size) {
            return new DeviceEntity[size];
        }
    };
    private DeviceType deviceType = DeviceType.TOUCH;
    private String name;
    private String address;
    private int hardwareVer;
    private int firmwareVer;

    public DeviceEntity(BluetoothDevice device) {
        this.name = device.getName();
        this.address = device.getAddress();
    }

    public DeviceEntity(UsbDevice device) {
        this.deviceType = DeviceType.P1;
        this.name = device.getDeviceName();
    }

    protected DeviceEntity(Parcel in) {
        int tmpType = in.readInt();
        this.deviceType = tmpType == -1 ? null : DeviceType.values()[tmpType];
        this.name = in.readString();
        this.address = in.readString();
        this.hardwareVer = in.readInt();
        this.firmwareVer = in.readInt();
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(DeviceType value) {
        this.deviceType = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String value) {
        this.address = value;
    }

    public int getHardwareVer() {
        return this.hardwareVer;
    }

    public void setHardwareVer(int value) {
        this.hardwareVer = value;
    }

    public int getFirmwareVer() {
        return this.firmwareVer;
    }

    public void setFirmwareVer(int value) {
        this.firmwareVer = value;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.deviceType == null ? -1 : this.deviceType.getValue());
        dest.writeString(this.name);
        dest.writeString(this.address);
        dest.writeInt(this.hardwareVer);
        dest.writeInt(this.firmwareVer);
    }
}

