/*
 * Decompiled with CFR 0.152.
 */
package cn.robotpen.model.db;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;
import cn.robotpen.model.db.DaoSession;
import cn.robotpen.model.entity.VideoEntity;
import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.AbstractDaoSession;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;
import org.greenrobot.greendao.internal.DaoConfig;

public class VideoEntityDao
extends AbstractDao<VideoEntity, Long> {
    public static final String TABLENAME = "VIDEO_ENTITY";

    public VideoEntityDao(DaoConfig config) {
        super(config);
    }

    public VideoEntityDao(DaoConfig config, DaoSession daoSession) {
        super(config, (AbstractDaoSession)daoSession);
    }

    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists ? "IF NOT EXISTS " : "";
        db.execSQL("CREATE TABLE " + constraint + "\"VIDEO_ENTITY\" (\"VideoID\" INTEGER PRIMARY KEY AUTOINCREMENT ,\"Name\" TEXT,\"Path\" TEXT,\"Width\" INTEGER NOT NULL ,\"Height\" INTEGER NOT NULL ,\"Size\" INTEGER,\"Length\" INTEGER,\"CreatedTime\" INTEGER);");
    }

    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"VIDEO_ENTITY\"";
        db.execSQL(sql);
    }

    protected final void bindValues(DatabaseStatement stmt, VideoEntity entity) {
        Long createdTime;
        Long length;
        String path;
        String name;
        stmt.clearBindings();
        Long videoID = entity.getVideoID();
        if (videoID != null) {
            stmt.bindLong(1, videoID.longValue());
        }
        if ((name = entity.getName()) != null) {
            stmt.bindString(2, name);
        }
        if ((path = entity.getPath()) != null) {
            stmt.bindString(3, path);
        }
        stmt.bindLong(4, (long)entity.getWidth());
        stmt.bindLong(5, (long)entity.getHeight());
        Long size = entity.getSize();
        if (size != null) {
            stmt.bindLong(6, size.longValue());
        }
        if ((length = entity.getLength()) != null) {
            stmt.bindLong(7, length.longValue());
        }
        if ((createdTime = entity.getCreatedTime()) != null) {
            stmt.bindLong(8, createdTime.longValue());
        }
    }

    protected final void bindValues(SQLiteStatement stmt, VideoEntity entity) {
        Long createdTime;
        Long length;
        String path;
        String name;
        stmt.clearBindings();
        Long videoID = entity.getVideoID();
        if (videoID != null) {
            stmt.bindLong(1, videoID.longValue());
        }
        if ((name = entity.getName()) != null) {
            stmt.bindString(2, name);
        }
        if ((path = entity.getPath()) != null) {
            stmt.bindString(3, path);
        }
        stmt.bindLong(4, (long)entity.getWidth());
        stmt.bindLong(5, (long)entity.getHeight());
        Long size = entity.getSize();
        if (size != null) {
            stmt.bindLong(6, size.longValue());
        }
        if ((length = entity.getLength()) != null) {
            stmt.bindLong(7, length.longValue());
        }
        if ((createdTime = entity.getCreatedTime()) != null) {
            stmt.bindLong(8, createdTime.longValue());
        }
    }

    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0));
    }

    public VideoEntity readEntity(Cursor cursor, int offset) {
        VideoEntity entity = new VideoEntity(cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0)), cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1), cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2), cursor.getInt(offset + 3), cursor.getInt(offset + 4), cursor.isNull(offset + 5) ? null : Long.valueOf(cursor.getLong(offset + 5)), cursor.isNull(offset + 6) ? null : Long.valueOf(cursor.getLong(offset + 6)), cursor.isNull(offset + 7) ? null : Long.valueOf(cursor.getLong(offset + 7)));
        return entity;
    }

    public void readEntity(Cursor cursor, VideoEntity entity, int offset) {
        entity.setVideoID(cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0)));
        entity.setName(cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1));
        entity.setPath(cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2));
        entity.setWidth(cursor.getInt(offset + 3));
        entity.setHeight(cursor.getInt(offset + 4));
        entity.setSize(cursor.isNull(offset + 5) ? null : Long.valueOf(cursor.getLong(offset + 5)));
        entity.setLength(cursor.isNull(offset + 6) ? null : Long.valueOf(cursor.getLong(offset + 6)));
        entity.setCreatedTime(cursor.isNull(offset + 7) ? null : Long.valueOf(cursor.getLong(offset + 7)));
    }

    protected final Long updateKeyAfterInsert(VideoEntity entity, long rowId) {
        entity.setVideoID(rowId);
        return rowId;
    }

    public Long getKey(VideoEntity entity) {
        if (entity != null) {
            return entity.getVideoID();
        }
        return null;
    }

    public boolean hasKey(VideoEntity entity) {
        return entity.getVideoID() != null;
    }

    protected final boolean isEntityUpdateable() {
        return true;
    }

    public static class Properties {
        public static final Property VideoID = new Property(0, Long.class, "videoID", true, "VideoID");
        public static final Property Name = new Property(1, String.class, "name", false, "Name");
        public static final Property Path = new Property(2, String.class, "path", false, "Path");
        public static final Property Width = new Property(3, Integer.TYPE, "width", false, "Width");
        public static final Property Height = new Property(4, Integer.TYPE, "height", false, "Height");
        public static final Property Size = new Property(5, Long.class, "size", false, "Size");
        public static final Property Length = new Property(6, Long.class, "length", false, "Length");
        public static final Property CreatedTime = new Property(7, Long.class, "createdTime", false, "CreatedTime");
    }
}

