/*
 * Decompiled with CFR 0.152.
 */
package cn.robotpen.model.db;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;
import cn.robotpen.model.db.DaoSession;
import cn.robotpen.model.entity.UserEntity;
import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.AbstractDaoSession;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;
import org.greenrobot.greendao.internal.DaoConfig;

public class UserEntityDao
extends AbstractDao<UserEntity, Long> {
    public static final String TABLENAME = "USER_ENTITY";

    public UserEntityDao(DaoConfig config) {
        super(config);
    }

    public UserEntityDao(DaoConfig config, DaoSession daoSession) {
        super(config, (AbstractDaoSession)daoSession);
    }

    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists ? "IF NOT EXISTS " : "";
        db.execSQL("CREATE TABLE " + constraint + "\"USER_ENTITY\" (\"UserID\" INTEGER PRIMARY KEY ,\"Session\" TEXT,\"UserName\" TEXT,\"FileIdent\" TEXT,\"Avatar\" TEXT,\"UpdateTime\" INTEGER,\"About\" TEXT,\"LikeCount\" INTEGER NOT NULL ,\"VideoCount\" INTEGER NOT NULL ,\"LiveHour\" INTEGER NOT NULL );");
    }

    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"USER_ENTITY\"";
        db.execSQL(sql);
    }

    protected final void bindValues(DatabaseStatement stmt, UserEntity entity) {
        String about;
        Long updateTime;
        String avatar;
        String fileIdent;
        String userName;
        String session;
        stmt.clearBindings();
        Long userID = entity.getUserID();
        if (userID != null) {
            stmt.bindLong(1, userID.longValue());
        }
        if ((session = entity.getSession()) != null) {
            stmt.bindString(2, session);
        }
        if ((userName = entity.getUserName()) != null) {
            stmt.bindString(3, userName);
        }
        if ((fileIdent = entity.getFileIdent()) != null) {
            stmt.bindString(4, fileIdent);
        }
        if ((avatar = entity.getAvatar()) != null) {
            stmt.bindString(5, avatar);
        }
        if ((updateTime = entity.getUpdateTime()) != null) {
            stmt.bindLong(6, updateTime.longValue());
        }
        if ((about = entity.getAbout()) != null) {
            stmt.bindString(7, about);
        }
        stmt.bindLong(8, (long)entity.getLikeCount());
        stmt.bindLong(9, (long)entity.getVideoCount());
        stmt.bindLong(10, (long)entity.getLiveHour());
    }

    protected final void bindValues(SQLiteStatement stmt, UserEntity entity) {
        String about;
        Long updateTime;
        String avatar;
        String fileIdent;
        String userName;
        String session;
        stmt.clearBindings();
        Long userID = entity.getUserID();
        if (userID != null) {
            stmt.bindLong(1, userID.longValue());
        }
        if ((session = entity.getSession()) != null) {
            stmt.bindString(2, session);
        }
        if ((userName = entity.getUserName()) != null) {
            stmt.bindString(3, userName);
        }
        if ((fileIdent = entity.getFileIdent()) != null) {
            stmt.bindString(4, fileIdent);
        }
        if ((avatar = entity.getAvatar()) != null) {
            stmt.bindString(5, avatar);
        }
        if ((updateTime = entity.getUpdateTime()) != null) {
            stmt.bindLong(6, updateTime.longValue());
        }
        if ((about = entity.getAbout()) != null) {
            stmt.bindString(7, about);
        }
        stmt.bindLong(8, (long)entity.getLikeCount());
        stmt.bindLong(9, (long)entity.getVideoCount());
        stmt.bindLong(10, (long)entity.getLiveHour());
    }

    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0));
    }

    public UserEntity readEntity(Cursor cursor, int offset) {
        UserEntity entity = new UserEntity(cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0)), cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1), cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2), cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3), cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4), cursor.isNull(offset + 5) ? null : Long.valueOf(cursor.getLong(offset + 5)), cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6), cursor.getInt(offset + 7), cursor.getInt(offset + 8), cursor.getInt(offset + 9));
        return entity;
    }

    public void readEntity(Cursor cursor, UserEntity entity, int offset) {
        entity.setUserID(cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0)));
        entity.setSession(cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1));
        entity.setUserName(cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2));
        entity.setFileIdent(cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3));
        entity.setAvatar(cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4));
        entity.setUpdateTime(cursor.isNull(offset + 5) ? null : Long.valueOf(cursor.getLong(offset + 5)));
        entity.setAbout(cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6));
        entity.setLikeCount(cursor.getInt(offset + 7));
        entity.setVideoCount(cursor.getInt(offset + 8));
        entity.setLiveHour(cursor.getInt(offset + 9));
    }

    protected final Long updateKeyAfterInsert(UserEntity entity, long rowId) {
        entity.setUserID(rowId);
        return rowId;
    }

    public Long getKey(UserEntity entity) {
        if (entity != null) {
            return entity.getUserID();
        }
        return null;
    }

    public boolean hasKey(UserEntity entity) {
        return entity.getUserID() != null;
    }

    protected final boolean isEntityUpdateable() {
        return true;
    }

    public static class Properties {
        public static final Property UserID = new Property(0, Long.class, "userID", true, "UserID");
        public static final Property Session = new Property(1, String.class, "session", false, "Session");
        public static final Property UserName = new Property(2, String.class, "userName", false, "UserName");
        public static final Property FileIdent = new Property(3, String.class, "fileIdent", false, "FileIdent");
        public static final Property Avatar = new Property(4, String.class, "avatar", false, "Avatar");
        public static final Property UpdateTime = new Property(5, Long.class, "updateTime", false, "UpdateTime");
        public static final Property About = new Property(6, String.class, "about", false, "About");
        public static final Property LikeCount = new Property(7, Integer.TYPE, "likeCount", false, "LikeCount");
        public static final Property VideoCount = new Property(8, Integer.TYPE, "videoCount", false, "VideoCount");
        public static final Property LiveHour = new Property(9, Integer.TYPE, "liveHour", false, "LiveHour");
    }
}

