/*
 * Decompiled with CFR 0.152.
 */
package cn.robotpen.model.db;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;
import cn.robotpen.model.db.DaoSession;
import cn.robotpen.model.entity.note.TrailsEntity;
import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.AbstractDaoSession;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;
import org.greenrobot.greendao.internal.DaoConfig;

public class TrailsEntityDao
extends AbstractDao<TrailsEntity, Long> {
    public static final String TABLENAME = "TRAILS_ENTITY";

    public TrailsEntityDao(DaoConfig config) {
        super(config);
    }

    public TrailsEntityDao(DaoConfig config, DaoSession daoSession) {
        super(config, (AbstractDaoSession)daoSession);
    }

    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists ? "IF NOT EXISTS " : "";
        db.execSQL("CREATE TABLE " + constraint + "\"TRAILS_ENTITY\" (\"TrailID\" INTEGER PRIMARY KEY AUTOINCREMENT ,\"ExtInfo\" TEXT,\"Block\" TEXT,\"Color\" INTEGER NOT NULL ,\"Type\" INTEGER NOT NULL ,\"UserID\" INTEGER,\"StartTime\" INTEGER,\"EndTime\" INTEGER,\"Data\" BLOB);");
        db.execSQL("CREATE INDEX " + constraint + "Index_Block ON \"TRAILS_ENTITY\" (\"Block\" ASC);");
    }

    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"TRAILS_ENTITY\"";
        db.execSQL(sql);
    }

    protected final void bindValues(DatabaseStatement stmt, TrailsEntity entity) {
        byte[] data;
        Long endTime;
        Long startTime;
        String block;
        String extInfo;
        stmt.clearBindings();
        Long trailID = entity.getTrailID();
        if (trailID != null) {
            stmt.bindLong(1, trailID.longValue());
        }
        if ((extInfo = entity.getExtInfo()) != null) {
            stmt.bindString(2, extInfo);
        }
        if ((block = entity.getBlock()) != null) {
            stmt.bindString(3, block);
        }
        stmt.bindLong(4, (long)entity.getColor());
        stmt.bindLong(5, (long)entity.getTrailType());
        Long userId = entity.getUserId();
        if (userId != null) {
            stmt.bindLong(6, userId.longValue());
        }
        if ((startTime = Long.valueOf(entity.getStartTime())) != null) {
            stmt.bindLong(7, startTime.longValue());
        }
        if ((endTime = Long.valueOf(entity.getEndTime())) != null) {
            stmt.bindLong(8, endTime.longValue());
        }
        if ((data = entity.getData()) != null) {
            stmt.bindBlob(9, data);
        }
    }

    protected final void bindValues(SQLiteStatement stmt, TrailsEntity entity) {
        byte[] data;
        Long endTime;
        Long startTime;
        String block;
        String extInfo;
        stmt.clearBindings();
        Long trailID = entity.getTrailID();
        if (trailID != null) {
            stmt.bindLong(1, trailID.longValue());
        }
        if ((extInfo = entity.getExtInfo()) != null) {
            stmt.bindString(2, extInfo);
        }
        if ((block = entity.getBlock()) != null) {
            stmt.bindString(3, block);
        }
        stmt.bindLong(4, (long)entity.getColor());
        stmt.bindLong(5, (long)entity.getTrailType());
        Long userId = entity.getUserId();
        if (userId != null) {
            stmt.bindLong(6, userId.longValue());
        }
        if ((startTime = Long.valueOf(entity.getStartTime())) != null) {
            stmt.bindLong(7, startTime.longValue());
        }
        if ((endTime = Long.valueOf(entity.getEndTime())) != null) {
            stmt.bindLong(8, endTime.longValue());
        }
        if ((data = entity.getData()) != null) {
            stmt.bindBlob(9, data);
        }
    }

    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0));
    }

    public TrailsEntity readEntity(Cursor cursor, int offset) {
        TrailsEntity entity = new TrailsEntity(cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0)), cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1), cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2), cursor.getInt(offset + 3), cursor.getInt(offset + 4), cursor.isNull(offset + 5) ? null : Long.valueOf(cursor.getLong(offset + 5)), cursor.isNull(offset + 6) ? null : Long.valueOf(cursor.getLong(offset + 6)), cursor.isNull(offset + 7) ? null : Long.valueOf(cursor.getLong(offset + 7)), cursor.isNull(offset + 8) ? null : cursor.getBlob(offset + 8));
        return entity;
    }

    public void readEntity(Cursor cursor, TrailsEntity entity, int offset) {
        entity.setTrailID(cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0)));
        entity.setExtInfo(cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1));
        entity.setBlock(cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2));
        entity.setColor(cursor.getInt(offset + 3));
        entity.setTrailType(cursor.getInt(offset + 4));
        entity.setUserId(cursor.isNull(offset + 5) ? null : Long.valueOf(cursor.getLong(offset + 5)));
        entity.setStartTime(cursor.isNull(offset + 6) ? null : Long.valueOf(cursor.getLong(offset + 6)));
        entity.setEndTime(cursor.isNull(offset + 7) ? null : Long.valueOf(cursor.getLong(offset + 7)));
        entity.setData(cursor.isNull(offset + 8) ? null : cursor.getBlob(offset + 8));
    }

    protected final Long updateKeyAfterInsert(TrailsEntity entity, long rowId) {
        entity.setTrailID(rowId);
        return rowId;
    }

    public Long getKey(TrailsEntity entity) {
        if (entity != null) {
            return entity.getTrailID();
        }
        return null;
    }

    public boolean hasKey(TrailsEntity entity) {
        return entity.getTrailID() != null;
    }

    protected final boolean isEntityUpdateable() {
        return true;
    }

    public static class Properties {
        public static final Property TrailID = new Property(0, Long.class, "trailID", true, "TrailID");
        public static final Property ExtInfo = new Property(1, String.class, "extInfo", false, "ExtInfo");
        public static final Property Block = new Property(2, String.class, "block", false, "Block");
        public static final Property Color = new Property(3, Integer.TYPE, "color", false, "Color");
        public static final Property TrailType = new Property(4, Integer.TYPE, "trailType", false, "Type");
        public static final Property UserId = new Property(5, Long.class, "userId", false, "UserID");
        public static final Property StartTime = new Property(6, Long.class, "startTime", false, "StartTime");
        public static final Property EndTime = new Property(7, Long.class, "endTime", false, "EndTime");
        public static final Property Data = new Property(8, byte[].class, "data", false, "Data");
    }
}

