/*
 * Decompiled with CFR 0.152.
 */
package cn.robotpen.model.db;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;
import cn.robotpen.model.db.DaoSession;
import cn.robotpen.model.entity.TagEntity;
import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.AbstractDaoSession;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;
import org.greenrobot.greendao.internal.DaoConfig;

public class TagEntityDao
extends AbstractDao<TagEntity, Long> {
    public static final String TABLENAME = "TAG_ENTITY";

    public TagEntityDao(DaoConfig config) {
        super(config);
    }

    public TagEntityDao(DaoConfig config, DaoSession daoSession) {
        super(config, (AbstractDaoSession)daoSession);
    }

    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists ? "IF NOT EXISTS " : "";
        db.execSQL("CREATE TABLE " + constraint + "\"TAG_ENTITY\" (\"id\" INTEGER PRIMARY KEY AUTOINCREMENT ,\"Tag\" TEXT,\"CreatedTime\" INTEGER,\"Flag\" INTEGER);");
    }

    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"TAG_ENTITY\"";
        db.execSQL(sql);
    }

    protected final void bindValues(DatabaseStatement stmt, TagEntity entity) {
        Integer flag;
        Long createTime;
        String tag;
        stmt.clearBindings();
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id.longValue());
        }
        if ((tag = entity.getTag()) != null) {
            stmt.bindString(2, tag);
        }
        if ((createTime = entity.getCreateTime()) != null) {
            stmt.bindLong(3, createTime.longValue());
        }
        if ((flag = entity.getFlag()) != null) {
            stmt.bindLong(4, (long)flag.intValue());
        }
    }

    protected final void bindValues(SQLiteStatement stmt, TagEntity entity) {
        Integer flag;
        Long createTime;
        String tag;
        stmt.clearBindings();
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id.longValue());
        }
        if ((tag = entity.getTag()) != null) {
            stmt.bindString(2, tag);
        }
        if ((createTime = entity.getCreateTime()) != null) {
            stmt.bindLong(3, createTime.longValue());
        }
        if ((flag = entity.getFlag()) != null) {
            stmt.bindLong(4, (long)flag.intValue());
        }
    }

    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0));
    }

    public TagEntity readEntity(Cursor cursor, int offset) {
        TagEntity entity = new TagEntity(cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0)), cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1), cursor.isNull(offset + 2) ? null : Long.valueOf(cursor.getLong(offset + 2)), cursor.isNull(offset + 3) ? null : Integer.valueOf(cursor.getInt(offset + 3)));
        return entity;
    }

    public void readEntity(Cursor cursor, TagEntity entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0)));
        entity.setTag(cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1));
        entity.setCreateTime(cursor.isNull(offset + 2) ? null : Long.valueOf(cursor.getLong(offset + 2)));
        entity.setFlag(cursor.isNull(offset + 3) ? null : Integer.valueOf(cursor.getInt(offset + 3)));
    }

    protected final Long updateKeyAfterInsert(TagEntity entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }

    public Long getKey(TagEntity entity) {
        if (entity != null) {
            return entity.getId();
        }
        return null;
    }

    public boolean hasKey(TagEntity entity) {
        return entity.getId() != null;
    }

    protected final boolean isEntityUpdateable() {
        return true;
    }

    public static class Properties {
        public static final Property Id = new Property(0, Long.class, "id", true, "id");
        public static final Property Tag = new Property(1, String.class, "tag", false, "Tag");
        public static final Property CreateTime = new Property(2, Long.class, "createTime", false, "CreatedTime");
        public static final Property Flag = new Property(3, Integer.class, "flag", false, "Flag");
    }
}

