/*
 * Decompiled with CFR 0.152.
 */
package cn.robotpen.model.db;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;
import cn.robotpen.model.db.DaoSession;
import cn.robotpen.model.entity.note.NoteEntity;
import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.AbstractDaoSession;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;
import org.greenrobot.greendao.internal.DaoConfig;

public class NoteEntityDao
extends AbstractDao<NoteEntity, Long> {
    public static final String TABLENAME = "NOTE_ENTITY";

    public NoteEntityDao(DaoConfig config) {
        super(config);
    }

    public NoteEntityDao(DaoConfig config, DaoSession daoSession) {
        super(config, (AbstractDaoSession)daoSession);
    }

    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists ? "IF NOT EXISTS " : "";
        db.execSQL("CREATE TABLE " + constraint + "\"NOTE_ENTITY\" (\"NoteID\" INTEGER PRIMARY KEY AUTOINCREMENT ,\"NoteKey\" TEXT NOT NULL ,\"UserId\" INTEGER,\"Title\" TEXT,\"DeviceType\" INTEGER NOT NULL ,\"IsHorizontal\" INTEGER NOT NULL ,\"CreateTime\" INTEGER NOT NULL ,\"UpdateTime\" INTEGER NOT NULL );");
        db.execSQL("CREATE INDEX " + constraint + "NoteKey ON \"NOTE_ENTITY\" (\"NoteKey\" ASC);");
        db.execSQL("CREATE INDEX " + constraint + "UpdateTime ON \"NOTE_ENTITY\" (\"UpdateTime\" ASC);");
    }

    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"NOTE_ENTITY\"";
        db.execSQL(sql);
    }

    protected final void bindValues(DatabaseStatement stmt, NoteEntity entity) {
        String title;
        stmt.clearBindings();
        Long noteID = entity.getNoteID();
        if (noteID != null) {
            stmt.bindLong(1, noteID.longValue());
        }
        stmt.bindString(2, entity.getNoteKey());
        Long userId = entity.getUserId();
        if (userId != null) {
            stmt.bindLong(3, userId.longValue());
        }
        if ((title = entity.getTitle()) != null) {
            stmt.bindString(4, title);
        }
        stmt.bindLong(5, (long)entity.getDeviceType());
        stmt.bindLong(6, (long)entity.getIsHorizontal());
        stmt.bindLong(7, (long)entity.getCreateTime());
        stmt.bindLong(8, (long)entity.getUpdateTime());
    }

    protected final void bindValues(SQLiteStatement stmt, NoteEntity entity) {
        String title;
        stmt.clearBindings();
        Long noteID = entity.getNoteID();
        if (noteID != null) {
            stmt.bindLong(1, noteID.longValue());
        }
        stmt.bindString(2, entity.getNoteKey());
        Long userId = entity.getUserId();
        if (userId != null) {
            stmt.bindLong(3, userId.longValue());
        }
        if ((title = entity.getTitle()) != null) {
            stmt.bindString(4, title);
        }
        stmt.bindLong(5, (long)entity.getDeviceType());
        stmt.bindLong(6, (long)entity.getIsHorizontal());
        stmt.bindLong(7, (long)entity.getCreateTime());
        stmt.bindLong(8, (long)entity.getUpdateTime());
    }

    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0));
    }

    public NoteEntity readEntity(Cursor cursor, int offset) {
        NoteEntity entity = new NoteEntity(cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0)), cursor.getString(offset + 1), cursor.isNull(offset + 2) ? null : Long.valueOf(cursor.getLong(offset + 2)), cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3), cursor.getInt(offset + 4), cursor.getInt(offset + 5), cursor.getInt(offset + 6), cursor.getInt(offset + 7));
        return entity;
    }

    public void readEntity(Cursor cursor, NoteEntity entity, int offset) {
        entity.setNoteID(cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0)));
        entity.setNoteKey(cursor.getString(offset + 1));
        entity.setUserId(cursor.isNull(offset + 2) ? null : Long.valueOf(cursor.getLong(offset + 2)));
        entity.setTitle(cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3));
        entity.setDeviceType(cursor.getInt(offset + 4));
        entity.setIsHorizontal(cursor.getInt(offset + 5));
        entity.setCreateTime(cursor.getInt(offset + 6));
        entity.setUpdateTime(cursor.getInt(offset + 7));
    }

    protected final Long updateKeyAfterInsert(NoteEntity entity, long rowId) {
        entity.setNoteID(rowId);
        return rowId;
    }

    public Long getKey(NoteEntity entity) {
        if (entity != null) {
            return entity.getNoteID();
        }
        return null;
    }

    public boolean hasKey(NoteEntity entity) {
        return entity.getNoteID() != null;
    }

    protected final boolean isEntityUpdateable() {
        return true;
    }

    public static class Properties {
        public static final Property NoteID = new Property(0, Long.class, "noteID", true, "NoteID");
        public static final Property NoteKey = new Property(1, String.class, "noteKey", false, "NoteKey");
        public static final Property UserId = new Property(2, Long.class, "userId", false, "UserId");
        public static final Property Title = new Property(3, String.class, "title", false, "Title");
        public static final Property DeviceType = new Property(4, Integer.TYPE, "deviceType", false, "DeviceType");
        public static final Property IsHorizontal = new Property(5, Integer.TYPE, "isHorizontal", false, "IsHorizontal");
        public static final Property CreateTime = new Property(6, Integer.TYPE, "createTime", false, "CreateTime");
        public static final Property UpdateTime = new Property(7, Integer.TYPE, "updateTime", false, "UpdateTime");
    }
}

