/*
 * Decompiled with CFR 0.152.
 */
package cn.robotpen.model.db;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import cn.robotpen.model.db.BlockEntityDao;
import cn.robotpen.model.db.DaoSession;
import cn.robotpen.model.db.NoteEntityDao;
import cn.robotpen.model.db.TagEntityDao;
import cn.robotpen.model.db.TrailsEntityDao;
import cn.robotpen.model.db.UserEntityDao;
import cn.robotpen.model.db.VideoEntityDao;
import org.greenrobot.greendao.AbstractDaoMaster;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseOpenHelper;
import org.greenrobot.greendao.database.StandardDatabase;
import org.greenrobot.greendao.identityscope.IdentityScopeType;

public class DaoMaster
extends AbstractDaoMaster {
    public static final int SCHEMA_VERSION = 9;

    public static void createAllTables(Database db, boolean ifNotExists) {
        BlockEntityDao.createTable(db, ifNotExists);
        NoteEntityDao.createTable(db, ifNotExists);
        TrailsEntityDao.createTable(db, ifNotExists);
        TagEntityDao.createTable(db, ifNotExists);
        UserEntityDao.createTable(db, ifNotExists);
        VideoEntityDao.createTable(db, ifNotExists);
    }

    public static void dropAllTables(Database db, boolean ifExists) {
        BlockEntityDao.dropTable(db, ifExists);
        NoteEntityDao.dropTable(db, ifExists);
        TrailsEntityDao.dropTable(db, ifExists);
        TagEntityDao.dropTable(db, ifExists);
        UserEntityDao.dropTable(db, ifExists);
        VideoEntityDao.dropTable(db, ifExists);
    }

    public static DaoSession newDevSession(Context context, String name) {
        Database db = new DevOpenHelper(context, name).getWritableDb();
        DaoMaster daoMaster = new DaoMaster(db);
        return daoMaster.newSession();
    }

    public DaoMaster(SQLiteDatabase db) {
        this((Database)new StandardDatabase(db));
    }

    public DaoMaster(Database db) {
        super(db, 9);
        this.registerDaoClass(BlockEntityDao.class);
        this.registerDaoClass(NoteEntityDao.class);
        this.registerDaoClass(TrailsEntityDao.class);
        this.registerDaoClass(TagEntityDao.class);
        this.registerDaoClass(UserEntityDao.class);
        this.registerDaoClass(VideoEntityDao.class);
    }

    public DaoSession newSession() {
        return new DaoSession(this.db, IdentityScopeType.Session, this.daoConfigMap);
    }

    public DaoSession newSession(IdentityScopeType type) {
        return new DaoSession(this.db, type, this.daoConfigMap);
    }

    public static class DevOpenHelper
    extends OpenHelper {
        public DevOpenHelper(Context context, String name) {
            super(context, name);
        }

        public DevOpenHelper(Context context, String name, SQLiteDatabase.CursorFactory factory) {
            super(context, name, factory);
        }

        public void onUpgrade(Database db, int oldVersion, int newVersion) {
            Log.i((String)"greenDAO", (String)("Upgrading schema from version " + oldVersion + " to " + newVersion + " by dropping all tables"));
            DaoMaster.dropAllTables(db, true);
            this.onCreate(db);
        }
    }

    public static abstract class OpenHelper
    extends DatabaseOpenHelper {
        public OpenHelper(Context context, String name) {
            super(context, name, 9);
        }

        public OpenHelper(Context context, String name, SQLiteDatabase.CursorFactory factory) {
            super(context, name, factory, 9);
        }

        public void onCreate(Database db) {
            Log.i((String)"greenDAO", (String)"Creating tables for schema version 9");
            DaoMaster.createAllTables(db, false);
        }
    }
}

