/*
 * Decompiled with CFR 0.152.
 */
package cn.robotpen.model.db;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;
import cn.robotpen.model.db.DaoSession;
import cn.robotpen.model.entity.note.BlockEntity;
import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.AbstractDaoSession;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;
import org.greenrobot.greendao.internal.DaoConfig;

public class BlockEntityDao
extends AbstractDao<BlockEntity, Long> {
    public static final String TABLENAME = "BLOCK_ENTITY";

    public BlockEntityDao(DaoConfig config) {
        super(config);
    }

    public BlockEntityDao(DaoConfig config, DaoSession daoSession) {
        super(config, (AbstractDaoSession)daoSession);
    }

    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists ? "IF NOT EXISTS " : "";
        db.execSQL("CREATE TABLE " + constraint + "\"BLOCK_ENTITY\" (\"BlockId\" INTEGER PRIMARY KEY AUTOINCREMENT ,\"NoteKey\" TEXT NOT NULL ,\"BlockKey\" TEXT NOT NULL ,\"NextKey\" TEXT,\"CreateTime\" INTEGER,\"UpdateTime\" INTEGER,\"PageNumber\" INTEGER);");
        db.execSQL("CREATE INDEX " + constraint + "Index_NoteKey ON \"BLOCK_ENTITY\" (\"NoteKey\" ASC);");
        db.execSQL("CREATE INDEX " + constraint + "Index_BlockKey ON \"BLOCK_ENTITY\" (\"BlockKey\" ASC);");
    }

    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"BLOCK_ENTITY\"";
        db.execSQL(sql);
    }

    protected final void bindValues(DatabaseStatement stmt, BlockEntity entity) {
        Long pageNumber;
        Long updateTime;
        Long createTime;
        stmt.clearBindings();
        Long blockId = entity.getBlockId();
        if (blockId != null) {
            stmt.bindLong(1, blockId.longValue());
        }
        stmt.bindString(2, entity.getNoteKey());
        stmt.bindString(3, entity.getBlockKey());
        String nextBlock = entity.getNextBlock();
        if (nextBlock != null) {
            stmt.bindString(4, nextBlock);
        }
        if ((createTime = entity.getCreateTime()) != null) {
            stmt.bindLong(5, createTime.longValue());
        }
        if ((updateTime = entity.getUpdateTime()) != null) {
            stmt.bindLong(6, updateTime.longValue());
        }
        if ((pageNumber = entity.getPageNumber()) != null) {
            stmt.bindLong(7, pageNumber.longValue());
        }
    }

    protected final void bindValues(SQLiteStatement stmt, BlockEntity entity) {
        Long pageNumber;
        Long updateTime;
        Long createTime;
        stmt.clearBindings();
        Long blockId = entity.getBlockId();
        if (blockId != null) {
            stmt.bindLong(1, blockId.longValue());
        }
        stmt.bindString(2, entity.getNoteKey());
        stmt.bindString(3, entity.getBlockKey());
        String nextBlock = entity.getNextBlock();
        if (nextBlock != null) {
            stmt.bindString(4, nextBlock);
        }
        if ((createTime = entity.getCreateTime()) != null) {
            stmt.bindLong(5, createTime.longValue());
        }
        if ((updateTime = entity.getUpdateTime()) != null) {
            stmt.bindLong(6, updateTime.longValue());
        }
        if ((pageNumber = entity.getPageNumber()) != null) {
            stmt.bindLong(7, pageNumber.longValue());
        }
    }

    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0));
    }

    public BlockEntity readEntity(Cursor cursor, int offset) {
        BlockEntity entity = new BlockEntity(cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0)), cursor.getString(offset + 1), cursor.getString(offset + 2), cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3), cursor.isNull(offset + 4) ? null : Long.valueOf(cursor.getLong(offset + 4)), cursor.isNull(offset + 5) ? null : Long.valueOf(cursor.getLong(offset + 5)), cursor.isNull(offset + 6) ? null : Long.valueOf(cursor.getLong(offset + 6)));
        return entity;
    }

    public void readEntity(Cursor cursor, BlockEntity entity, int offset) {
        entity.setBlockId(cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0)));
        entity.setNoteKey(cursor.getString(offset + 1));
        entity.setBlockKey(cursor.getString(offset + 2));
        entity.setNextBlock(cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3));
        entity.setCreateTime(cursor.isNull(offset + 4) ? null : Long.valueOf(cursor.getLong(offset + 4)));
        entity.setUpdateTime(cursor.isNull(offset + 5) ? null : Long.valueOf(cursor.getLong(offset + 5)));
        entity.setPageNumber(cursor.isNull(offset + 6) ? null : Long.valueOf(cursor.getLong(offset + 6)));
    }

    protected final Long updateKeyAfterInsert(BlockEntity entity, long rowId) {
        entity.setBlockId(rowId);
        return rowId;
    }

    public Long getKey(BlockEntity entity) {
        if (entity != null) {
            return entity.getBlockId();
        }
        return null;
    }

    public boolean hasKey(BlockEntity entity) {
        return entity.getBlockId() != null;
    }

    protected final boolean isEntityUpdateable() {
        return true;
    }

    public static class Properties {
        public static final Property BlockId = new Property(0, Long.class, "blockId", true, "BlockId");
        public static final Property NoteKey = new Property(1, String.class, "noteKey", false, "NoteKey");
        public static final Property BlockKey = new Property(2, String.class, "blockKey", false, "BlockKey");
        public static final Property NextBlock = new Property(3, String.class, "nextBlock", false, "NextKey");
        public static final Property CreateTime = new Property(4, Long.class, "createTime", false, "CreateTime");
        public static final Property UpdateTime = new Property(5, Long.class, "updateTime", false, "UpdateTime");
        public static final Property PageNumber = new Property(6, Long.class, "pageNumber", false, "PageNumber");
    }
}

