/*
 * Decompiled with CFR 0.152.
 */
package cn.robotpen.model;

import cn.robotpen.model.symbol.DeviceType;
import cn.robotpen.utils.log.CLog;

public class DevicePoint {
    private static final Object sPoolSync = new Object();
    private static DevicePoint sPool;
    private static int sPoolSize;
    private static final int MAX_POOL_SIZE = 50;
    private DevicePoint next;
    private static final int FLAG_IN_USE = 1;
    private int flags;
    public static final int VALUE_P1_WIDTH = 17407;
    public static final int VALUE_P1_HEIGHT = 10751;
    public static final int VALUE_P7_WIDTH = 14335;
    public static final int VALUE_P7_HEIGHT = 8191;
    public static final int VALUE_ELITE_WIDTH = 14335;
    public static final int VALUE_ELITE_HEIGHT = 8191;
    public static final int VALUE_ELITE_PLUS_WIDTH = 22015;
    public static final int VALUE_ELITE_PLUS_HEIGHT = 15359;
    public static final int VALUE_XINGYUAN_WIDTH = 14300;
    public static final int VALUE_XINGYUAN_HEIGHT = 7950;
    public static final int VALUE_J0_WIDTH = 14435;
    public static final int VALUE_J0_HEIGHT = 8191;
    public static final int VALUE_X8_WIDTH = 22100;
    public static final int VALUE_X8_HEIGHT = 14650;
    public static final int VALUE_K7W_WIDTH = 22600;
    public static final int VALUE_K7W_HEIGHT = 16650;
    public static final int VALUE_A4_WIDTH = 22600;
    public static final int VALUE_A4_HEIGHT = 16650;
    public static final int VALUE_TEST_WIDTH = 19600;
    public static final int VALUE_TEST_HEIGHT = 12550;
    private static final short VALUE_PRESSURE = 1023;
    public static final byte POINT_STATE_LEAVE = 0;
    public static final byte POINT_STATE_UP = 16;
    public static final byte POINT_STATE_DOWN = 17;
    private float width;
    private float height;
    private float windowWidth;
    private float windowHeight;
    private boolean isHorizontal;
    private DeviceType deviceType = DeviceType.TOUCH;
    private float originalX;
    private float originalY;
    private float offsetX;
    private float offsetY;
    private short pressureValue = (short)1023;
    private byte stateValue = 0;

    public DevicePoint() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DevicePoint obtain(int deviceType, int x, int y, int pressure, byte state) {
        Object object = sPoolSync;
        synchronized (object) {
            if (sPool != null) {
                DevicePoint m = sPool;
                sPool = m.next;
                m.next = null;
                m.flags = 0;
                m.deviceType = DeviceType.toDeviceType(deviceType);
                m.originalX = x;
                m.originalY = y;
                m.pressureValue = (short)pressure;
                m.stateValue = state;
                --sPoolSize;
                return m;
            }
        }
        return new DevicePoint(deviceType, x, y, pressure, state);
    }

    public DevicePoint(int deviceType, float originalX, float originalY, int pressure, byte state) {
        this.deviceType = DeviceType.toDeviceType(deviceType);
        this.originalX = originalX;
        this.originalY = originalY;
        this.pressureValue = (short)pressure;
        this.stateValue = state;
    }

    public String bytes2Str(byte ... data) {
        StringBuffer sb = new StringBuffer();
        for (byte b : data) {
            String tem = Integer.toHexString(b & 0xFF).toUpperCase();
            sb.append(" 0x");
            sb.append(tem.length() < 2 ? "0" + tem : tem);
        }
        return sb.toString();
    }

    static final boolean validateT9E(byte data, DeviceType deviceType, String version) {
        boolean b;
        switch (deviceType) {
            case T9A: 
            case T9W_B_KZ: 
            case T9W_WX: 
            case T9A_EN: 
            case T9W: 
            case T9W_TY: 
            case T9W_B: 
            case T9B_ZXB: 
            case T9W_YJ: 
            case T9E: 
            case J0_T9: 
            case T8A: {
                if (Float.parseFloat(version.trim()) * 100.0f <= 22.0f) {
                    b = (data & 0xF0) == 240 || (data >> 5 & 7) == 7;
                    break;
                }
                b = (data >> 6 & 3) == 3;
                break;
            }
            case T9B_YD: 
            case T9B_YD2: 
            case T8B: 
            case T8C: 
            case J0_A4_P: {
                b = (data >> 6 & 3) == 3;
                break;
            }
            default: {
                b = (data & 0xF0) == 240 || (data >> 5 & 7) == 7;
            }
        }
        return b;
    }

    public boolean checkDevice(DeviceType deviceType) {
        return deviceType == DeviceType.J0_A4_P || deviceType == DeviceType.T9A || deviceType == DeviceType.T9W_B_KZ || deviceType == DeviceType.T9W_WX || deviceType == DeviceType.T9A_EN || deviceType == DeviceType.T9W || deviceType == DeviceType.T9W_QX || deviceType == DeviceType.T9W_TY || deviceType == DeviceType.T9W_YJ || deviceType == DeviceType.T9E || deviceType == DeviceType.J0_T9 || deviceType == DeviceType.T8A || deviceType == DeviceType.T8B || deviceType == DeviceType.T8C || deviceType == DeviceType.T9B_YD || deviceType == DeviceType.T9B_YD2;
    }

    public DevicePoint(DeviceType deviceType, byte[] data, int pos) {
        this.deviceType = DeviceType.TOUCH;
        this.pressureValue = (short)1023;
        this.stateValue = 0;
        boolean isPlus = deviceType.isElitePlus();
        this.deviceType = deviceType;
        if (pos <= data.length - 5) {
            if ((data[pos] & 0xF0) != 240 && (data[pos] >> 5 & 7) != 7 && (data[pos] >> 6 & 3) != 3) {
                throw new RuntimeException(data[pos] + " not valid data");
            }
            if ((data[pos] == -16 || data[pos] == -32) && data[pos + 1] == 0 && data[pos + 2] == 0 && data[pos + 3] == 0 && data[pos + 4] == 0) {
                this.stateValue = 0;
            } else {
                this.pressureValue = (short)((data[pos + 4] & 0xFF) * 4);
                this.stateValue = (byte)(this.pressureValue > 0 ? 17 : 16);
                this.originalX = (short)((data[pos + 2] & 0xFF) << 8 | data[pos + 3] & 0xFF) * 2;
                this.originalY = isPlus ? (deviceType == DeviceType.J0_A4_P ? (float)((short)((data[pos] & 0x3F) << 8 | data[pos + 1] & 0xFF) * 2) : (float)((short)((data[pos] & 0x1F) << 8 | data[pos + 1] & 0xFF) * 2)) : (float)((short)((data[pos] & 0xF) << 8 | data[pos + 1] & 0xFF) * 2);
            }
        } else {
            throw new RuntimeException(pos + "+5 > " + data.length);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DevicePoint(DeviceType deviceType, byte[] data, int pos, String version) {
        boolean isPlus = deviceType.isElitePlus();
        this.deviceType = deviceType;
        if (pos > data.length - 5) throw new RuntimeException(pos + "+5 > " + data.length);
        if (!DevicePoint.validateT9E(data[pos], deviceType, version)) throw new RuntimeException(data[pos] + " not valid data");
        if ((data[pos] == -16 || data[pos] == -32) && data[pos + 1] == 0 && data[pos + 2] == 0 && data[pos + 3] == 0 && data[pos + 4] == 0) {
            this.stateValue = 0;
            return;
        } else {
            this.pressureValue = (short)((data[pos + 4] & 0xFF) * 4);
            this.stateValue = (byte)(this.pressureValue > 0 ? 17 : 16);
            this.originalX = (short)((data[pos + 2] & 0xFF) << 8 | data[pos + 3] & 0xFF) * 2;
            this.originalY = isPlus ? (this.checkDevice(deviceType) ? (Float.parseFloat(version) * 100.0f <= 22.0f && DeviceType.T8A == deviceType ? (float)((short)((data[pos] & 0x1F) << 8 | data[pos + 1] & 0xFF) * 2) : (float)((short)((data[pos] & 0x3F) << 8 | data[pos + 1] & 0xFF) * 2)) : (float)((short)((data[pos] & 0x1F) << 8 | data[pos + 1] & 0xFF) * 2)) : (float)((short)((data[pos] & 0xF) << 8 | data[pos + 1] & 0xFF) * 2);
        }
    }

    boolean isInUse() {
        return (this.flags & 1) == 1;
    }

    public void recycle() {
        if (this.isInUse()) {
            return;
        }
        this.recycleUnchecked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recycleUnchecked() {
        this.flags = 1;
        Object object = sPoolSync;
        synchronized (object) {
            if (sPoolSize < 50) {
                this.next = sPool;
                sPool = this;
                ++sPoolSize;
            }
        }
    }

    public DevicePoint(DeviceType deviceType, boolean isHorizontal, float windowX, float windowY, float windowW, float windowH) {
        this.init(deviceType, isHorizontal, windowX, windowY, windowW, windowH);
    }

    public void init(DeviceType deviceType, boolean isHorizontal, float windowX, float windowY, float windowW, float windowH) {
        this.deviceType = deviceType;
        this.isHorizontal = isHorizontal;
        this.init(windowX, windowY, windowW, windowH);
    }

    public void init(float windowX, float windowY, float windowW, float windowH) {
        if (!this.isHorizontal) {
            this.windowWidth = windowH;
            this.windowHeight = windowW;
            this.originalX = (windowH - windowY) * (this.getWidth() / windowW);
            this.originalY = windowX * (this.getHeight() / windowH);
            if (this.deviceType.isElite() && !this.deviceType.isReverse()) {
                this.originalX = this.getHeight() - this.originalX;
                this.originalY = this.getWidth() - this.originalY;
            }
        } else {
            this.windowWidth = windowW;
            this.windowHeight = windowH;
            this.originalX = windowX * (this.getWidth() / windowW);
            this.originalY = windowY * (this.getHeight() / windowH);
            if (this.deviceType.isElite() && !this.deviceType.isReverse()) {
                this.originalX = this.getWidth() - this.originalX;
                this.originalY = this.getHeight() - this.originalY;
            }
        }
    }

    public float getWindowScale() {
        return this.windowWidth / this.getWidth();
    }

    public void setIsHorizontal(boolean isHorizontal) {
        this.isHorizontal = isHorizontal;
    }

    public boolean getIsHorizontal() {
        return this.isHorizontal;
    }

    public float getPressure() {
        return DevicePoint.getPressure(this.pressureValue);
    }

    public boolean isLeave() {
        return DevicePoint.isLeave(this.stateValue);
    }

    public boolean isRoute() {
        return DevicePoint.isRoute(this.stateValue);
    }

    public static float getPressure(short value) {
        return (float)value / 1023.0f;
    }

    public static boolean isLeave(byte state) {
        return state == 0;
    }

    public static boolean isRoute(byte state) {
        return state == 17;
    }

    public void setDeviceType(int deviceType) {
        this.setDeviceType(DeviceType.toDeviceType(deviceType));
    }

    public void setDeviceType(DeviceType value) {
        this.deviceType = value;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public void setWindowWidth(float value) {
        this.windowWidth = value;
    }

    public float getWindowWidth() {
        return this.windowWidth;
    }

    public void setWindowHeight(float value) {
        this.windowHeight = value;
    }

    public float getWindowHeight() {
        return this.windowHeight;
    }

    public void setCustomScene(short width, short height) {
        this.setCustomScene(width, height, 0.0f, 0.0f);
    }

    public void setCustomScene(float width, float height, float offsetX, float offsetY) {
        this.width = width;
        this.height = height;
        this.setOffset(offsetX, offsetY);
    }

    public void setOffset(float offsetX, float offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public float getOriginalX() {
        return this.originalX;
    }

    public float getOriginalY() {
        return this.originalY;
    }

    public void setOriginalX(float originalX) {
        this.originalX = originalX;
    }

    public void setOriginalY(float originalY) {
        this.originalY = originalY;
    }

    public void setPressureValue(short pressureValue) {
        this.pressureValue = pressureValue;
    }

    public short getPressureValue() {
        return this.pressureValue;
    }

    public void setStateValue(byte stateValue) {
        this.stateValue = stateValue;
    }

    public byte getStateValue() {
        return this.stateValue;
    }

    public float getOffsetX() {
        return this.offsetX;
    }

    public float getOffsetY() {
        return this.offsetY;
    }

    public float getWidth() {
        float w = DevicePoint.getWidth(this.deviceType, this.isHorizontal);
        if (w > 0.0f) {
            return w;
        }
        return this.width;
    }

    public float getHeight() {
        float h = DevicePoint.getHeight(this.deviceType, this.isHorizontal);
        if (h > 0.0f) {
            return h;
        }
        return this.height;
    }

    public static float getWidth(DeviceType deviceType, boolean isHorizontal) {
        switch (deviceType) {
            case TEST: {
                return isHorizontal ? 19600.0f : 12550.0f;
            }
            case T7P: 
            case T7P_NEW: {
                return isHorizontal ? 22015.0f : 15359.0f;
            }
            case T9A: 
            case T9W_B_KZ: 
            case T9W_WX: 
            case T9A_EN: 
            case T9W: 
            case T9W_TY: 
            case T9W_B: 
            case T9B_ZXB: 
            case T9W_YJ: 
            case T9E: 
            case J0_T9: 
            case T8A: 
            case T9B_YD: 
            case T9B_YD2: 
            case T8B: 
            case T8C: 
            case J0_A4_P: 
            case T8S: 
            case T8B_D2: 
            case T9W_QX: 
            case T9_J0: 
            case J0_A4: {
                return isHorizontal ? 22600.0f : 16650.0f;
            }
            case ELITE_XINYUAN: {
                return isHorizontal ? 14300.0f : 7950.0f;
            }
            case J0_A5: {
                return isHorizontal ? 14435.0f : 8191.0f;
            }
            case X8E_A5: 
            case X8: {
                return isHorizontal ? 22100.0f : 14650.0f;
            }
            case T7E: 
            case T7E_NEW: 
            case J7E: 
            case K7_HW: 
            case T7E_HFHH: 
            case P1_CX_M3: 
            case S1_DE: 
            case W7: 
            case C7: 
            case T7_TS: 
            case T7_LW: 
            case T7_CY: 
            case T7: 
            case T7_A: 
            case T7C_BN: 
            case T7_HI: 
            case T7B_HF: 
            case J7B_HF: 
            case J7B: 
            case J7B_ZY: {
                return isHorizontal ? 14335.0f : 8191.0f;
            }
            case P7: 
            case S7_JD: 
            case S7_SD: 
            case S7_JD_M3: {
                return isHorizontal ? 14335.0f : 8191.0f;
            }
            case P1: {
                return isHorizontal ? 17407.0f : 10751.0f;
            }
            case K7W: {
                return isHorizontal ? 22600.0f : 16650.0f;
            }
        }
        return 0.0f;
    }

    public static float getHeight(DeviceType deviceType, boolean isHorizontal) {
        switch (deviceType) {
            case TEST: {
                return isHorizontal ? 12550.0f : 19600.0f;
            }
            case T7P: 
            case T7P_NEW: {
                return isHorizontal ? 15359.0f : 22015.0f;
            }
            case T9A: 
            case T9W_B_KZ: 
            case T9W_WX: 
            case T9A_EN: 
            case T9W: 
            case T9W_TY: 
            case T9W_B: 
            case T9B_ZXB: 
            case T9W_YJ: 
            case T9E: 
            case J0_T9: 
            case T8A: 
            case T9B_YD: 
            case T9B_YD2: 
            case T8B: 
            case T8C: 
            case J0_A4_P: 
            case T8S: 
            case T9W_QX: 
            case T9_J0: 
            case J0_A4: {
                return isHorizontal ? 16650.0f : 22600.0f;
            }
            case ELITE_XINYUAN: {
                return isHorizontal ? 7950.0f : 14300.0f;
            }
            case J0_A5: {
                return isHorizontal ? 8191.0f : 14435.0f;
            }
            case X8E_A5: 
            case X8: {
                return isHorizontal ? 14650.0f : 22100.0f;
            }
            case T7E: 
            case T7E_NEW: 
            case J7E: 
            case K7_HW: 
            case T7E_HFHH: 
            case P1_CX_M3: 
            case S1_DE: 
            case W7: 
            case C7: 
            case T7_TS: 
            case T7_LW: 
            case T7_CY: 
            case T7: 
            case T7_A: 
            case T7C_BN: 
            case T7_HI: 
            case T7B_HF: 
            case J7B_HF: 
            case J7B: 
            case J7B_ZY: {
                return isHorizontal ? 8191.0f : 14335.0f;
            }
            case P1: {
                return isHorizontal ? 10751.0f : 17407.0f;
            }
            case P7: 
            case S7_JD: 
            case S7_SD: 
            case S7_JD_M3: {
                return isHorizontal ? 8191.0f : 14335.0f;
            }
            case K7W: {
                return isHorizontal ? 16650.0f : 22600.0f;
            }
        }
        return 0.0f;
    }

    public static float getPenWidth(DeviceType deviceType) {
        if (deviceType.isElitePlus()) {
            return 22.0f;
        }
        return 12.0f;
    }

    public float getWindowX() {
        if (this.deviceType == DeviceType.TOUCH) {
            return this.originalX;
        }
        return this.getWindowX(this.windowWidth);
    }

    public float getWindowX(float showWidth) {
        float x = this.isHorizontal ? (this.deviceType.isElite() && !this.deviceType.isReverse() ? this.getWidth() - this.originalX : this.originalX) : (this.deviceType.isElite() && !this.deviceType.isReverse() ? this.getWidth() - this.originalY : this.originalY);
        float value = x + this.offsetX;
        if (showWidth > 0.0f) {
            value = value * showWidth / this.getWidth();
        }
        return value;
    }

    public float getWindowY() {
        if (this.deviceType == DeviceType.TOUCH) {
            return this.originalY;
        }
        return this.getWindowY(this.windowHeight);
    }

    public float getWindowY(float showHeight) {
        CLog.d((Object)("thet showHeight:" + showHeight));
        float y = this.isHorizontal ? (this.deviceType.isElite() && !this.deviceType.isReverse() ? this.getHeight() - this.originalY : this.originalY) : (this.deviceType.isElite() && !this.deviceType.isReverse() ? this.originalX : this.getHeight() - this.originalX);
        float value = y + this.offsetY;
        if (showHeight > 0.0f) {
            value = value * showHeight / this.getHeight();
        }
        return value;
    }

    public String toString() {
        return "isRoute:" + this.isRoute() + ",x:" + this.originalX + ",y:" + this.originalY + "\nisHorizontal:" + this.isHorizontal + "  windowX:" + this.getWindowX() + ",windowY:" + this.getWindowY() + ",pressure:" + this.getPressure() + ",windowHeight:" + this.windowHeight;
    }

    static {
        sPoolSize = 0;
    }
}

