/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.media;

import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.gensee.common.GenseeConfig;
import com.gensee.entity.BroadCastMsg;
import com.gensee.entity.ChatMsg;
import com.gensee.entity.DocInfo;
import com.gensee.entity.VodObject;
import com.gensee.entity.VodParam;
import com.gensee.entity.VodPlayParam;
import com.gensee.media.AbsPlayer;
import com.gensee.media.IOLPlayerCallback;
import com.gensee.media.PlaySpeed;
import com.gensee.net.AbsHttpAction;
import com.gensee.net.StringRes;
import com.gensee.parse.VodBroadCastParse;
import com.gensee.parse.VodChatParse;
import com.gensee.taskret.IGSTask;
import com.gensee.taskret.OnTaskRet;
import com.gensee.utils.DateUtil;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.StringUtil;
import com.gensee.view.GSVideoView;
import com.gensee.vod.VodMr;
import com.gensee.vod.VodSite;
import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class GSOLPlayer
extends AbsPlayer
implements IOLPlayerCallback {
    private static final String TAG = "GSOLPlayer";
    public static final String CATCH_DEF_DIR = Environment.getExternalStorageDirectory().getAbsolutePath() + "/GSVod/online/catch/";
    private final byte S_PLAY = 1;
    private final byte S_PAUSE = (byte)2;
    private volatile Boolean isPreloadMode = false;
    private long nativePlayer;
    private OnOLPlayListener mListener;
    private String filePath;
    private boolean isVideoStart = false;
    private boolean isAudioStart = false;
    private byte status = 0;
    private int lastTms = -1;
    private PlaySpeed playSpeed = PlaySpeed.SPEED_NORMAL;
    private int layout = -1;
    protected Buffer videoByteBuffer;
    protected Buffer audioByteBuffer;
    private boolean onFirstFrameComplete = false;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private VodObject currentVodObject;
    private boolean isMute = false;
    private long time = 0L;
    private AbsHttpAction absHttpAction = new AbsHttpAction(null);

    public GSOLPlayer() {
        GenseeLog.i((String)TAG, (String)"GSOLPlayer non-parameter constructor ");
    }

    private GSOLPlayer(long nativePlayer) {
        this.nativePlayer = nativePlayer;
        GenseeLog.i((String)TAG, (String)("GSOLPlayer player constructor :" + nativePlayer));
    }

    public GSOLPlayer(String filePath, OnOLPlayListener listener) {
        this();
        this.filePath = filePath;
        this.mListener = listener;
    }

    public boolean playOffline(String filePath, OnOLPlayListener listener) {
        return this.play(filePath, listener, "", "", "", false);
    }

    public boolean playOnline(VodPlayParam playParam, OnOLPlayListener listener, String cachDir, boolean isAudioOnly, boolean isFlv) {
        if (playParam instanceof VodParam) {
            VodParam param = (VodParam)playParam;
            String path = param.getXmlUrl();
            String vodId = param.getVodId();
            String tid = param.getTid();
            String reportUrl = param.getVodUserReportUrl();
            if (path == null || vodId == null || tid == null) {
                GenseeLog.w((String)("path = " + path + ",vodId = " + vodId + ",tid = " + tid));
                return false;
            }
            long siteId = StringUtil.longValue((String)param.getSiteId());
            long userId = StringUtil.longValue((String)param.getUserId());
            String alb = StringUtil.getHttpAlbAddr((String)param.getConnectSvr(), (String)param.getAlbPort());
            String clientApiUrl = VodMr.getClientApiUrl((VodObject)playParam);
            return this.play(siteId, userId, param.getNickName(), param.getInitParam().getUserData(), alb, path, listener, vodId, tid, cachDir, clientApiUrl, param.getHostId(), isAudioOnly, param.getCdnList(), reportUrl, isFlv);
        }
        return false;
    }

    public boolean play(String vodIdOrLocaPath, OnOLPlayListener listener, String cacheDir, boolean isAudioOnly) {
        GenseeLog.d((String)TAG, (String)("play vodIdOrLocaPath = " + vodIdOrLocaPath + " isAudioOnly = " + isAudioOnly));
        if (vodIdOrLocaPath == null || "".equals(vodIdOrLocaPath)) {
            if (listener != null) {
                listener.onError(6);
            }
            return false;
        }
        if (!vodIdOrLocaPath.endsWith(".xml")) {
            VodObject object = VodMr.getIns().getVodObjById(vodIdOrLocaPath);
            if (object != null) {
                boolean ret = this.playOnline((VodPlayParam)object, listener, cacheDir, isAudioOnly, GenseeConfig.isForceFlv);
                this.currentVodObject = object;
                return ret;
            }
            if (listener != null) {
                GenseeLog.e((String)TAG, (String)"play onError  ERR_UN_INVOKE_GETOBJECT");
                listener.onError(-201);
            }
            return false;
        }
        this.play(vodIdOrLocaPath, listener, "", "", "", isAudioOnly);
        return true;
    }

    public boolean prepare(String vodIdOrLocaPath, OnOLPlayListener listener, String cacheDir, boolean isAudioOnly) {
        GenseeLog.d((String)TAG, (String)("prepare vodId: " + vodIdOrLocaPath + " cacheDir: " + cacheDir + " isAudioOnly: " + isAudioOnly));
        this.time = System.currentTimeMillis();
        this.isPreloadMode = true;
        boolean play = this.play(vodIdOrLocaPath, listener, cacheDir, isAudioOnly);
        return play;
    }

    protected void onAudioTrackCreated() {
        super.onAudioTrackCreated();
        if (this.isPreloadMode.booleanValue()) {
            GenseeLog.d((String)TAG, (String)"in preload mode,pause audio");
            this.audioPause();
        }
    }

    public void mute() {
        GenseeLog.d((String)TAG, (String)"mute audio");
        this.audioPause();
        if (this.mTrack != null && this.mTrack.getState() != 3) {
            this.isMute = true;
        }
    }

    public void unMute() {
        GenseeLog.d((String)TAG, (String)"unMute audio");
        super.audioResume();
        if (this.mTrack != null && this.mTrack.getState() == 3) {
            this.isMute = false;
        }
    }

    public boolean getMuteStatus() {
        return this.isMute;
    }

    private boolean isPlay() {
        return (this.status & 1) == 1;
    }

    private boolean isPause() {
        return (this.status & 2) == 2;
    }

    public boolean play(String filePath, OnOLPlayListener listener, String vodId, String tid, String cachDir, boolean isAudioOnly) {
        return this.play(0L, 0L, "", "", "", filePath, listener, vodId, tid, cachDir, "", 0L, isAudioOnly, "", "", false);
    }

    private boolean play(final long siteId, final long userId, final String nickName, final String userData, final String albAddr, final String filePath, OnOLPlayListener listener, final String vodId, final String tid, final String cachDir, final String clientApi, final long hostId, final boolean isAudioOnly, final String cdnList, final String reportUrl, final boolean isFlv) {
        this.mListener = listener;
        this.isVideoStart = false;
        this.isAudioStart = false;
        this.filePath = filePath;
        this.lastTms = -1;
        return GSOLPlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                String strDir = null;
                if (this.isValidDir(cachDir)) {
                    strDir = cachDir;
                } else if (this.isValidDir(VodMr.getIns().getCachDir())) {
                    strDir = VodMr.getIns().getCachDir();
                } else {
                    strDir = CATCH_DEF_DIR;
                    File fCachDir = new File(strDir);
                    if (!fCachDir.exists()) {
                        boolean dirRet = fCachDir.mkdirs();
                        GenseeLog.d((String)GSOLPlayer.TAG, (String)("dir makes dirRet = " + dirRet));
                    }
                }
                if (0L == GSOLPlayer.this.nativePlayer) {
                    GenseeLog.d((String)GSOLPlayer.TAG, (String)("play player is 0,and will create, catch dir is " + strDir + " c-a-u = " + clientApi));
                    GenseeLog.d((String)GSOLPlayer.TAG, (String)("GenseeConfig.isMultiPlayer = " + GenseeConfig.isMultiPlayer));
                    GSOLPlayer.this.nativePlayer = GSOLPlayer.this.createOnlinePlayer(siteId, userId, nickName, albAddr, strDir, clientApi, reportUrl, GenseeConfig.isMultiPlayer, userData);
                }
                GenseeLog.d((String)GSOLPlayer.TAG, (String)("play player is  create " + GSOLPlayer.this.nativePlayer));
                Log.i((String)GSOLPlayer.TAG, (String)("startPlayer: " + Thread.currentThread()));
                GSOLPlayer.this.startPlayer(GSOLPlayer.this.nativePlayer, filePath, vodId, tid, hostId, isAudioOnly, cdnList, isFlv, GenseeConfig.vodCacheCount);
                return 0;
            }

            private boolean isValidDir(String path) {
                if (path == null || "".equals(path)) {
                    return false;
                }
                File f = new File(path);
                if (f.exists()) {
                    return true;
                }
                if (f.mkdirs()) {
                    return f.isDirectory();
                }
                return false;
            }
        });
    }

    private void startPlayer(long player, String filePath, String vodId, String tId, long hostId, boolean isAudioOnly, String cdnList, boolean isFlv, int cacheNum) {
        int ret = -1;
        if (player != 0L) {
            this.initAudioPlayer();
            GenseeLog.d((String)TAG, (String)("startPlayer filePath = " + filePath + " vodId = " + vodId + " tId =  " + tId + " hostId = " + hostId + " list = " + cdnList));
            ret = this.nativePlay(player, filePath == null ? "" : filePath, this, false, vodId == null ? "" : vodId, tId == null ? "" : tId, hostId, isAudioOnly, cdnList == null ? "" : cdnList, isFlv, cacheNum);
            if (ret == 0) {
                this.status = (byte)(this.status | 1);
            }
        } else {
            GenseeLog.w((String)"GSOLPlayer -> startPlayer player is 0");
        }
        if (0 != ret && null != this.mListener) {
            GenseeLog.e((String)"GSOLPlayer onError -> startPlayer player is 0");
            this.mListener.onError(1);
        }
    }

    public boolean pause() {
        GenseeLog.d((String)TAG, (String)("pause nativePlayer = " + this.nativePlayer));
        this.time = System.currentTimeMillis();
        return GSOLPlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                GenseeLog.d((String)GSOLPlayer.TAG, (String)("-\u6682\u505c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - GSOLPlayer.this.time)));
                long player = GSOLPlayer.this.nativePlayer;
                int ret = -1;
                GSOLPlayer.this.audioPause();
                if (player != 0L) {
                    ret = GSOLPlayer.this.nativePause(player);
                    GenseeLog.d((String)GSOLPlayer.TAG, (String)"pause nativePause()");
                }
                if (GSOLPlayer.this.mListener != null) {
                    if (0 != ret) {
                        GenseeLog.e((String)GSOLPlayer.TAG, (String)("pause error: " + ret));
                        GSOLPlayer.this.mListener.onError(2);
                    } else {
                        GSOLPlayer.this.status = (byte)(GSOLPlayer.this.status | 2);
                        GSOLPlayer.this.mListener.onPlayPause();
                    }
                }
                return 0;
            }
        });
    }

    public boolean resume() {
        GenseeLog.d((String)TAG, (String)"resume player");
        if (this.isPreloadMode.booleanValue() && !this.onFirstFrameComplete) {
            GenseeLog.d((String)TAG, (String)"first frame not ready,but resume func is called");
            this.isPreloadMode = false;
            this.audioResume();
            return true;
        }
        return GSOLPlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                int ret = -1;
                long player = GSOLPlayer.this.nativePlayer;
                GSOLPlayer.this.audioResume();
                if (player != 0L) {
                    ret = GSOLPlayer.this.nativeResume(player);
                    GenseeLog.d((String)GSOLPlayer.TAG, (String)"resume nativeResume");
                }
                if (GSOLPlayer.this.mListener != null) {
                    if (0 != ret) {
                        GenseeLog.e((String)GSOLPlayer.TAG, (String)("resume error: " + ret));
                        GSOLPlayer.this.mListener.onError(3);
                    } else {
                        GSOLPlayer.this.status = (byte)(GSOLPlayer.this.status | 1);
                        GSOLPlayer.this.mListener.onPlayResume();
                    }
                }
                return 0;
            }
        });
    }

    public boolean stop() {
        this.audioStop();
        GenseeLog.d((String)TAG, (String)"call stop");
        return GSOLPlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                int ret = -1;
                long player = GSOLPlayer.this.nativePlayer;
                if (player != 0L) {
                    ret = GSOLPlayer.this.nativeStop(player);
                    GenseeLog.d((String)GSOLPlayer.TAG, (String)("stop ret = " + ret));
                }
                GSOLPlayer.this.isVideoStart = false;
                GSOLPlayer.this.status = (byte)0;
                GSOLPlayer.this.playSpeed = PlaySpeed.SPEED_NORMAL;
                GSOLPlayer.this.layout = -1;
                if (null != GSOLPlayer.this.mListener && 0 != ret) {
                    GenseeLog.e((String)GSOLPlayer.TAG, (String)"stop error");
                    GSOLPlayer.this.mListener.onError(4);
                }
                return 0;
            }
        });
    }

    public boolean seekTo(final int position) {
        GenseeLog.d((String)TAG, (String)("seekTo position = " + position));
        return GSOLPlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                GSOLPlayer.this.audioQueueClear();
                if (!GSOLPlayer.this.isPreloadMode.booleanValue()) {
                    GSOLPlayer.this.audioResume();
                } else {
                    GenseeLog.e((String)GSOLPlayer.TAG, (String)"is not time to resume audio");
                }
                long player = GSOLPlayer.this.nativePlayer;
                int ret = -1;
                if (player != 0L) {
                    ret = GSOLPlayer.this.seek(player, position);
                    GenseeLog.d((String)GSOLPlayer.TAG, (String)("seekTo position = " + position + " ret = " + ret));
                    if (ret == 0) {
                        GSOLPlayer.this.audioAndAppResume();
                        GSOLPlayer.this.lastTms = position / 1000;
                    } else if (null != GSOLPlayer.this.mListener) {
                        GSOLPlayer.this.mListener.onError(5);
                    }
                } else {
                    GenseeLog.w((String)GSOLPlayer.TAG, (String)("player is 0 seekTo position = " + position));
                }
                return 0;
            }
        });
    }

    public boolean setSpeed(final PlaySpeed speed, final OnTaskRet ret) {
        GenseeLog.w((String)TAG, (String)("setSpeed speed = " + (Object)((Object)speed)));
        if (speed == null) {
            return false;
        }
        this.playSpeed = speed;
        if (this.nativePlayer == 0L) {
            GenseeLog.w((String)TAG, (String)"setSpeed player un init");
            return true;
        }
        return GSOLPlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                GSOLPlayer.this.audioQueueClear();
                int result = -1;
                if (GSOLPlayer.this.nativePlayer != 0L) {
                    result = GSOLPlayer.this.setSpeed(GSOLPlayer.this.nativePlayer, speed.getValue());
                }
                if (ret != null) {
                    ret.onTaskRet(result == 0, 0, "setSpeed");
                }
                return 0;
            }
        });
    }

    public boolean videoSet(final boolean isClose, final OnTaskRet taskRet) {
        if (this.nativePlayer == 0L) {
            GenseeLog.w((String)TAG, (String)"videoSet nativePlayer = 0");
            return false;
        }
        return GSOLPlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                int ret = -1;
                if (GSOLPlayer.this.nativePlayer != 0L) {
                    ret = GSOLPlayer.this.closeVideo(GSOLPlayer.this.nativePlayer, isClose);
                }
                if (taskRet != null) {
                    taskRet.onTaskRet(ret == 0, 0, "videoSet");
                }
                return 0;
            }
        });
    }

    public boolean release() {
        GenseeLog.d((String)TAG, (String)"release start");
        this.audioRelease();
        this.mListener = null;
        this.mHandler.removeCallbacksAndMessages(null);
        return GSOLPlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                long player = GSOLPlayer.this.nativePlayer;
                if (player != 0L) {
                    GenseeLog.d((String)GSOLPlayer.TAG, (String)"release...");
                    if (GSOLPlayer.this.destroyOfflinePlayer(player) == 0) {
                        GSOLPlayer.this.nativePlayer = 0L;
                        GenseeLog.d((String)GSOLPlayer.TAG, (String)"release end");
                    }
                }
                VodMr.getIns().removeVodObj(GSOLPlayer.this.currentVodObject);
                GSOLPlayer.this.playSpeed = PlaySpeed.SPEED_NORMAL;
                GSOLPlayer.this.isVideoStart = false;
                GSOLPlayer.this.isAudioStart = false;
                GSOLPlayer.this.status = (byte)0;
                GSOLPlayer.this.layout = -1;
                GSOLPlayer.this.shutdownTreadPool();
                GSOLPlayer.super.release();
                GSOLPlayer.this.videoByteBuffer = null;
                GSOLPlayer.this.audioByteBuffer = null;
                return 0;
            }
        });
    }

    @Override
    public void onInit(int result, boolean haveVideo, int duration, DocInfo[] docs, int num, boolean isDocbySwf) {
        GenseeLog.d((String)TAG, (String)("onInit result = " + result + " hasVideo = " + haveVideo + " duration = " + duration + " docs = " + docs + " isDocbySwf = " + isDocbySwf));
        this.sleep("onInit");
        if (result == 0 && this.nativePlayer != 0L) {
            this.setSpeed(this.nativePlayer, this.playSpeed.getValue());
        } else {
            this.playSpeed = PlaySpeed.SPEED_NORMAL;
        }
        if (this.mListener != null) {
            if (result == 0) {
                this.mListener.onInit(result, haveVideo, duration, null == docs ? null : Arrays.asList(docs));
            } else {
                this.mListener.onError(result);
            }
        }
        if (null != this.mVideoView && this.mVideoView instanceof GSVideoView) {
            this.mVideoView.renderDefault();
        }
    }

    @Override
    public void onVideoBegin() {
        GenseeLog.d((String)TAG, (String)"onVideoBegin");
        if (this.mListener != null) {
            this.mListener.onVideoStart();
        }
    }

    @Override
    public void onVideoEnd() {
        GenseeLog.d((String)TAG, (String)"onVideoEnd");
        if (this.mListener != null) {
            this.mListener.onVideoEnd();
        }
    }

    @Override
    public void onFirstFrameNfy() {
        this.onFirstFrameComplete = true;
        GenseeLog.d((String)TAG, (String)"onFirstFrameNfy");
        GenseeLog.d((String)TAG, (String)("\u9996\u5e27\u8017\u65f6\uff1a" + (System.currentTimeMillis() - this.time)));
        if (this.mListener != null) {
            this.mListener.onFirstFrameNfy();
        }
        if (this.isPreloadMode.booleanValue()) {
            this.pause();
            this.isPreloadMode = false;
        }
    }

    @Override
    public Object initAudioDirectBuff(int size) {
        if (null == this.audioByteBuffer) {
            this.audioByteBuffer = ByteBuffer.allocateDirect(size);
            GenseeLog.d((String)TAG, (String)("initAudioDirectBuff buffer size = " + size));
        }
        if (this.audioByteBuffer.capacity() >= size) {
            this.audioByteBuffer.limit(size);
        } else {
            this.audioByteBuffer = ByteBuffer.allocateDirect(size);
        }
        this.audioByteBuffer.position(0);
        return this.audioByteBuffer;
    }

    @Override
    public void onReportDataTracking(String reportURL, String data) {
        GenseeLog.i((String)TAG, (String)("start report,reportURL: " + reportURL + " data: " + data));
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        this.absHttpAction.doPostRequest(reportURL, data, header, new StringRes(){

            public void onRes(String result) {
                GenseeLog.i((String)GSOLPlayer.TAG, (String)"report success ");
            }

            public void onConnectError(int errorType, String errorInfo) {
                GenseeLog.e((String)GSOLPlayer.TAG, (String)("report error :" + errorInfo));
            }
        });
    }

    @Override
    public void onAudio(final int dwTimeStamp, byte[] data, int dwLen, final short nLevel) {
        this.audioDataPlay((ByteBuffer)this.audioByteBuffer, dwLen);
        if (!this.isAudioStart) {
            this.isAudioStart = true;
            GenseeLog.d((String)TAG, (String)("onAudio first frame time = " + (System.currentTimeMillis() - VodSite.startTime)));
        }
        this.postPool(new Runnable(){

            @Override
            public void run() {
                if (GSOLPlayer.this.mListener != null) {
                    GSOLPlayer.this.mListener.onAudioLevel(nLevel);
                }
                GSOLPlayer.this.postionNotify(dwTimeStamp);
            }
        });
    }

    private void postionNotify(int dwTimeStamp) {
        int tmpTs = dwTimeStamp / 1000;
        if (this.lastTms != tmpTs) {
            int dlta = this.lastTms * 1000 - dwTimeStamp;
            if (dlta > 0 && dlta < 1000) {
                return;
            }
            this.lastTms = tmpTs;
            if (this.mListener != null) {
                this.mListener.onPosition(dwTimeStamp);
            }
        }
    }

    @Override
    public Object initDirectBuffCache(int size) {
        if (null == this.videoByteBuffer) {
            this.videoByteBuffer = ByteBuffer.allocateDirect(size);
            GenseeLog.d((String)TAG, (String)("initDirectBuffCache buffer size = " + size));
        }
        if (this.videoByteBuffer.capacity() >= size) {
            this.videoByteBuffer.limit(size);
        } else {
            this.videoByteBuffer = ByteBuffer.allocateDirect(size);
        }
        this.videoByteBuffer.position(0);
        return this.videoByteBuffer;
    }

    @Override
    public void onVideo(final int dwTimeStamp, byte[] data, int dwLen) {
        if (!this.isVideoStart) {
            GenseeLog.d((String)TAG, (String)("onVideo first frame time = " + (System.currentTimeMillis() - VodSite.startTime)));
            this.isVideoStart = true;
        }
        this.postPool(new Runnable(){

            @Override
            public void run() {
                GSOLPlayer.this.postionNotify(dwTimeStamp);
            }
        });
        this.renderVideo((ByteBuffer)this.videoByteBuffer);
    }

    @Override
    public void onVideoParam(int dwTimeStamp, int dwWidth, int dwHeight, boolean isReal) {
        GenseeLog.d((String)TAG, (String)("onVideoParam dwTimeStamp = " + dwTimeStamp + " dwHeight = " + dwHeight + " dwWidth = " + dwWidth + " real = " + isReal));
        this.sleep("onVideoParam");
        this.setVideoSize(dwWidth, dwHeight, isReal);
        if (!isReal && this.mListener != null) {
            this.mListener.onVideoSize(dwTimeStamp, dwWidth, dwHeight);
        }
    }

    @Override
    public void onPage(int dwTimeStamp, byte[] data, int dwLen, int dwPageW, int dwPageH) {
        GenseeLog.d((String)TAG, (String)("onPage dwTimeStamp = " + dwTimeStamp + " dwLen = " + dwLen + " dwPageW = " + dwPageW + " dwPageH = " + dwPageH));
        this.sleep("onPage");
        if (this.mListener != null) {
            this.mListener.onPageSize(dwTimeStamp, dwPageW, dwPageH);
        }
        this.renderPage(data, dwLen, dwPageW, dwPageH);
    }

    @Override
    public void onPage(int dwTimeStamp, byte[] data, int dwLen, int dwPageW, int dwPageH, String sAnimationXml) {
        GenseeLog.d((String)TAG, (String)("onPage swf dwTimeStamp = " + dwTimeStamp + " dwLen = " + dwLen + " dwPageW = " + dwPageW + " dwPageH = " + dwPageH));
        this.sleep("onPage swf");
        if (this.mListener != null) {
            this.mListener.onPageSize(dwTimeStamp, dwPageW, dwPageH);
        }
        this.renderPage(data, dwLen, dwPageW, dwPageH, sAnimationXml);
    }

    @Override
    public void onAnimation(int nStep) {
        this.sleep("onAnimation");
        this.renderPageAnimation(nStep);
    }

    @Override
    public void onAnnotaion(int dwTimeStamp, final String strAnnoXML) {
        this.sleep("onAnnotaion");
        this.postPool(new Runnable(){

            @Override
            public void run() {
                GSOLPlayer.this.renderAnno(strAnnoXML);
            }
        });
    }

    @Override
    public void onSeek(final int dwTimeStamp) {
        GenseeLog.d((String)TAG, (String)("onSeek dwTimeStamp = " + dwTimeStamp));
        this.sleep("onSeek");
        this.postPool(new Runnable(){

            @Override
            public void run() {
                if (GSOLPlayer.this.mListener != null) {
                    GSOLPlayer.this.mListener.onSeek(dwTimeStamp);
                }
            }
        });
    }

    @Override
    public void onStop() {
        GenseeLog.d((String)TAG, (String)"onStop ");
        this.status = 0;
        this.layout = -1;
        this.onFirstFrameComplete = false;
        this.isPreloadMode = false;
        this.playSpeed = PlaySpeed.SPEED_NORMAL;
        this.audioStop();
        if (this.mListener != null) {
            this.mListener.onPlayStop();
        }
    }

    @Override
    public void onBuffer(final boolean isCaching) {
        GenseeLog.d((String)TAG, (String)("onBuffer isCaching = " + isCaching));
        this.sleep("onBuffer");
        this.postPool(new Runnable(){

            @Override
            public void run() {
                if (GSOLPlayer.this.mListener != null) {
                    GSOLPlayer.this.mListener.onCaching(isCaching);
                }
            }
        });
    }

    private void audioAndAppResume() {
        if (this.mListener != null) {
            this.mListener.onPlayResume();
        }
    }

    protected void audioResume() {
        if (!this.isMute) {
            super.audioResume();
        }
    }

    @Override
    public void onChat(final String chatXml) {
        this.sleep("onChat");
        this.postPool(new Runnable(){

            @Override
            public void run() {
                OnOLPlayListener l = GSOLPlayer.this.mListener;
                if (l != null) {
                    ChatMsg msg;
                    VodChatParse p = new VodChatParse();
                    p.parse(chatXml);
                    String type = p.getXmlType();
                    if ("chat".equals(type)) {
                        l.onChat(p.getChatMsgs());
                    } else if ("chatcensor".equals(type) && (msg = p.getCensor()) != null) {
                        l.onChatCensor(msg.getCensorType(), msg.getId());
                    }
                }
            }
        });
    }

    @Override
    public void onDocIndex(final DocInfo[] docs, int num) {
        this.sleep("onDocIndex");
        this.postPool(new Runnable(){

            @Override
            public void run() {
                if (GSOLPlayer.this.mListener != null) {
                    GSOLPlayer.this.mListener.onDocInfo(null == docs ? null : Arrays.asList(docs));
                }
            }
        });
    }

    @Override
    public void onBroadCastMsg(final String broadCastXml) {
        this.sleep("onBroadCastMsg");
        this.postPool(new Runnable(){

            @Override
            public void run() {
                OnOLPlayListener l = GSOLPlayer.this.mListener;
                if (l != null) {
                    VodBroadCastParse p = new VodBroadCastParse();
                    p.parseXml(broadCastXml);
                    l.onBroadCastMsg(p.getMsgs());
                }
            }
        });
    }

    @Override
    public void onLayoutSet(final int timestamp, final int layout) {
        this.sleep("onLayoutSet");
        if (this.layout == layout) {
            GenseeLog.w((String)TAG, (String)("onLayoutSet not change layout = " + layout));
            return;
        }
        GenseeLog.w((String)TAG, (String)("onLayoutSet layout old = " + this.layout + " new = " + layout));
        this.layout = layout;
        this.postPool(new Runnable(){

            @Override
            public void run() {
                OnOLPlayListener l = GSOLPlayer.this.mListener;
                if (l != null) {
                    l.onLayoutSet(timestamp, layout);
                }
            }
        });
    }

    protected int onGetAudioQueueLen() {
        int nQueueLen = this.getAudioQueueLen();
        return nQueueLen;
    }

    private void sleep(String method) {
    }

    protected boolean checkAnno() {
        return true;
    }

    protected void onRecordInfo(final String startTime, final String storage, final String duration) {
        GenseeLog.d((String)TAG, (String)("onRecordInfo startTime = " + startTime + " storage = " + storage + " duration = " + duration));
        if (this.isPreloadMode.booleanValue()) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (!GSOLPlayer.this.onFirstFrameComplete && GSOLPlayer.this.isPreloadMode.booleanValue() && GSOLPlayer.this.isPlay()) {
                        GenseeLog.d((String)GSOLPlayer.TAG, (String)"1000ms \u540e\u9996\u5e27\u8fd8\u672a\u5b8c\u6210\uff0c\u8fdb\u5165\u6b63\u5e38\u6682\u505c\u6a21\u5f0f");
                        GSOLPlayer.this.isPreloadMode = false;
                        GSOLPlayer.this.pause();
                    }
                }
            }, 1000L);
        }
        this.postPool(new Runnable(){

            @Override
            public void run() {
                OnOLPlayListener l = GSOLPlayer.this.mListener;
                if (l != null) {
                    float fduration = 0.0f;
                    try {
                        fduration = duration == null ? 0.0f : Float.valueOf(duration).floatValue();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        GenseeLog.e((String)e.getMessage());
                    }
                    l.onRecordInfo(DateUtil.utcTimeToLocal((String)startTime), StringUtil.longValue((String)storage), (long)(fduration * 1000.0f));
                }
            }
        });
    }

    private native long createOfflinePlayer();

    private native long createOnlinePlayer(long var1, long var3, String var5, String var6, String var7, String var8, String var9, boolean var10, String var11);

    private native int destroyOfflinePlayer(long var1);

    private native int nativePlay(long var1, String var3, IOLPlayerCallback var4, boolean var5, String var6, String var7, long var8, boolean var10, String var11, boolean var12, int var13);

    private native int nativePause(long var1);

    private native int nativeResume(long var1);

    private native int nativeStop(long var1);

    private native int seek(long var1, int var3);

    private native int setSpeed(long var1, int var3);

    private native int closeVideo(long var1, boolean var3);

    public static interface OnOLPlayListener {
        public static final String CHATCENSOR_MSG = "msg";
        public static final String CHATCENSOR_USER = "user";
        public static final int RESULT_OK = 0;
        public static final int RESULT_LICENSE = 12;
        public static final int RESULT_LOCAL_FILE_UNCOMPLETE = 10015;
        public static final int ERR_PLAY = 1;
        public static final int ERR_PAUSE = 2;
        public static final int ERR_RESUME = 3;
        public static final int ERR_STOP = 4;
        public static final int ERR_SEEK = 5;
        public static final int ERR_UN_INVOKE_GETOBJECT = -201;
        public static final int ERR_VODID_OR_LOCALPATH = 6;
        public static final int ERR_INIT_FAILURE = 7;
        public static final int ERR_INIT_FILE_FAILURE = 13;

        public void onInit(int var1, boolean var2, int var3, List<DocInfo> var4);

        public void onPlayStop();

        public void onPlayPause();

        public void onPlayResume();

        public void onPosition(int var1);

        public void onVideoSize(int var1, int var2, int var3);

        public void onPageSize(int var1, int var2, int var3);

        public void onSeek(int var1);

        public void onAudioLevel(int var1);

        public void onCaching(boolean var1);

        public void onVideoStart();

        public void onVideoEnd();

        public void onFirstFrameNfy();

        public void onChat(List<ChatMsg> var1);

        public void onDocInfo(List<DocInfo> var1);

        public void onChatCensor(String var1, String var2);

        public void onBroadCastMsg(List<BroadCastMsg> var1);

        public void onLayoutSet(int var1, int var2);

        public void onRecordInfo(long var1, long var3, long var5);

        public void onError(int var1);
    }
}

