/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.download;

import android.content.Context;
import android.content.SharedPreferences;
import com.gensee.common.GenseeConfig;
import com.gensee.common.PlayerWork;
import com.gensee.download.VodDownLoadCallback;
import com.gensee.download.VodDownLoadEntity;
import com.gensee.download.VodDownLoadImpl;
import com.gensee.download.VodDownLoadJni;
import com.gensee.download.VodDownLoadStatus;
import com.gensee.download.db.VodDataBaseManager;
import com.gensee.taskret.IGSTask;
import com.gensee.utils.FileUtil;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class VodDownLoadManager
extends PlayerWork
implements VodDownLoadImpl.VodDownLoadImplInterface {
    private static final String TAG = "VodDownLoadManager";
    private List<VodDownLoadEntity> vodDownLoadList;
    private ReentrantReadWriteLock lock;
    private VodDataBaseManager vodDataBaseManager;
    private VodDownLoadJni vodDownLoadJni;
    private String UUID;
    private VodDownLoadImpl vodDownLoadImpl;
    private AtomicBoolean isAutoDownloading = new AtomicBoolean(true);
    public final String DEF_SAVE_DIR;
    private VodDownLoadEntity mCurDownloadEntity;
    private String saveDir;
    private Context context;

    public boolean getIsAutoDownloading() {
        return this.isAutoDownloading.get();
    }

    public void setIsAutoDownloading(boolean isAutoDownloading) {
        this.isAutoDownloading.set(isAutoDownloading);
    }

    public VodDownLoadManager(Context context, String UUID, VodDownLoadCallback downloadCallback, String fileDir) {
        GenseeLog.i((String)("VodDownLoadManager Create UUID = " + UUID));
        this.vodDownLoadList = new ArrayList<VodDownLoadEntity>();
        this.context = context.getApplicationContext();
        this.lock = new ReentrantReadWriteLock();
        this.vodDataBaseManager = new VodDataBaseManager(context);
        this.vodDownLoadJni = new VodDownLoadJni();
        this.vodDownLoadImpl = new VodDownLoadImpl(downloadCallback, this);
        this.UUID = UUID;
        this.saveDir = fileDir;
        this.isAutoDownloading.set(true);
        this.DEF_SAVE_DIR = FileUtil.useSDCard((boolean)GenseeConfig.isTargetVerLessQ) ? FileUtil.getSDCardPath() + File.separator + "GSVod" + File.separator + "DownLoad" + File.separator : FileUtil.getFileDir((Context)context, (String)"GSVodDownLoad");
        this.getVodDownLoadList();
    }

    private void releaseDownLoadService() {
        GenseeLog.i((String)"VodDownLoadManager releaseDownLoadService");
        this.mCurDownloadEntity = null;
        VodDownLoadManager.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                VodDownLoadManager.this.vodDownLoadJni.releaseDownLoadService();
                return 0;
            }
        });
    }

    private boolean initDownLoadService(VodDownLoadEntity entity) {
        String alb;
        SharedPreferences sp = this.context.getSharedPreferences("gsol", 0);
        long siteIdSp = sp.getLong("siteId", 0L);
        long userIdSp = sp.getLong("userId", 0L);
        String userNameSp = sp.getString("userName", "");
        String albAddressSp = sp.getString("albAddress", "");
        final long siteId = entity.getSiteId() <= 0L ? siteIdSp : entity.getSiteId();
        final long userId = entity.getUserId() <= 0L ? userIdSp : entity.getUserId();
        String tmpNickName = entity.getNickName();
        final String nickName = "".equals(tmpNickName) || tmpNickName == null ? userNameSp : tmpNickName;
        String tmpSvr = entity.getConnectSvr();
        final String connectSvr = alb = StringUtil.isEmpty((String)tmpSvr) ? albAddressSp : tmpSvr;
        final String clientApiUrl = GenseeConfig.isNeedChatMsg ? entity.getsReserved3() : "";
        GenseeLog.i((String)("VodDownLoadManagerinitDownLoadService downLoadId = " + entity.getDownLoadId() + " siteId = " + siteId + " userId = " + userId + " nickName = " + nickName + " connectSvr = " + connectSvr + " clientApiUrl = " + clientApiUrl));
        return VodDownLoadManager.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                VodDownLoadManager.this.vodDownLoadJni.initDownLoadService(VodDownLoadManager.this.vodDownLoadImpl, siteId, userId, nickName == null ? "" : nickName, connectSvr == null ? "" : connectSvr, clientApiUrl == null ? "" : clientApiUrl);
                return 0;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String downLoadId) {
        GenseeLog.i((String)("VodDownLoadManager delete downLoadId = " + downLoadId));
        this.lock.writeLock().lock();
        try {
            for (VodDownLoadEntity tmp : this.vodDownLoadList) {
                if (!tmp.getDownLoadId().equals(downLoadId)) continue;
                if (tmp.isDownloading()) {
                    this._stop(downLoadId);
                }
                this.vodDownLoadList.remove(tmp);
                this.vodDataBaseManager.removeByDownLoadId(tmp.getUUID(), downLoadId);
                String downloadDir = this.getSaveDir() + this.UUID + File.separator + downLoadId + File.separator;
                this.deleteFile(new File(downloadDir));
                break;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void checkDownloadDir(String downLoadId) {
        File[] childFiles;
        boolean bTrue = true;
        String downloadDir = this.getSaveDir() + this.UUID + File.separator + downLoadId + File.separator;
        File dir = new File(downloadDir);
        if (dir.exists() && dir.isDirectory() && (childFiles = dir.listFiles()) != null && childFiles.length <= 1) {
            bTrue = false;
        }
        if (!bTrue) {
            this.deleteFile(dir);
            GenseeLog.i((String)("VodDownLoadManager checkDownloadDir deleteFile downLoadId = " + downLoadId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(List<String> downLoadIds) {
        GenseeLog.i((String)("VodDownLoadManager deletelist = " + downLoadIds.toString()));
        this.lock.writeLock().lock();
        try {
            ArrayList<VodDownLoadEntity> deleteList = new ArrayList<VodDownLoadEntity>();
            for (String downLoadId : downLoadIds) {
                for (VodDownLoadEntity tmp : this.vodDownLoadList) {
                    if (!tmp.getDownLoadId().equals(downLoadId)) continue;
                    deleteList.add(tmp);
                    if (!tmp.isDownloading()) continue;
                    this._stop(downLoadId);
                }
            }
            this.vodDownLoadList.removeAll(deleteList);
            this.vodDataBaseManager.removeByDownLoadIds(this.UUID, downLoadIds);
            for (VodDownLoadEntity tmp : deleteList) {
                String downloadDir = this.getSaveDir() + this.UUID + File.separator + tmp.getDownLoadId() + File.separator;
                this.deleteFile(new File(downloadDir));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int add(VodDownLoadEntity vodDownLoadEntity) {
        this.lock.writeLock().lock();
        vodDownLoadEntity.setUUID(this.UUID);
        int nValue = 0;
        try {
            if (null == this._getVodByDownLoadId(vodDownLoadEntity.getDownLoadId())) {
                this.vodDownLoadList.add(vodDownLoadEntity);
                this.vodDataBaseManager.insert(vodDownLoadEntity);
                GenseeLog.i((String)("VodDownLoadManager add _start = " + nValue + " downloadId = " + vodDownLoadEntity.getDownLoadId()));
                nValue = 0;
            } else {
                nValue = 1;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return nValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VodDownLoadEntity> getVodDownLoadList() {
        ArrayList<VodDownLoadEntity> returnList = new ArrayList<VodDownLoadEntity>();
        this.lock.writeLock().lock();
        try {
            if (this.vodDownLoadList.size() <= 0) {
                this.vodDownLoadList.addAll(this.vodDataBaseManager.queryByUUID(this.UUID));
            }
            for (VodDownLoadEntity downLoadEntity : this.vodDownLoadList) {
                try {
                    returnList.add((VodDownLoadEntity)downLoadEntity.clone());
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return returnList;
    }

    private VodDownLoadEntity _getVodByDownLoadId(String downLoadId) {
        VodDownLoadEntity vodDownLoadEntity = null;
        for (VodDownLoadEntity tmp : this.vodDownLoadList) {
            if (!tmp.getDownLoadId().equals(downLoadId)) continue;
            vodDownLoadEntity = tmp;
            break;
        }
        return vodDownLoadEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VodDownLoadEntity getVodByDownLoadId(String downLoadId) {
        VodDownLoadEntity vodDownLoadEntity = null;
        this.lock.readLock().lock();
        try {
            for (VodDownLoadEntity tmp : this.vodDownLoadList) {
                if (!tmp.getDownLoadId().equals(downLoadId)) continue;
                try {
                    vodDownLoadEntity = (VodDownLoadEntity)tmp.clone();
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return vodDownLoadEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVodDownLoadStopStatus(String downLoadId, int nStopStatus) {
        this.lock.writeLock().lock();
        try {
            VodDownLoadEntity entity = this._getVodByDownLoadId(downLoadId);
            if (null != entity) {
                entity.setStopStatus(nStopStatus);
                this.vodDataBaseManager.updateByDownLoadId(entity);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void _setVodDownLoadStatus(String downLoadId, int nStatus) {
        VodDownLoadEntity entity = this._getVodByDownLoadId(downLoadId);
        if (null != entity) {
            entity.setStatus(nStatus);
            this.vodDataBaseManager.updateByDownLoadId(entity);
        }
    }

    public void setVodDownLoadStatus(String downLoadId, int nStatus) {
        this.lock.writeLock().lock();
        try {
            this._setVodDownLoadStatus(downLoadId, nStatus);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VodDownLoadEntity _nextVodDownloading(boolean isAutoStart) {
        VodDownLoadEntity vodDownLoadEntity = null;
        this.lock.readLock().lock();
        try {
            boolean bStopTrue = false;
            for (VodDownLoadEntity entity : this.vodDownLoadList) {
                if ("".equals(entity.getDownLoadUrl()) || entity.getStopStatus() != 0) continue;
                int s = entity.getStatus();
                if (s == VodDownLoadStatus.STOP.getStatus()) {
                    if (bStopTrue) continue;
                    vodDownLoadEntity = entity;
                    bStopTrue = true;
                    if (isAutoStart) continue;
                } else {
                    if (s == VodDownLoadStatus.WAIT.getStatus()) {
                        if (vodDownLoadEntity != null) continue;
                        vodDownLoadEntity = entity;
                        continue;
                    }
                    if (s != VodDownLoadStatus.START.getStatus() || !isAutoStart) continue;
                    vodDownLoadEntity = entity;
                }
                break;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return vodDownLoadEntity;
    }

    public void release() {
        GenseeLog.i((String)"VodDownLoadManager release()");
        if (this.mCurDownloadEntity != null) {
            this._stop(this.mCurDownloadEntity.getDownLoadId());
            this._setVodDownLoadStatus(this.mCurDownloadEntity.getDownLoadId(), VodDownLoadStatus.STOP.getStatus());
            this.mCurDownloadEntity = null;
        }
        this.vodDownLoadList.clear();
        VodDownLoadManager.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                VodDownLoadManager.this.vodDownLoadJni.releaseDownLoadService();
                return 0;
            }
        });
    }

    private int _start(final String downLoadId) {
        boolean ret;
        final VodDownLoadEntity entity = this._getVodByDownLoadId(downLoadId);
        if (null == entity) {
            return -201;
        }
        if (null == entity.getDownLoadUrl() || "".equals(entity.getDownLoadUrl())) {
            return 6;
        }
        entity.setStopStatus(0);
        this.vodDataBaseManager.updateByDownLoadId(entity);
        if (this.mCurDownloadEntity != null) {
            return 2;
        }
        if (FileUtil.useSDCard((boolean)GenseeConfig.isTargetVerLessQ) && !FileUtil.hasSdcard()) {
            return 3;
        }
        File fsavedir = new File(this.getSaveDir());
        if (!fsavedir.exists() && !(ret = fsavedir.mkdirs())) {
            return 9;
        }
        if (!this.initDownLoadService(entity)) {
            return 8;
        }
        this.checkDownloadDir(downLoadId);
        this.mCurDownloadEntity = entity;
        VodDownLoadManager.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                String downloadDir = VodDownLoadManager.this.getSaveDir() + VodDownLoadManager.this.UUID + File.separator + downLoadId + File.separator;
                File fileDir = new File(downloadDir);
                if (!fileDir.exists()) {
                    fileDir.mkdirs();
                }
                String fileRecordXml = downloadDir + "record.xml";
                VodDownLoadManager.this.vodDownLoadJni.download(entity.getDownLoadUrl(), fileRecordXml, downLoadId);
                return 0;
            }
        });
        if (null != this.vodDownLoadImpl) {
            this._setVodDownLoadStatus(downLoadId, VodDownLoadStatus.BEGIN.getStatus());
        }
        return 0;
    }

    public int start(String downLoadId) {
        int nValue = 0;
        this.lock.readLock().lock();
        try {
            nValue = this._start(downLoadId);
            GenseeLog.i((String)("VodDownLoadManager start _start = " + nValue + " downloadId = " + downLoadId));
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (0 == nValue && null != this.vodDownLoadImpl) {
            this.vodDownLoadImpl.onBegin(downLoadId);
        }
        return nValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVdUrl(String downloadId, String downdUrl) {
        this.lock.writeLock().lock();
        try {
            VodDownLoadEntity vodDownLoadEntity = null;
            for (VodDownLoadEntity tmp : this.vodDownLoadList) {
                if (!tmp.getDownLoadId().equals(downloadId)) continue;
                vodDownLoadEntity = tmp;
                break;
            }
            if (null != vodDownLoadEntity) {
                vodDownLoadEntity.setDownLoadUrl(downdUrl);
                this.vodDataBaseManager.updateByDownLoadId(vodDownLoadEntity);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void stop(String downLoadId) {
        this.lock.readLock().lock();
        try {
            this._stop(downLoadId);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void _stop(final String downLoadId) {
        if (this.mCurDownloadEntity != null && null != downLoadId && downLoadId.equals(this.mCurDownloadEntity.getDownLoadId())) {
            GenseeLog.i((String)("VodDownLoadManager stopDownLoading = " + downLoadId));
            VodDownLoadManager.addTask((IGSTask)new IGSTask(){

                public int doTask() {
                    VodDownLoadManager.this.vodDownLoadJni.stopDownLoading(downLoadId);
                    if (null != VodDownLoadManager.this.vodDownLoadImpl) {
                        VodDownLoadManager.this.vodDownLoadImpl.onStop(downLoadId, VodDownLoadStatus.STOP.getStatus());
                    }
                    return 0;
                }
            });
        } else {
            GenseeLog.i((String)("not current downloading VodDownLoadManager stopDownLoading = " + downLoadId));
        }
    }

    @Override
    public void nextVodDownloading() {
        if (!this.isAutoDownloading.get()) {
            return;
        }
        VodDownLoadEntity entity = this._nextVodDownloading(false);
        if (null != entity) {
            GenseeLog.i((String)("VodDownLoadManager nextVodDownloading downloadId = " + entity.getDownLoadId()));
            this.start(entity.getDownLoadId());
        }
    }

    public void autoStart() {
        VodDownLoadEntity entity;
        if (this.mCurDownloadEntity == null && null != (entity = this._nextVodDownloading(true))) {
            this.start(entity.getDownLoadId());
        }
    }

    @Override
    public void updateVodDownLoadStatus(String downLoadId, int downLoadStatus) {
        this.setVodDownLoadStatus(downLoadId, downLoadStatus);
    }

    @Override
    public void updateVodDownLoadStopStatus(String downLoadId, int nStopStatus) {
        this.setVodDownLoadStopStatus(downLoadId, nStopStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateVodDownLoadProgress(String downLoadId, int nPercent) {
        this.lock.writeLock().lock();
        try {
            VodDownLoadEntity entity = this._getVodByDownLoadId(downLoadId);
            if (null != entity) {
                entity.setPercent(nPercent);
                this.vodDataBaseManager.updateByDownLoadId(entity);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public VodDownLoadEntity getCurrentDownloadingEntity() {
        return this.mCurDownloadEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDownloadingByDlId(String downLoadId) {
        boolean bTrue = false;
        this.lock.readLock().lock();
        try {
            VodDownLoadEntity entity = this._getVodByDownLoadId(downLoadId);
            bTrue = entity == null ? false : entity.isDownloading();
        }
        finally {
            this.lock.readLock().unlock();
        }
        return bTrue;
    }

    private boolean _isDownloadingTask() {
        boolean bTrue = false;
        for (VodDownLoadEntity entity : this.vodDownLoadList) {
            if (!entity.isDownloading()) continue;
            bTrue = true;
            break;
        }
        return bTrue;
    }

    public boolean isDownloadingTask() {
        this.lock.readLock().lock();
        try {
            boolean bl = this._isDownloadingTask();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void deleteFile(File file) {
        if (file.isFile()) {
            file.delete();
            return;
        }
        if (file.isDirectory()) {
            File[] childFiles = file.listFiles();
            if (childFiles == null || childFiles.length == 0) {
                file.delete();
                return;
            }
            for (int i = 0; i < childFiles.length; ++i) {
                this.deleteFile(childFiles[i]);
            }
            file.delete();
        }
    }

    @Override
    public void stopDownLoading(final String downLoadId) {
        GenseeLog.i((String)("VodDownLoadManager stopDownLoading downLoadId = " + downLoadId));
        VodDownLoadManager.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                VodDownLoadManager.this.vodDownLoadJni.stopDownLoading(downLoadId);
                return 0;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getVodDownLoadStatusByDlId(String downLoadId) {
        int nStatus = VodDownLoadStatus.WAIT.getStatus();
        this.lock.readLock().lock();
        try {
            VodDownLoadEntity entity = this._getVodByDownLoadId(downLoadId);
            if (null != entity) {
                nStatus = entity.getnStatus();
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return nStatus;
    }

    public String getPlayUrl(String downLoadId) {
        return this.getSaveDir() + this.UUID + File.separator + downLoadId + File.separator + "record.xml";
    }

    public String getSaveDir() {
        return this.saveDir == null || "".equals(this.saveDir) ? this.DEF_SAVE_DIR : this.saveDir;
    }

    @Override
    public void releaseDownloading() {
        this.releaseDownLoadService();
    }

    @Override
    public void onRecordInfo(String downloadId, long startTime, long storage, long duration) {
        GenseeLog.d((String)TAG, (String)("onRecordInfo startTime = " + startTime + " storage = " + storage + " duration = " + duration));
    }
}

