/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.download;

import android.content.Context;
import com.gensee.common.PlayerWork;
import com.gensee.download.VodDownLoadCallback;
import com.gensee.download.VodDownLoadEntity;
import com.gensee.download.VodDownLoadManager;
import com.gensee.entity.VodObject;
import com.gensee.entity.VodParam;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.StringUtil;
import com.gensee.vod.VodMr;
import java.util.List;

public class VodDownLoad
extends PlayerWork {
    private static VodDownLoad vodDownLoad = null;
    private VodDownLoadManager vodDownLoadManager;

    private VodDownLoad(Context context, String UUID, VodDownLoadCallback downloadCallback, String fileDir) {
        this.vodDownLoadManager = new VodDownLoadManager(context.getApplicationContext(), UUID, downloadCallback, fileDir);
    }

    public void setAutoDownloadNext(boolean isAuto) {
        this.vodDownLoadManager.setIsAutoDownloading(isAuto);
    }

    public boolean isAutoDownloading() {
        return this.vodDownLoadManager.getIsAutoDownloading();
    }

    public static VodDownLoad initVodDownLoad(Context context, VodDownLoadCallback downloadCallback, String fileDir) {
        return VodDownLoad.initVodDownLoad(context, "0", downloadCallback, fileDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VodDownLoad initVodDownLoad(Context context, String UUID, VodDownLoadCallback downloadListener, String fileDir) {
        VodMr.getIns().initCachDir(context);
        VodDownLoad.startHeartbeat((boolean)true, (Context)context);
        Class<VodDownLoad> clazz = VodDownLoad.class;
        synchronized (VodDownLoad.class) {
            if (null == vodDownLoad) {
                if (null == UUID || "".equals(UUID)) {
                    UUID = "0";
                }
                vodDownLoad = new VodDownLoad(context, UUID, downloadListener, fileDir);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return vodDownLoad;
        }
    }

    private void release() {
        this.vodDownLoadManager.release();
        vodDownLoad = null;
    }

    public int add(VodParam mVodParam) {
        if (null == mVodParam) {
            return -201;
        }
        VodDownLoadEntity vodDownLoadEntity = new VodDownLoadEntity();
        vodDownLoadEntity.setDownLoadId(mVodParam.getVodId());
        vodDownLoadEntity.setDownLoadUrl(mVodParam.getXmlUrl());
        vodDownLoadEntity.setVodSubject(mVodParam.getVodSubject());
        vodDownLoadEntity.setUserId(this.getLongValue(mVodParam.getUserId()));
        vodDownLoadEntity.setConnectSvr(StringUtil.getHttpAlbAddr((String)mVodParam.getConnectSvr(), (String)mVodParam.getAlbPort()));
        vodDownLoadEntity.setNickName(mVodParam.getNickName());
        vodDownLoadEntity.setSiteId(this.getLongValue(mVodParam.getSiteId()));
        vodDownLoadEntity.setLength(mVodParam.getStorage());
        if (mVodParam instanceof VodObject) {
            vodDownLoadEntity.setsReserved3(VodMr.getClientApiUrl((VodObject)mVodParam));
        }
        return this.vodDownLoadManager.add(vodDownLoadEntity);
    }

    private long getLongValue(String value) {
        if (value == null || "".equals(value)) {
            return 0L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            GenseeLog.w((String)"VodDownLoad", (String)("getLongValue " + e.getMessage()));
            return 0L;
        }
    }

    public void delete(String downLoadId) {
        this.vodDownLoadManager.delete(downLoadId);
    }

    public void delete(List<String> downLoadIds) {
        this.vodDownLoadManager.delete(downLoadIds);
    }

    public void stop(String downLoadId) {
        this.vodDownLoadManager.stop(downLoadId);
    }

    public void setStopStatus(String downLoadID, int nStopStatus) {
        this.vodDownLoadManager.setVodDownLoadStopStatus(downLoadID, nStopStatus);
    }

    public int start(String downLoadId) {
        return this.vodDownLoadManager.start(downLoadId);
    }

    public void updateVdUrl(String downLoadId, String vdUrl) {
        this.vodDownLoadManager.updateVdUrl(downLoadId, vdUrl);
    }

    public void autoStart() {
        this.vodDownLoadManager.autoStart();
    }

    public List<VodDownLoadEntity> getVdlList() {
        return this.vodDownLoadManager.getVodDownLoadList();
    }

    public VodDownLoadEntity getVdlByDlId(String downLoadId) {
        return this.vodDownLoadManager.getVodByDownLoadId(downLoadId);
    }

    public boolean isDownloading(String downLoadId) {
        return this.vodDownLoadManager.isDownloadingByDlId(downLoadId);
    }

    public boolean hasDownloadingTask() {
        return this.vodDownLoadManager.isDownloadingTask();
    }

    public VodDownLoadEntity getCurrentDownloadingEntity() {
        return this.vodDownLoadManager.getCurrentDownloadingEntity();
    }

    public String getPlayUrl(String downLoadId) {
        return this.vodDownLoadManager.getPlayUrl(downLoadId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseVodDownLoad() {
        Class<VodDownLoad> clazz = VodDownLoad.class;
        synchronized (VodDownLoad.class) {
            if (null != vodDownLoad) {
                vodDownLoad.release();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public int download(String vodId) {
        VodObject p = VodMr.getIns().getVodDownloadObjById(vodId);
        if (p != null) {
            this.add((VodParam)p);
        }
        return this.start(vodId);
    }
}

