/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.download;

import android.app.Activity;
import android.os.Environment;
import android.os.StatFs;
import android.os.storage.StorageManager;
import java.io.File;
import java.lang.reflect.InvocationTargetException;

public class SDCardUtil {
    public static boolean isExistSDCard() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static long getSDFreeSize() {
        File path = Environment.getExternalStorageDirectory();
        StatFs sf = new StatFs(path.getPath());
        long blockSize = sf.getBlockSizeLong();
        long freeBlocks = sf.getAvailableBlocksLong();
        return freeBlocks * blockSize / 1024L;
    }

    public static long getSDAllSize() {
        File path = Environment.getExternalStorageDirectory();
        StatFs sf = new StatFs(path.getPath());
        long blockSize = sf.getBlockSizeLong();
        long allBlocks = sf.getBlockCountLong();
        return allBlocks * blockSize / 1024L / 1024L;
    }

    public static long getSDFreeSize(String path) {
        StatFs sf = new StatFs(path);
        long blockSize = sf.getBlockSizeLong();
        long freeBlocks = sf.getAvailableBlocksLong();
        return freeBlocks * blockSize / 1024L / 1024L;
    }

    public static long getSDAllSize(String path) {
        StatFs sf = new StatFs(path);
        long blockSize = sf.getBlockSizeLong();
        long allBlocks = sf.getBlockCountLong();
        return allBlocks * blockSize / 1024L / 1024L;
    }

    public static String[] getVolumePaths(Activity activity) {
        String[] paths = new String[]{};
        StorageManager sm = (StorageManager)activity.getSystemService("storage");
        try {
            Class[] tmp = new Class[]{};
            Object[] tmp1 = new Object[]{};
            paths = (String[])sm.getClass().getMethod("getVolumePaths", tmp).invoke((Object)sm, tmp1);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return paths;
    }

    public static String getVolumeState(Activity activity, String sPath) {
        String sReturn = "";
        StorageManager sm = (StorageManager)activity.getSystemService("storage");
        try {
            sReturn = (String)sm.getClass().getMethod("getVolumeState", String.class).invoke((Object)sm, sPath);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return sReturn;
    }
}

