/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.gensee.media.IVideoIndication;
import com.gensee.media.VideoData;
import com.gensee.utils.GenseeLog;
import java.lang.ref.SoftReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class GSVideoView
extends SurfaceView
implements SurfaceHolder.Callback,
IVideoIndication {
    private static final String TAG = "GSVideoView";
    private SurfaceHolder holder;
    private int defColor = -16777216;
    private static final Object LOCK = new Object();
    private int mWidth;
    private int mHeight;
    private boolean isDestroyed;
    private SoftReference<Bitmap> defBitmapRef = null;
    private boolean isFillXY = false;
    private byte[] data = null;
    private RenderMode renderMode = RenderMode.RM_ADPT_XY;
    private boolean isRendering = false;
    private SoftReference<Bitmap> videoBit;
    private BitmapDrawable drawable;
    private int mH264Width;
    private int mH264Height;
    private int mVideoWidth;
    private int mVideoHeight;
    private Matrix m;

    public GSVideoView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        SurfaceHolder holder = this.getHolder();
        holder.addCallback((SurfaceHolder.Callback)this);
        holder.setFormat(4);
    }

    public GSVideoView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GSVideoView(Context context) {
        this(context, null);
    }

    public RenderMode getRenderMode() {
        return this.renderMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRenderMode(RenderMode renderMode) {
        GenseeLog.d(TAG, "setRenderMode renderMode = " + (Object)((Object)renderMode));
        this.renderMode = renderMode;
        if (this.holder == null || this.videoBit == null || this.drawable == null) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            this.updateVideoMatrix();
            this.drawFram(this.holder, this.m, (Drawable)this.drawable, false);
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.isDestroyed = false;
        GenseeLog.d(TAG, "surfaceCreated holder = " + holder.hashCode());
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        GenseeLog.i(TAG, "surfaceChanged width = " + width + " height = " + height);
        this.holder = holder;
        if (width != this.mWidth || height != this.mHeight) {
            this.mWidth = width;
            this.mHeight = height;
            if (this.mH264Width > 0 && this.mH264Height > 0) {
                this.updateVideoMatrix();
            }
        } else {
            GenseeLog.d(TAG, "surfaceChanged size unchanged");
        }
        if (this.data != null || this.defBitmapRef != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (GSVideoView.this.data != null) {
                        GSVideoView.this.onReceiveData(GSVideoView.this.data, GSVideoView.this.mH264Width, GSVideoView.this.mH264Height, GSVideoView.this.mVideoWidth, GSVideoView.this.mVideoHeight);
                    } else {
                        Bitmap b = null;
                        if (GSVideoView.this.defBitmapRef != null) {
                            b = (Bitmap)GSVideoView.this.defBitmapRef.get();
                        }
                        if (b != null) {
                            GSVideoView.this.renderDrawble(GSVideoView.this.holder, b);
                        }
                    }
                }
            }, "ViReRender").start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void surfaceDestroyed(SurfaceHolder holder) {
        Object object = LOCK;
        synchronized (object) {
            this.isDestroyed = true;
            this.holder = null;
            if (this.videoBit != null) {
                Bitmap b = this.videoBit.get();
                this.videoBit.clear();
                this.videoBit = null;
                if (b != null) {
                    b.recycle();
                }
            }
        }
        GenseeLog.d(TAG, "surfaceDestroyed holder = " + holder.hashCode());
    }

    public void setBackgroundColor(int color) {
        this.setDefColor(color);
    }

    public void setDefColor(int defColor) {
        this.defColor = defColor;
    }

    private void updateVideoMatrix() {
        if (this.m == null) {
            this.m = new Matrix();
        }
        this.m.reset();
        boolean mRotate = false;
        if (!mRotate) {
            float px = 1.0f * (float)this.mWidth / (float)this.mVideoWidth;
            float py = 1.0f * (float)this.mHeight / (float)this.mVideoHeight;
            float opx = 1.0f * (float)this.mVideoWidth / (float)this.mH264Width;
            float opy = 1.0f * (float)this.mVideoHeight / (float)this.mH264Height;
            switch (this.renderMode) {
                case RM_ADPT_XY: {
                    float[] values = new float[9];
                    if (px < py) {
                        this.m.postScale(px * opx, px * opy);
                        this.m.getValues(values);
                        values[5] = ((float)this.mHeight - (float)this.mVideoHeight * px) / 2.0f;
                    } else {
                        this.m.postScale(py * opx, py * opy);
                        this.m.getValues(values);
                        values[2] = ((float)this.mWidth - (float)this.mVideoWidth * py) / 2.0f;
                    }
                    this.m.setValues(values);
                    GenseeLog.d(TAG, "updateVideoMatrix RM_ADPT_XY values = " + values);
                    break;
                }
                case RM_FILL_XY: {
                    this.m.postScale(px * opx, py * opy);
                    break;
                }
                case RM_CENTER: {
                    if (!(px > 0.0f) || !(py > 0.0f)) break;
                    this.m.postScale(opx, opy);
                    this.m.postTranslate((float)(this.mWidth - this.mVideoWidth) / 2.0f, (float)(this.mHeight - this.mVideoHeight) / 2.0f);
                    break;
                }
                case RM_FILL_CENTER_CROP: {
                    float[] fvalues = new float[9];
                    if (px > py) {
                        this.m.postScale(px * opx, px * opy);
                        this.m.getValues(fvalues);
                        fvalues[5] = ((float)this.mHeight - (float)this.mVideoHeight * px) / 2.0f;
                    } else {
                        this.m.postScale(py * opx, py * opy);
                        this.m.getValues(fvalues);
                        fvalues[2] = ((float)this.mWidth - (float)this.mVideoWidth * py) / 2.0f;
                    }
                    this.m.setValues(fvalues);
                    GenseeLog.d(TAG, "updateVideoMatrix RM_FILL_CENTER_CROP values = " + fvalues);
                    break;
                }
            }
        } else {
            this.m.postScale(1.0f * (float)this.getHeight() / (float)this.mH264Width, 1.0f * (float)this.getWidth() / (float)this.mH264Height);
            this.m.postRotate(90.0f, 0.0f, 0.0f);
            this.m.postTranslate((float)this.getWidth(), 0.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onReceiveData(byte[] data, int h264Width, int h264Height, int displayW, int displayH) {
        if (h264Width == 0 || h264Height == 0 || null == data || data.length <= 0) {
            GenseeLog.w("GSVideoView -> onReceiveData h264Width = " + h264Width + " h264Height = " + h264Height);
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            if (this.holder != null) {
                Bitmap b;
                if (this.mH264Width != h264Width || this.mH264Height != h264Height || this.videoBit == null) {
                    b = null;
                    if (null != this.videoBit) {
                        b = this.videoBit.get();
                    }
                    this.videoBit = null;
                    try {
                        this.videoBit = new SoftReference<Bitmap>(Bitmap.createBitmap((int)h264Width, (int)h264Height, (Bitmap.Config)Bitmap.Config.RGB_565));
                    }
                    catch (OutOfMemoryError e) {
                        GenseeLog.w("OutOfMemoryError video err!");
                    }
                    if (b != null) {
                        b.recycle();
                    }
                    if (this.videoBit == null) {
                        System.gc();
                        return;
                    }
                    this.mH264Width = h264Width;
                    this.mH264Height = h264Height;
                    this.drawable = new BitmapDrawable(this.getContext().getApplicationContext().getResources(), this.videoBit.get());
                    this.drawable.setBounds(0, 0, this.mH264Width, this.mH264Height);
                    this.updateVideoMatrix();
                }
                if (displayW != this.mVideoWidth || displayH != this.mVideoHeight) {
                    this.mVideoWidth = displayW;
                    this.mVideoHeight = displayH;
                    this.updateVideoMatrix();
                }
                try {
                    b = this.videoBit.get();
                    if (b != null) {
                        b.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(data));
                    } else {
                        GenseeLog.w(TAG, "b is null");
                    }
                }
                catch (RuntimeException e) {
                    GenseeLog.w(TAG, e);
                    return;
                }
                catch (Exception e) {
                    GenseeLog.w(TAG, e);
                    return;
                }
            }
            this.drawFram(this.holder, this.m, (Drawable)this.drawable, false);
        }
    }

    protected void drawFram(SurfaceHolder holder, Matrix m, Drawable d, boolean isOnlyBg) {
        if (holder == null || this.isDestroyed) {
            return;
        }
        Canvas canvas = null;
        if (!this.isDestroyed) {
            this.isRendering = true;
            canvas = holder.lockCanvas();
        }
        if (canvas != null) {
            canvas.save();
            canvas.drawColor(this.defColor);
            if (!isOnlyBg && d != null) {
                try {
                    canvas.concat(m);
                    d.draw(canvas);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    GenseeLog.w(TAG, e.getMessage());
                }
            }
            canvas.restore();
            if (!this.isDestroyed) {
                try {
                    holder.unlockCanvasAndPost(canvas);
                }
                catch (Exception e) {
                    GenseeLog.w(TAG, e.getMessage());
                }
            }
        }
        this.isRendering = false;
    }

    @Override
    public void onReceiveFrame(byte[] data, int width, int height) {
        this.data = data;
        if (!this.isDestroyed) {
            this.onReceiveData(data, width, height, width, height);
        }
    }

    @Override
    public void onReceiveFrame(VideoData data) {
        this.data = data.getData();
        if (!this.isDestroyed) {
            this.onReceiveData(data.getData(), data.getWidth(), data.getHeight(), data.getDisplayW(), data.getDisplayH());
        }
    }

    @Override
    public void renderDefault() {
        if (null != this.data) {
            this.data = null;
        }
        this.drawFram(this.holder, null, null, true);
    }

    public void renderDrawble(Bitmap defBitmap, boolean isFillXY) {
        if (defBitmap == null) {
            return;
        }
        this.isFillXY = isFillXY;
        if (this.defBitmapRef != null) {
            Bitmap b = this.defBitmapRef.get();
            if (b != null) {
                b.recycle();
            }
            this.defBitmapRef.clear();
        }
        this.defBitmapRef = new SoftReference<Bitmap>(defBitmap);
        if (this.holder != null) {
            this.renderDrawble(this.holder, defBitmap);
        }
    }

    private void renderDrawble(SurfaceHolder holder, Bitmap defBitmap) {
        Matrix m = new Matrix();
        float bw = defBitmap.getWidth();
        float bh = defBitmap.getHeight();
        float sx = 1.0f;
        float sy = 1.0f;
        if (this.isFillXY) {
            sx = (float)this.mWidth / bw;
            sy = (float)this.mHeight / bh;
            m.postScale(sx, sy);
        } else if (bw > (float)this.mWidth || bh > (float)this.mHeight) {
            sx = (float)this.mWidth / bw;
            sy = (float)this.mHeight / bh;
            if (sx > sy) {
                m.postScale(sy, sy);
                m.postTranslate(0.0f, ((float)this.mWidth - bw * sy) / 2.0f);
            } else {
                m.postTranslate(((float)this.mHeight - bh * sx) / 2.0f, 0.0f);
                m.postScale(sx, sx);
            }
        } else {
            m.postTranslate(((float)this.mWidth - bw) / 2.0f, ((float)this.mHeight - bh) / 2.0f);
        }
        BitmapDrawable d = new BitmapDrawable(this.getResources(), defBitmap);
        d.setBounds(0, 0, d.getIntrinsicWidth(), d.getIntrinsicHeight());
        this.drawFram(holder, m, (Drawable)d, false);
    }

    public byte[] getData() {
        return this.data;
    }

    public int getVideoWidth() {
        return this.mH264Width;
    }

    public int getVideoHeight() {
        return this.mH264Height;
    }

    public static enum RenderMode {
        RM_FILL_XY,
        RM_ADPT_XY,
        RM_CENTER,
        RM_FILL_CENTER_CROP;

    }
}

