/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.util.AttributeSet;
import com.gensee.media.IVideoIndication;
import com.gensee.media.VideoData;
import com.gensee.texture.GSGLESTextureView;
import com.gensee.texture.GSGLProgram;
import com.gensee.texture.IGSGLESRenderer;
import com.gensee.utils.GenseeLog;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class GSTVideoView
extends GSGLESTextureView
implements IGSGLESRenderer,
IVideoIndication {
    private static final String TAG = "GSTVideoView";
    int recFrameCount;
    int renderFrameCount;
    private int mWidth;
    private int mHeight;
    private Buffer y;
    private Buffer u;
    private Buffer v;
    private GSGLProgram prog;
    private int mVideoWidth = -1;
    private int mVideoHeight = -1;
    private int mVideoDWidth = -1;
    private int mVideoDHeight = -1;
    private IVideoIndication.RenderMode videoRenderMode = IVideoIndication.RenderMode.RM_ADPT_XY;
    private VideoData lastVideoData = null;

    public GSTVideoView(Context context) {
        this(context, null);
    }

    public GSTVideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        this.setRenderer(this);
        this.setRenderMode(0);
    }

    @Override
    public void onSurfaceCreated() {
        this.prog = new GSGLProgram(0);
        if (!this.prog.isProgramBuilt()) {
            this.prog.buildProgram();
            GenseeLog.d(TAG, "GLFrameRenderer :: buildProgram done");
        }
    }

    @Override
    public void onSurfaceChanged(int width, int height) {
        GenseeLog.d(TAG, "onSurfaceChanged width " + width + " height = " + height);
        if (width == 0 || height == 0) {
            GenseeLog.w(TAG, "onSurfaceChanged not update ,width " + width + " height = " + height);
            return;
        }
        this.mWidth = width;
        this.mHeight = height;
        this.updateScall();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDrawFrame() {
        GenseeLog.d(TAG, "onDrawFrame width = " + this.mVideoWidth + " height = " + this.mVideoWidth);
        if (this.prog.isProgramBuilt()) {
            ++this.renderFrameCount;
            if (this.renderFrameCount == 100) {
                GenseeLog.d(TAG, "onDrawFrame renderFrameCount = " + this.renderFrameCount + " recFrameCount = " + this.recFrameCount);
                this.renderFrameCount = 0;
                this.recFrameCount = 0;
            }
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GLES20.glClear((int)16640);
            GSTVideoView gSTVideoView = this;
            synchronized (gSTVideoView) {
                if (this.y != null) {
                    this.y.position(0);
                    this.u.position(0);
                    this.v.position(0);
                    this.prog.buildTextures(this.y, this.u, this.v, this.mVideoWidth, this.mVideoHeight);
                    this.prog.drawFrame(this.y, this.u, this.v, this.mVideoWidth, this.mVideoHeight);
                }
            }
        }
    }

    @Override
    public void onDrawFrame(Bitmap bitmap) {
    }

    private void updateScall() {
        GenseeLog.d(TAG, "updateScall mVideoDWidth = " + this.mVideoDWidth + " mWidth = " + this.mWidth);
        if (this.mVideoDWidth <= 0 || this.mWidth <= 0) {
            return;
        }
        switch (this.videoRenderMode) {
            case RM_CENTER: {
                if (this.mWidth > this.mVideoDWidth && this.mHeight > this.mVideoDHeight) {
                    this.viewport((this.mWidth - this.mVideoDWidth) / 2, (this.mHeight - this.mVideoDHeight) / 2, this.mVideoDWidth, this.mVideoDHeight);
                    break;
                }
                this.adaptOrCrop(true);
                break;
            }
            case RM_ADPT_XY: {
                this.adaptOrCrop(true);
                break;
            }
            case RM_FILL_XY: {
                this.viewport(0, 0, this.mWidth, this.mHeight);
                break;
            }
            default: {
                this.adaptOrCrop(false);
            }
        }
    }

    void adaptOrCrop(boolean isShowAdaptView) {
        float y;
        float showHeight;
        float showWidth;
        float x;
        float px = 1.0f * (float)this.mWidth / (float)this.mVideoDWidth;
        float py = 1.0f * (float)this.mHeight / (float)this.mVideoDHeight;
        if (isShowAdaptView ? px < py : px > py) {
            x = 0.0f;
            showWidth = this.mWidth;
            showHeight = px * (float)this.mVideoDHeight;
            y = ((float)this.mHeight - showHeight) / 2.0f;
        } else {
            y = 0.0f;
            showHeight = this.mHeight;
            showWidth = py * (float)this.mVideoDWidth;
            x = ((float)this.mWidth - showWidth) / 2.0f;
        }
        this.viewport((int)x, (int)y, (int)showWidth, (int)showHeight);
    }

    private void viewport(int x, int y, int w, int h) {
        GenseeLog.d(TAG, "viewport x = " + x + " y = " + y + " w = " + w + " h = " + h);
        GLES20.glViewport((int)x, (int)y, (int)w, (int)h);
    }

    @Override
    public void onReceiveFrame(byte[] data, int width, int height) {
        this.onReceiveFrame(new VideoData(data, 0L, width, height, width, height));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(int disPlayW, int disPlayH, int videoWidth, int videoHeight) {
        if (disPlayW > 0 && disPlayH > 0) {
            if (this.mVideoDWidth != disPlayW || this.mVideoDHeight != disPlayH) {
                this.mVideoDWidth = disPlayW;
                this.mVideoDHeight = disPlayH;
                this.updateScall();
            }
            if (videoWidth != this.mVideoWidth || videoHeight != this.mVideoHeight || this.y == null) {
                this.mVideoWidth = videoWidth;
                this.mVideoHeight = videoHeight;
                int yarraySize = videoWidth * videoHeight;
                int uvarraySize = yarraySize / 4;
                GSTVideoView gSTVideoView = this;
                synchronized (gSTVideoView) {
                    this.y = ByteBuffer.allocate(yarraySize);
                    this.u = ByteBuffer.allocate(uvarraySize);
                    this.v = ByteBuffer.allocate(uvarraySize);
                }
            }
        }
        GenseeLog.d(TAG, "update disPlayW = " + disPlayW + " disPlayH = " + disPlayH + " mVideoWidth = " + this.mVideoWidth + " mVideoHeight = " + this.mVideoHeight);
    }

    @Override
    public void onReceiveFrame(final VideoData videoData) {
        this.lastVideoData = videoData;
        ++this.recFrameCount;
        this.addToPending(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                GSTVideoView.this.update(videoData.getDisplayW(), videoData.getDisplayH(), videoData.getWidth(), videoData.getHeight());
                1 var1_1 = this;
                synchronized (var1_1) {
                    byte[] data = videoData.getData();
                    int width = videoData.getWidth();
                    int height = videoData.getHeight();
                    GSTVideoView.this.y.clear();
                    GSTVideoView.this.u.clear();
                    GSTVideoView.this.v.clear();
                    ((ByteBuffer)GSTVideoView.this.y).put(data, 0, width * height);
                    ((ByteBuffer)GSTVideoView.this.u).put(data, width * height, width * height / 4);
                    ((ByteBuffer)GSTVideoView.this.v).put(data, width * height * 5 / 4, width * height / 4);
                }
                GSTVideoView.this.drawFrame();
            }
        });
        this.requestRender();
    }

    public void refreshFrame() {
        if (this.lastVideoData != null) {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    GSTVideoView.this.onReceiveFrame(GSTVideoView.this.lastVideoData);
                }
            }, 50L);
        }
    }

    private void setBgcolor() {
    }

    @Override
    public void renderDefault() {
        this.addToPending(new Runnable(){

            @Override
            public void run() {
                GSTVideoView.this.y = null;
            }
        });
        this.requestRender();
    }

    public void setRenderMode(IVideoIndication.RenderMode mode) {
        this.videoRenderMode = mode;
        this.addToPending(new Runnable(){

            @Override
            public void run() {
                GSTVideoView.this.updateScall();
            }
        });
        this.requestRender();
    }

    public IVideoIndication.RenderMode getRenderMode() {
        return this.videoRenderMode;
    }
}

