/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.gensee.GPUImage.GLTextureView;
import com.gensee.GPUImage.GPUImage;
import com.gensee.GPUImage.filter.GPUImageFilter;
import com.gensee.common.GenseeConfig;
import com.gensee.media.IVideoIndication;
import com.gensee.media.VideoData;
import com.gensee.utils.GenseeLog;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class GSGPUVideoView
extends FrameLayout
implements IVideoIndication {
    private final String TAG = this.getClass().getSimpleName();
    private int surfaceType = 1;
    private View surfaceView;
    private GPUImage gpuImage;
    private boolean isShowLoading = false;
    private GPUImageFilter filter;
    public Size forceSize = null;
    private float ratio = 0.0f;
    public static final int RENDERMODE_WHEN_DIRTY = 0;
    public static final int RENDERMODE_CONTINUOUSLY = 1;
    private int mH264Width;
    private int mH264Height;
    private int mVideoWidth;
    private int mVideoHeight;
    private Bitmap mBitmap;
    private GPUImage.ScaleType mScaleType = GPUImage.ScaleType.CENTER_INSIDE;

    public GSGPUVideoView(Context context) {
        super(context);
        this.init(context, null);
    }

    public GSGPUVideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public void setSurfaceType(int surfaceType) {
        if (surfaceType != this.surfaceType) {
            this.surfaceType = surfaceType;
            this.init(this.getContext(), null);
        }
    }

    private void init(Context context, AttributeSet attrs) {
        this.removeAllViews();
        GPUImage image = new GPUImage(context);
        if (this.surfaceType == 1) {
            this.surfaceView = new GPUImageGLTextureView(context, attrs);
            image.setGLTextureView((GLTextureView)this.surfaceView);
        } else {
            this.surfaceView = new GPUImageGLSurfaceView(context, attrs);
            image.setGLSurfaceView((GLSurfaceView)this.surfaceView);
        }
        image.setScaleType(this.mScaleType);
        this.addView(this.surfaceView);
        this.setViewRenderMode(0);
        this.gpuImage = image;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        GenseeLog.i(this.TAG, "onDetachedFromWindow: " + this.hashCode());
        if (!GenseeConfig.isMultiPlayer) {
            this.gpuImage.deleteImage();
            this.gpuImage = null;
            if (this.mBitmap != null) {
                this.mBitmap.recycle();
            }
            this.mBitmap = null;
            this.removeAllViews();
        }
    }

    protected void onAttachedToWindow() {
        GenseeLog.i(this.TAG, "onAttachedToWindow: " + this.hashCode());
        super.onAttachedToWindow();
        if (null == this.gpuImage && !GenseeConfig.isMultiPlayer) {
            this.init(this.getContext(), null);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.ratio != 0.0f) {
            int newHeight;
            int newWidth;
            int height;
            int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
            if ((float)width / this.ratio < (float)(height = View.MeasureSpec.getSize((int)heightMeasureSpec))) {
                newWidth = width;
                newHeight = Math.round((float)width / this.ratio);
            } else {
                newHeight = height;
                newWidth = Math.round((float)height * this.ratio);
            }
            int newWidthSpec = View.MeasureSpec.makeMeasureSpec((int)newWidth, (int)0x40000000);
            int newHeightSpec = View.MeasureSpec.makeMeasureSpec((int)newHeight, (int)0x40000000);
            super.onMeasure(newWidthSpec, newHeightSpec);
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    @Override
    public void onReceiveFrame(byte[] data, int width, int height) {
        this.onReceiveData(data, width, height, width, height);
    }

    @Override
    public void onReceiveFrame(VideoData videoData) {
        this.onReceiveData(videoData.getData(), videoData.getWidth(), videoData.getHeight(), videoData.getDisplayW(), videoData.getDisplayH());
    }

    @Override
    public void renderDefault() {
        if (null != this.gpuImage) {
            this.gpuImage.deleteImage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onReceiveData(byte[] data, int h264Width, int h264Height, int displayW, int displayH) {
        GPUImage image = this.gpuImage;
        if (image == null || h264Width == 0 || h264Height == 0 || null == data || data.length <= 0) {
            GenseeLog.w(this.TAG + " -> onReceiveData h264Width = " + h264Width + " h264Height = " + h264Height);
            GenseeLog.w(this.TAG + " -> image = " + image);
            if (data != null) {
                GenseeLog.w(this.TAG + " -> data.length = " + data.length);
            }
            return;
        }
        GSGPUVideoView gSGPUVideoView = this;
        synchronized (gSGPUVideoView) {
            if (this.mH264Width != h264Width || this.mH264Height != h264Height || this.mBitmap == null) {
                GenseeLog.i(this.TAG, "onReceiveData size change,mH264Width=" + this.mH264Width + ",mH264Height=" + this.mH264Height + ",  h264Width=" + h264Width + ",h264Height=" + h264Height + ",displayW=" + displayW + ",displayH=" + displayH);
                if (null != this.mBitmap) {
                    this.gpuImage.deleteImage();
                }
                try {
                    this.mBitmap = Bitmap.createBitmap((int)h264Width, (int)h264Height, (Bitmap.Config)Bitmap.Config.RGB_565);
                }
                catch (OutOfMemoryError e) {
                    GenseeLog.w(this.TAG, "OutOfMemoryError video err!");
                }
                this.mH264Width = h264Width;
                this.mH264Height = h264Height;
            }
            if (displayW != this.mVideoWidth || displayH != this.mVideoHeight) {
                this.mVideoWidth = displayW;
                this.mVideoHeight = displayH;
            }
            try {
                if (this.mBitmap != null) {
                    this.mBitmap.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(data));
                    if (image != null) {
                        image.setImage(this.mBitmap);
                    }
                } else {
                    GenseeLog.w(this.TAG, "mBitmap is null");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                GenseeLog.w(this.TAG, "onReceiveData Exception:" + e + ",data.length=" + data.length + ",bitmapByteCount=" + (null == this.mBitmap ? "0" : Integer.valueOf(this.mBitmap.getByteCount())));
            }
        }
    }

    public void setBackgroundColor(int color) {
        this.gpuImage.setBackgroundColor(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF);
    }

    public void setBackgroundColor(float red, float green, float blue) {
        this.gpuImage.setBackgroundColor(red, green, blue);
    }

    private void setViewRenderMode(int renderMode) {
        if (this.surfaceView instanceof GLSurfaceView) {
            ((GLSurfaceView)this.surfaceView).setRenderMode(renderMode);
        } else if (this.surfaceView instanceof GLTextureView) {
            ((GLTextureView)this.surfaceView).setRenderMode(renderMode);
        }
    }

    public void setRenderMode(IVideoIndication.RenderMode renderMode) {
        this.mScaleType = renderMode == IVideoIndication.RenderMode.RM_FILL_CENTER_CROP ? GPUImage.ScaleType.CENTER_CROP : GPUImage.ScaleType.CENTER_INSIDE;
        this.gpuImage.setScaleType(this.mScaleType);
    }

    public void setScaleType(GPUImage.ScaleType scaleType) {
        this.gpuImage.setScaleType(scaleType);
    }

    public void requestRender() {
        if (this.surfaceView instanceof GLSurfaceView) {
            ((GLSurfaceView)this.surfaceView).requestRender();
        } else if (this.surfaceView instanceof GLTextureView) {
            ((GLTextureView)this.surfaceView).requestRender();
        }
    }

    public void onPause() {
        if (this.surfaceView instanceof GLSurfaceView) {
            ((GLSurfaceView)this.surfaceView).onPause();
        } else if (this.surfaceView instanceof GLTextureView) {
            ((GLTextureView)this.surfaceView).onPause();
        }
    }

    public void onResume() {
        if (this.surfaceView instanceof GLSurfaceView) {
            ((GLSurfaceView)this.surfaceView).onResume();
        } else if (this.surfaceView instanceof GLTextureView) {
            ((GLTextureView)this.surfaceView).onResume();
        }
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        this.surfaceView.setVisibility(visibility);
    }

    public void setZOrderOnTop(boolean isOnTop) {
        if (this.surfaceView instanceof GLSurfaceView) {
            ((GLSurfaceView)this.surfaceView).setZOrderOnTop(isOnTop);
        }
    }

    public void setZOrderMediaOverlay(boolean isOnTop) {
        if (this.surfaceView instanceof GLSurfaceView) {
            ((GLSurfaceView)this.surfaceView).setZOrderMediaOverlay(isOnTop);
        }
    }

    private class GPUImageGLTextureView
    extends GLTextureView {
        public GPUImageGLTextureView(Context context) {
            super(context);
        }

        public GPUImageGLTextureView(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            if (GSGPUVideoView.this.forceSize != null) {
                super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)GSGPUVideoView.this.forceSize.width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)GSGPUVideoView.this.forceSize.height, (int)0x40000000));
            } else {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
        }

        @Override
        protected void onDetachedFromWindow() {
            if (!GenseeConfig.isMultiPlayer) {
                super.onDetachedFromWindow();
            }
        }

        @Override
        protected void onAttachedToWindow() {
            if (!GenseeConfig.isMultiPlayer) {
                super.onAttachedToWindow();
            }
        }
    }

    private class GPUImageGLSurfaceView
    extends GLSurfaceView {
        public GPUImageGLSurfaceView(Context context) {
            super(context);
        }

        public GPUImageGLSurfaceView(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            if (GSGPUVideoView.this.forceSize != null) {
                super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)GSGPUVideoView.this.forceSize.width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)GSGPUVideoView.this.forceSize.height, (int)0x40000000));
            } else {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
        }
    }

    public static class Size {
        int width;
        int height;

        public Size(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }
}

