/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.opengl.GLES20;
import android.util.AttributeSet;
import com.gensee.canvasgl.CanvasGL;
import com.gensee.canvasgl.ICanvasGL;
import com.gensee.media.IVideoIndication;
import com.gensee.media.VideoData;
import com.gensee.texture.GSGLESTextureView;
import com.gensee.texture.IGSGLESRenderer;
import com.gensee.utils.GenseeLog;
import java.lang.ref.SoftReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class GSGLVideoView
extends GSGLESTextureView
implements IGSGLESRenderer,
IVideoIndication {
    private static final Object LOCK = new Object();
    protected CanvasGL mCanvas;
    private int defColor = -16777216;
    private int frameCount;
    private int receiveCount;
    private long lastTime;
    private ICanvasGL.BitmapMatrix matrix;
    private IVideoIndication.RenderMode renderMode = IVideoIndication.RenderMode.RM_ADPT_XY;
    private Matrix m;
    private int mWidth;
    private int mHeight;
    private int mH264Width;
    private int mH264Height;
    private static final String TAG = "GSGLVideoView";
    private boolean isDestroyed;
    private SoftReference<Bitmap> videoBit;
    private SoftReference<Bitmap> defBitmapRef;
    private int mVideoWidth;
    private int mVideoHeight;
    private byte[] data;
    private boolean isFillXY;
    private boolean isNeedRenderDefaultBitmap;
    private int mDrawLeft;
    private int mDrawTop;
    private int mDrawWidth;
    private int mDrawHeight;

    public void renderDrawble(Bitmap defBitmap, boolean isFillXY) {
        if (defBitmap == null) {
            return;
        }
        this.isFillXY = isFillXY;
        if (this.defBitmapRef != null) {
            Bitmap b = this.defBitmapRef.get();
            if (b != null) {
                b.recycle();
            }
            this.defBitmapRef.clear();
        }
        this.defBitmapRef = new SoftReference<Bitmap>(defBitmap);
        if (!this.isDestroyed) {
            this.isNeedRenderDefaultBitmap = true;
            this.addToPending(new Runnable(){

                @Override
                public void run() {
                    GSGLVideoView.this.drawFrame();
                }
            });
        }
    }

    private void renderDefaultBitmap(Bitmap defBitmap) {
        if (null == this.mCanvas) {
            GenseeLog.d(TAG, "renderDefaultBitmap mCanvas is not ready!");
            return;
        }
        ICanvasGL.BitmapMatrix defMatrix = new ICanvasGL.BitmapMatrix();
        float bw = defBitmap.getWidth();
        float bh = defBitmap.getHeight();
        float sx = 1.0f;
        float sy = 1.0f;
        if (this.isFillXY) {
            sx = (float)this.mWidth / bw;
            sy = (float)this.mHeight / bh;
            defMatrix.scale(sx, sy);
        } else if (bw > (float)this.mWidth || bh > (float)this.mHeight) {
            sx = (float)this.mWidth / bw;
            sy = (float)this.mHeight / bh;
            if (sx > sy) {
                defMatrix.scale(sy, sy);
                defMatrix.translate(0.0f, ((float)this.mWidth - bw * sy) / 2.0f);
            } else {
                defMatrix.translate(((float)this.mHeight - bh * sx) / 2.0f, 0.0f);
                defMatrix.scale(sx, sx);
            }
        } else {
            defMatrix.translate(((float)this.mWidth - bw) / 2.0f, ((float)this.mHeight - bh) / 2.0f);
        }
        this.mCanvas.invalidateTextureContent(defBitmap);
        this.mCanvas.drawBitmap(defBitmap, defMatrix);
    }

    public void setBackgroundColor(int color) {
        this.setDefColor(color);
    }

    public void setDefColor(int defColor) {
        this.defColor = defColor;
    }

    public void setRenderMode(IVideoIndication.RenderMode renderMode) {
        this.renderMode = renderMode;
    }

    public GSGLVideoView(Context context) {
        super(context);
        this.init();
    }

    public GSGLVideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    protected void init() {
        this.setRenderer(this);
        this.setRenderMode(0);
    }

    @Override
    public void onReceiveFrame(byte[] bytes, int h264Width, int h264Height) {
        ++this.receiveCount;
        this.isNeedRenderDefaultBitmap = false;
        this.data = bytes;
        this.onReceiveData(bytes, h264Width, h264Height, h264Width, h264Height);
    }

    @Override
    public void onReceiveFrame(VideoData data) {
        ++this.receiveCount;
        this.isNeedRenderDefaultBitmap = false;
        this.data = data.getData();
        this.onReceiveData(data.getData(), data.getWidth(), data.getHeight(), data.getDisplayW(), data.getDisplayH());
    }

    @Override
    public void renderDefault() {
        if (null != this.data) {
            this.data = null;
            if (null != this.mCanvas && null != this.videoBit) {
                this.mCanvas.invalidateTextureContent(this.videoBit.get());
            }
        }
        this.addToPending(new Runnable(){

            @Override
            public void run() {
                GSGLVideoView.this.drawFrame();
            }
        });
    }

    @Override
    public void onSurfaceCreated() {
        GenseeLog.i(TAG, "onSurfaceCreated() called");
        this.isDestroyed = false;
        this.mCanvas = new CanvasGL();
    }

    @Override
    public void onSurfaceChanged(int width, int height) {
        GenseeLog.i(TAG, "onSurfaceChanged() called with: width = [" + width + "], height = [" + height + "]");
        if (width == 0 || height == 0) {
            return;
        }
        this.mCanvas.setSize(width, height);
        if (this.mWidth != width || this.mHeight != height) {
            this.mWidth = width;
            this.mHeight = height;
            if (this.mH264Width > 0 && this.mH264Height > 0) {
                this.updateVideoMatrix();
            }
        }
        if (this.data == null) {
            Bitmap b = null;
            if (this.defBitmapRef != null) {
                b = this.defBitmapRef.get();
            }
            if (b != null && this.isNeedRenderDefaultBitmap) {
                this.requestRender();
            }
        }
    }

    @Override
    public void onDrawFrame() {
        GLES20.glClearColor((float)(this.defColor >> 16 & 0xFF), (float)(this.defColor >> 8 & 0xFF), (float)(this.defColor & 0xFF), (float)(this.defColor >> 24 & 0xFF));
        GLES20.glClear((int)16384);
        if (this.isNeedRenderDefaultBitmap && null != this.defBitmapRef && null != this.defBitmapRef.get()) {
            this.renderDefaultBitmap(this.defBitmapRef.get());
        } else if (null != this.data && null != this.videoBit && null != this.videoBit.get()) {
            this.calcFrames();
            this.mCanvas.invalidateTextureContent(this.videoBit.get());
            this.mCanvas.drawBitmap(this.videoBit.get(), this.mDrawLeft, this.mDrawTop, this.mDrawWidth, this.mDrawHeight);
        }
    }

    @Override
    public void onDrawFrame(Bitmap bitmap) {
        GLES20.glClearColor((float)(this.defColor >> 16 & 0xFF), (float)(this.defColor >> 8 & 0xFF), (float)(this.defColor & 0xFF), (float)(this.defColor >> 24 & 0xFF));
        GLES20.glClear((int)16384);
        if (this.isNeedRenderDefaultBitmap && null != this.defBitmapRef && null != this.defBitmapRef.get()) {
            this.renderDefaultBitmap(this.defBitmapRef.get());
        } else if (null != bitmap) {
            this.calcFrames();
            this.mCanvas.invalidateTextureContent(bitmap);
            this.mCanvas.drawBitmap(bitmap, this.mDrawLeft, this.mDrawTop, this.mDrawWidth, this.mDrawHeight);
        }
    }

    protected void onReceiveData(final byte[] data, final int h264Width, final int h264Height, final int displayW, final int displayH) {
        if (h264Width == 0 || h264Height == 0 || null == data || data.length <= 0) {
            GenseeLog.w("GSGLVideoView -> onReceiveData h264Width = " + h264Width + " h264Height = " + h264Height);
            return;
        }
        if (!this.isDestroyed) {
            this.addToPending(new Runnable(){

                @Override
                public void run() {
                    Bitmap b;
                    if (GSGLVideoView.this.mH264Width != h264Width || GSGLVideoView.this.mH264Height != h264Height || GSGLVideoView.this.videoBit == null) {
                        b = null;
                        if (null != GSGLVideoView.this.videoBit) {
                            b = (Bitmap)GSGLVideoView.this.videoBit.get();
                            GSGLVideoView.this.videoBit.clear();
                        }
                        try {
                            GSGLVideoView.this.videoBit = new SoftReference<Bitmap>(Bitmap.createBitmap((int)h264Width, (int)h264Height, (Bitmap.Config)Bitmap.Config.RGB_565));
                        }
                        catch (OutOfMemoryError e) {
                            GenseeLog.w("OutOfMemoryError video err!");
                        }
                        if (b != null) {
                            b.recycle();
                        }
                        GSGLVideoView.this.mH264Width = h264Width;
                        GSGLVideoView.this.mH264Height = h264Height;
                        GSGLVideoView.this.updateVideoMatrix();
                    }
                    if (displayW != GSGLVideoView.this.mVideoWidth || displayH != GSGLVideoView.this.mVideoHeight) {
                        GSGLVideoView.this.mVideoWidth = displayW;
                        GSGLVideoView.this.mVideoHeight = displayH;
                        GSGLVideoView.this.updateVideoMatrix();
                    }
                    try {
                        b = (Bitmap)GSGLVideoView.this.videoBit.get();
                        if (b != null) {
                            b.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(data));
                            GSGLVideoView.this.drawFrame(b);
                        } else {
                            GenseeLog.w(GSGLVideoView.TAG, "b is null");
                        }
                    }
                    catch (Exception e) {
                        GenseeLog.w(GSGLVideoView.TAG, e);
                    }
                }
            });
        }
    }

    private void updateVideoMatrix() {
        if (this.m == null) {
            this.m = new Matrix();
        }
        this.m.reset();
        boolean mRotate = false;
        if (!mRotate) {
            float px = 1.0f * (float)this.mWidth / (float)this.mVideoWidth;
            float py = 1.0f * (float)this.mHeight / (float)this.mVideoHeight;
            float opx = 1.0f * (float)this.mVideoWidth / (float)this.mH264Width;
            float opy = 1.0f * (float)this.mVideoHeight / (float)this.mH264Height;
            switch (this.renderMode) {
                case RM_ADPT_XY: {
                    float[] values = new float[9];
                    if (px < py) {
                        this.m.postScale(px * opx, px * opy);
                        this.m.getValues(values);
                        values[5] = ((float)this.mHeight - (float)this.mVideoHeight * px) / 2.0f;
                    } else {
                        this.m.postScale(py * opx, py * opy);
                        this.m.getValues(values);
                        values[2] = ((float)this.mWidth - (float)this.mVideoWidth * py) / 2.0f;
                    }
                    this.m.setValues(values);
                    GenseeLog.i(TAG, "updateVideoMatrix RM_ADPT_XY ,mWidth:" + this.mWidth + ",mHeight:" + this.mHeight + ",mVideoWidth:" + this.mVideoWidth + ",mVideoHeight:" + this.mVideoHeight + ",mH264Width:" + this.mH264Width + ",mH264Height:" + this.mH264Height + ",mValue[0]:" + values[0] + ",mValue[4]:" + values[4] + ",mValue[2]:" + values[2] + ",mValue[5]:" + values[5]);
                    break;
                }
                case RM_FILL_XY: {
                    this.m.postScale(px * opx, py * opy);
                    break;
                }
                case RM_CENTER: {
                    if (!(px > 0.0f) || !(py > 0.0f)) break;
                    this.m.postScale(opx, opy);
                    this.m.postTranslate((float)(this.mWidth - this.mVideoWidth) / 2.0f, (float)(this.mHeight - this.mVideoHeight) / 2.0f);
                    break;
                }
                case RM_FILL_CENTER_CROP: {
                    float[] fvalues = new float[9];
                    if (px > py) {
                        this.m.postScale(px * opx, px * opy);
                        this.m.getValues(fvalues);
                        fvalues[5] = ((float)this.mHeight - (float)this.mVideoHeight * px) / 2.0f;
                    } else {
                        this.m.postScale(py * opx, py * opy);
                        this.m.getValues(fvalues);
                        fvalues[2] = ((float)this.mWidth - (float)this.mVideoWidth * py) / 2.0f;
                    }
                    this.m.setValues(fvalues);
                    GenseeLog.d(TAG, "updateVideoMatrix RM_FILL_CENTER_CROP values = " + fvalues);
                    break;
                }
            }
        } else {
            this.m.postScale(1.0f * (float)this.mHeight / (float)this.mH264Width, 1.0f * (float)this.mWidth / (float)this.mH264Height);
            this.m.postRotate(90.0f, 0.0f, 0.0f);
            this.m.postTranslate((float)this.mWidth, 0.0f);
        }
        float[] mValue = new float[9];
        this.m.getValues(mValue);
        this.mDrawLeft = (int)mValue[2];
        this.mDrawTop = (int)mValue[5];
        this.mDrawWidth = (int)((float)this.mH264Width * mValue[0]);
        this.mDrawHeight = (int)((float)this.mH264Height * mValue[4]);
    }

    @Override
    public void onDestroy() {
        this.addToPending(new Runnable(){

            @Override
            public void run() {
                if (GSGLVideoView.this.videoBit != null) {
                    Bitmap b = (Bitmap)GSGLVideoView.this.videoBit.get();
                    if (b != null) {
                        b.recycle();
                    }
                    GSGLVideoView.this.videoBit.clear();
                    GSGLVideoView.this.videoBit = null;
                }
            }
        });
        super.onDestroy();
        this.isDestroyed = true;
    }

    private void calcFrames() {
        ++this.frameCount;
        long now = System.currentTimeMillis();
        if (now - this.lastTime > 10000L) {
            GenseeLog.i(TAG, " calcFrames receiveCount = " + this.receiveCount + ", frameCount = " + this.frameCount);
            this.frameCount = 0;
            this.receiveCount = 0;
            this.lastTime = now;
        }
    }
}

