/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.gensee.media.IVideoIndication;
import com.gensee.media.OnVideoDecodeListener;
import com.gensee.media.ViDecoder;
import com.gensee.media.VideoData;
import com.gensee.utils.GenseeLog;

public class GSAudoDecodeViewEx
extends RelativeLayout
implements IVideoIndication,
OnVideoDecodeListener,
TextureView.SurfaceTextureListener {
    private static final String TAG = "GSAudoDecodeViewEx";
    private ViDecoder mViDecoder;
    private TextureView mTextureView;
    private int nVideoWidth;
    private int nVideoHeight;
    private long viewId = 0L;
    private RelativeLayout.LayoutParams lpTextureView;
    private ImageView ivDefault;
    private IVideoIndication.RenderMode renderMode = IVideoIndication.RenderMode.RM_ADPT_XY;

    public void setRenderMode(IVideoIndication.RenderMode renderMode) {
        this.renderMode = renderMode;
    }

    public GSAudoDecodeViewEx(Context context) {
        this(context, null);
    }

    public GSAudoDecodeViewEx(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GSAudoDecodeViewEx(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setBackgroundColor(-16777216);
        this.setGravity(17);
        this.mTextureView = new TextureView(this.getContext());
        this.mTextureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
        this.addTextureView();
        this.ivDefault = new ImageView(this.getContext());
        RelativeLayout.LayoutParams lpDefualt = new RelativeLayout.LayoutParams(-1, -1);
        this.addView((View)this.ivDefault, (ViewGroup.LayoutParams)lpDefualt);
    }

    private void addTextureView() {
        if (null != this.mTextureView) {
            if (this.mTextureView.getParent() != null) {
                this.removeTextureView();
            }
            if (null == this.lpTextureView) {
                this.lpTextureView = new RelativeLayout.LayoutParams(-1, -1);
                this.lpTextureView.addRule(13);
            }
            this.addView((View)this.mTextureView, 0, (ViewGroup.LayoutParams)this.lpTextureView);
        }
    }

    private void removeTextureView() {
        this.ivDefault.setVisibility(0);
        if (null != this.mTextureView && this.mTextureView.getParent() != null) {
            this.removeView((View)this.mTextureView);
        }
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        Surface view = new Surface(surface);
        ViDecoder decoder = new ViDecoder();
        decoder.setSurface(view);
        decoder.setDecodeListener(this.viewId, this);
        this.ivDefault.setVisibility(0);
        this.mViDecoder = decoder;
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        GenseeLog.d("GSAutoDecodeView onSurfaceTextureSizeChanged width = " + width + " heigth = " + height);
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        this.mViDecoder.release();
        this.mViDecoder = null;
        return false;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    @Override
    public void onDecodeData(byte[] data, final int width, final int height) {
        if (this.nVideoWidth != width || this.nVideoHeight != height) {
            this.nVideoWidth = width;
            this.nVideoHeight = height;
            this.post(new Runnable(){

                @Override
                public void run() {
                    GSAudoDecodeViewEx.this.calculateSurfaceViewSize(width, height, GSAudoDecodeViewEx.this.getWidth(), GSAudoDecodeViewEx.this.getHeight());
                }
            });
        }
    }

    private void calculateSurfaceViewSize(int nVideoWidth, int nVideoHeight, int nViewWidth, int nViewHeight) {
        if (nVideoWidth <= 0 || nVideoHeight <= 0) {
            return;
        }
        int nLeftMargin = 0;
        int nRightMarign = 0;
        int nTopMargin = 0;
        int nBottomMargin = 0;
        int nNewSurfaceWidth = 0;
        int nNewSurfaceHeight = 0;
        float fWidthRation = (float)nViewWidth / (float)nVideoWidth;
        float fHeightRation = (float)nViewHeight / (float)nVideoHeight;
        switch (this.renderMode) {
            case RM_ADPT_XY: {
                float fRation = Math.min(fWidthRation, fHeightRation);
                nNewSurfaceWidth = (int)((float)nVideoWidth * fRation);
                nNewSurfaceHeight = (int)((float)nVideoHeight * fRation);
                break;
            }
            case RM_FILL_XY: {
                nNewSurfaceWidth = nViewWidth;
                nNewSurfaceHeight = nViewHeight;
                break;
            }
            case RM_CENTER: {
                nNewSurfaceWidth = nVideoWidth;
                nNewSurfaceHeight = nVideoHeight;
                nLeftMargin = nRightMarign = (nViewWidth - nVideoWidth) / 2;
                nTopMargin = nBottomMargin = (nViewHeight - nVideoHeight) / 2;
                break;
            }
            case RM_FILL_CENTER_CROP: {
                float fRation = Math.max(fWidthRation, fHeightRation);
                nNewSurfaceWidth = (int)((float)nVideoWidth * fRation);
                nNewSurfaceHeight = (int)((float)nVideoHeight * fRation);
                nLeftMargin = nRightMarign = (nViewWidth - nNewSurfaceWidth) / 2;
                nTopMargin = nBottomMargin = (nViewHeight - nNewSurfaceHeight) / 2;
            }
        }
        this.lpTextureView = (RelativeLayout.LayoutParams)this.mTextureView.getLayoutParams();
        this.lpTextureView.width = nNewSurfaceWidth;
        this.lpTextureView.height = nNewSurfaceHeight;
        this.lpTextureView.leftMargin = nLeftMargin;
        this.lpTextureView.rightMargin = nRightMarign;
        this.lpTextureView.topMargin = nTopMargin;
        this.lpTextureView.bottomMargin = nBottomMargin;
        this.lpTextureView.addRule(13);
        this.mTextureView.setLayoutParams((ViewGroup.LayoutParams)this.lpTextureView);
    }

    private boolean isRBG565(int datalen, int width, int height) {
        int temWidth = width;
        int nWidthMod = width % 16;
        if (nWidthMod != 0) {
            temWidth += 16 - nWidthMod;
        }
        int temHeight = height;
        int nHeightMod = height % 16;
        if (nHeightMod != 0) {
            temHeight += 16 - nHeightMod;
        }
        return datalen == temWidth * temHeight * 2;
    }

    @Override
    public void onReceiveFrame(byte[] data, int width, int height) {
        if (this.isRBG565(data.length, width, height)) {
            GenseeLog.d("GSAutoDecodeView", "onReceiveFrame rgb565 data, will be return");
            return;
        }
        int frameType = data[4] & 0x1F;
        if ((frameType == 7 || frameType == 8) && this.ivDefault.getVisibility() != 8) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    GSAudoDecodeViewEx.this.ivDefault.setVisibility(8);
                }
            });
        }
        if (null != this.mViDecoder) {
            this.mViDecoder.decode(this.viewId, data, width, height, 0);
        }
    }

    @Override
    public void onReceiveFrame(VideoData data) {
        this.onReceiveFrame(data.getData(), data.getWidth(), data.getHeight());
    }

    @Override
    public void renderDefault() {
        this.removeTextureView();
        this.addTextureView();
    }

    public void setVisibility(int visibility) {
        if (this.mTextureView.getVisibility() != visibility) {
            this.mTextureView.setVisibility(visibility);
            if (visibility == 8) {
                this.removeTextureView();
            } else if (visibility == 0) {
                this.addTextureView();
            }
        }
        super.setVisibility(visibility);
    }

    public void setDefaultImg(int resId) {
        this.ivDefault.setBackgroundResource(resId);
    }

    public void setDefaultImgDrawable(int bgColor, int resId, ImageView.ScaleType scaleType) {
        this.ivDefault.setBackgroundColor(bgColor);
        this.ivDefault.setImageResource(resId);
        this.ivDefault.setScaleType(scaleType);
    }

    protected void onSizeChanged(final int w, final int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                GSAudoDecodeViewEx.this.calculateSurfaceViewSize(GSAudoDecodeViewEx.this.nVideoWidth, GSAudoDecodeViewEx.this.nVideoHeight, w, h);
            }
        }, 50L);
    }
}

