/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.utils.upload;

import android.content.Context;
import android.content.SharedPreferences;
import com.gensee.common.GenseeConfig;
import com.gensee.utils.EmojiTools;
import java.util.HashMap;
import java.util.Map;

public class LogProperty {
    private static final String DEF_DOMAIN = "demo.gensee.com";
    private static final String LOG_PREFERENCE = "gensee.log.preference";
    private static final String LOG_USERNAME = "log_username";
    private static final String LOG_USERID = "log_userid";
    private static final String LOG_SITEID = "log_siteid";
    private static final String LOG_CONFID = "log_confid";
    private static final String LOG_DESC = "log_desc";
    public static final String LOG_UPLOAD_URL = "log_updateurl";
    public static final String LOG_NOTIFY_URL = "log_notifyurl";
    public static final String LOG_DOMAIN = "log_domain";
    private SharedPreferences mPreferences;
    private static LogProperty ins = null;

    public static LogProperty getIns() {
        if (ins == null) {
            ins = new LogProperty();
        }
        return ins;
    }

    public SharedPreferences getPreferences(Context c) {
        if (this.mPreferences == null && c != null) {
            this.mPreferences = c.getApplicationContext().getSharedPreferences(LOG_PREFERENCE, 0);
        }
        return this.mPreferences;
    }

    public LogProperty setProperty(Context context, String userName, String confid, long userId, long siteId, String defDesc, String domain) {
        SharedPreferences mPreferences = this.getPreferences(context);
        if (mPreferences == null) {
            return ins;
        }
        SharedPreferences.Editor e = mPreferences.edit().putString(LOG_USERNAME, userName).putString(LOG_CONFID, confid).putLong(LOG_USERID, userId).putLong(LOG_SITEID, siteId);
        if (defDesc != null) {
            e.putString(LOG_DESC, defDesc);
        }
        if (domain != null) {
            e.putString(LOG_DOMAIN, domain);
        }
        e.commit();
        return ins;
    }

    public LogProperty setProperty(Context context, String uploadUrl, String notifyUrl) {
        SharedPreferences mPreferences = this.getPreferences(context);
        if (mPreferences == null) {
            return ins;
        }
        mPreferences.edit().putString(LOG_UPLOAD_URL, uploadUrl).putString(LOG_NOTIFY_URL, notifyUrl).commit();
        return ins;
    }

    public void setDefDesc(String desc) {
        if (this.mPreferences != null) {
            this.mPreferences.edit().putString(LOG_DESC, desc).commit();
        }
    }

    public String getDomain() {
        if (this.mPreferences != null) {
            return this.mPreferences.getString(LOG_DOMAIN, DEF_DOMAIN);
        }
        return DEF_DOMAIN;
    }

    public Map<String, String> getPropertyList(Context context) {
        SharedPreferences mPreferences = this.getPreferences(context);
        if (mPreferences == null) {
            return null;
        }
        HashMap<String, String> propertyList = new HashMap<String, String>();
        propertyList.put("siteid", mPreferences.getLong(LOG_SITEID, 3L) + "");
        propertyList.put("userid", mPreferences.getLong(LOG_USERID, 0L) + "");
        propertyList.put("confid", mPreferences.getString(LOG_CONFID, ""));
        return propertyList;
    }

    public Map<String, String> getUrls(Context context) {
        SharedPreferences sp = this.getPreferences(context);
        if (sp == null) {
            return null;
        }
        HashMap<String, String> urlList = new HashMap<String, String>();
        urlList.put(LOG_UPLOAD_URL, sp.getString(LOG_UPLOAD_URL, ""));
        urlList.put(LOG_NOTIFY_URL, sp.getString(LOG_NOTIFY_URL, ""));
        return urlList;
    }

    public Map<String, String> getTextList(String desc) {
        String defDesc = "Android " + this.mPreferences.getString(LOG_DESC, "SDK" + GenseeConfig.getSDKVersion());
        desc = desc == null || "".equals(desc) ? defDesc : desc + "," + defDesc;
        desc = EmojiTools.filterEmoji(desc);
        String username = this.mPreferences.getString(LOG_USERNAME, "");
        username = EmojiTools.filterEmoji(username);
        HashMap<String, String> textList = new HashMap<String, String>();
        textList.put("username", username);
        textList.put("desc", desc);
        return textList;
    }
}

