/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.utils.upload;

import android.util.Log;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.StringUtil;
import com.gensee.utils.ThreadPool;
import com.gensee.utils.upload.UploadItem;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class FileUploader {
    private static final int TIME_OUT = 60000;
    private static final String CHARSET = "utf-8";
    private static final String TAG = "FileUploader";
    public static final String NAME_IMAGEKEY = "imageKey";
    public static final String NAME_FILE = "file";
    private OnUploadListener listener;
    private List<UploadItem> items;
    String boundary = UUID.randomUUID().toString();
    String prefix = "--";
    String line_end = "\r\n";
    String content_type = "multipart/form-data";

    private String getStringValue(String name, String value) {
        StringBuffer str = new StringBuffer();
        str.append(this.prefix);
        str.append(this.boundary);
        str.append(this.line_end);
        str.append("Content-Disposition: form-data; name=\"" + name + "\"" + this.line_end);
        str.append(this.line_end);
        str.append(value);
        str.append(this.line_end);
        return str.toString();
    }

    private String getFileValue(String name, String fileName, String contentType) {
        StringBuffer sFileValue = new StringBuffer();
        sFileValue.append(this.prefix);
        sFileValue.append(this.boundary);
        sFileValue.append(this.line_end);
        sFileValue.append("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + fileName + "\"" + this.line_end);
        if (contentType != null) {
            sFileValue.append(contentType + this.line_end);
        }
        sFileValue.append(this.line_end);
        return sFileValue.toString();
    }

    private List<UploadItem> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<UploadItem>(1);
        }
        return this.items;
    }

    public FileUploader addFile(String name, File file) {
        return this.addImageFile(name, file, "application/octet-stream; charset=uft-8");
    }

    public FileUploader addImageFile(String fileKey, File file) {
        String fileName = file.getName();
        String imageType = "png";
        String[] arr = fileName.split("\\.");
        if (arr != null && arr.length == 2) {
            imageType = arr[1];
        }
        return this.addImageFile(fileKey, file, "image/" + imageType);
    }

    public FileUploader addImageFile(String fileKey, File file, String mediaType) {
        UploadItem item = new UploadItem();
        item.setName(fileKey);
        item.setValue(file.getAbsolutePath());
        item.setType("FILE_TYPE");
        item.setContentType("Content-Type: " + mediaType);
        this.getItems().add(item);
        return this;
    }

    public FileUploader addParam(String key, String value) {
        if (NAME_IMAGEKEY.equals(key)) {
            value = value + "_" + String.valueOf(System.currentTimeMillis() / 1000L);
        }
        UploadItem item = new UploadItem();
        item.setName(key);
        item.setValue(value);
        item.setType("VALUE_TYPE");
        this.getItems().add(0, item);
        return this;
    }

    public String upload(String uploadUrl) {
        return this.uploadFile(this.getItems(), uploadUrl);
    }

    public void asynUpload(final String uploadUrl) {
        ThreadPool.getExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                FileUploader.this.upload(uploadUrl);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadFile(List<UploadItem> itemList, String requestURL) {
        requestURL = this.getReqUrl(requestURL);
        String result = "";
        try {
            if (null == itemList || itemList.size() <= 0) {
                String string = "";
                return string;
            }
            URL url = new URL(requestURL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setReadTimeout(60000);
            conn.setConnectTimeout(60000);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Charset", CHARSET);
            conn.setRequestProperty("connection", "keep-alive");
            conn.setRequestProperty("Content-Type", this.content_type + ";boundary=" + this.boundary);
            File file = null;
            for (UploadItem uploadItem : itemList) {
                if (!uploadItem.getType().equals("FILE_TYPE")) continue;
                file = new File(uploadItem.getValue());
                break;
            }
            if (file != null && file.exists()) {
                Log.i((String)TAG, (String)"uploadfile start......");
                String totalString = "";
                for (UploadItem item : itemList) {
                    if (item.getType().equals("VALUE_TYPE")) {
                        totalString = totalString + this.getStringValue(item.getName(), item.getValue());
                        continue;
                    }
                    if (!item.getType().equals("FILE_TYPE")) continue;
                    String sName = file.getName();
                    totalString = totalString + this.getFileValue(item.getName(), sName, item.getContentType());
                }
                byte[] byArray = totalString.getBytes();
                byte[] lineEndBytes = this.line_end.getBytes();
                byte[] end_data = (this.prefix + this.boundary + this.prefix + this.line_end).getBytes();
                long contentLenght = (long)(byArray.length + end_data.length) + file.length() + (long)lineEndBytes.length;
                conn.setRequestProperty("Content-Length", contentLenght + "");
                DataOutputStream dos = new DataOutputStream(conn.getOutputStream());
                dos.write(byArray);
                long curUploadBytes = byArray.length;
                this.updateProgress(curUploadBytes, contentLenght);
                FileInputStream is = new FileInputStream(file);
                byte[] bytes = new byte[1024];
                int len = 0;
                while ((len = ((InputStream)is).read(bytes)) != -1) {
                    dos.write(bytes, 0, len);
                    this.updateProgress(curUploadBytes += (long)len, contentLenght);
                }
                ((InputStream)is).close();
                dos.write(lineEndBytes);
                this.updateProgress(curUploadBytes += (long)lineEndBytes.length, contentLenght);
                dos.write(end_data);
                if (contentLenght != (curUploadBytes += (long)end_data.length)) {
                    GenseeLog.w("it maybe upload error by that contentLenght = " + contentLenght + " curUploadBytes = " + curUploadBytes);
                }
                dos.flush();
                int res = conn.getResponseCode();
                if (res == 200) {
                    this.updateProgress(contentLenght, contentLenght);
                    InputStream input = null;
                    BufferedReader in = null;
                    InputStreamReader inputStreamReader = null;
                    try {
                        String line;
                        input = conn.getInputStream();
                        inputStreamReader = new InputStreamReader(input);
                        in = new BufferedReader(inputStreamReader);
                        StringBuffer sb1 = new StringBuffer();
                        while ((line = in.readLine()) != null) {
                            sb1.append(line);
                        }
                        result = sb1.toString();
                        if (this.listener != null) {
                            this.listener.onUpload(result);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        this.uploadFail();
                    }
                    finally {
                        if (null != in) {
                            in.close();
                        }
                        if (null != inputStreamReader) {
                            inputStreamReader.close();
                        }
                        if (null != input) {
                            input.close();
                        }
                    }
                    GenseeLog.i(TAG, "uploadfile result = " + result);
                }
                GenseeLog.i(TAG, "uploadfile getResponseCode = " + res);
                this.uploadFail();
            }
            GenseeLog.e(TAG, "uploadfile file is not exist! file:" + file + ",upload url:" + requestURL);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            GenseeLog.w(TAG, e);
            this.uploadFail();
        }
        catch (IOException e) {
            e.printStackTrace();
            GenseeLog.w(TAG, e);
            this.uploadFail();
        }
        catch (Exception e) {
            e.printStackTrace();
            GenseeLog.w(TAG, e);
            this.uploadFail();
        }
        finally {
            return result;
        }
    }

    private void updateProgress(long cur, long total) {
        if (this.listener != null) {
            this.listener.onProgress(cur, total);
        }
    }

    private void uploadFail() {
        if (this.listener != null) {
            this.listener.onFail();
        }
    }

    public FileUploader setUploadListener(OnUploadListener listener) {
        this.listener = listener;
        return this;
    }

    protected String getReqUrl(String url) {
        return StringUtil.fixScheme(url);
    }

    public static interface OnUploadListener {
        public void onProgress(long var1, long var3);

        public void onUpload(String var1);

        public void onFail();
    }
}

