/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.utils;

import android.net.Uri;
import com.gensee.common.GenseeConfig;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private static final String mHexStr = "0123456789ABCDEF";

    public static boolean isEmpty(String string) {
        return null == string || "".equals(string);
    }

    public static String filtration(String str) {
        String regEx = "[`~!@#$%^&*()+=|{}:;\\\\[\\\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
        return Pattern.compile(regEx).matcher(str).replaceAll("").trim();
    }

    public static boolean isIPCorrect(String ip) {
        Pattern p = Pattern.compile("((?:(?:25[0-5]|2[0-4]\\d|[01]?\\d?\\d)\\.){3}(?:25[0-5]|2[0-4]\\d|[01]?\\d?\\d))");
        Matcher m = p.matcher(ip);
        return m.matches();
    }

    public static String str2HexStr(String str) {
        return str == null ? "" : StringUtil.bytesToHexString(str.getBytes());
    }

    public static String bytesToHexString(byte[] src) {
        if (src == null || src.length <= 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("");
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static String hexStr2Str(String hexStr) {
        hexStr = hexStr.trim().replace(" ", "").toUpperCase(Locale.US);
        char[] hexs = hexStr.toCharArray();
        byte[] bytes = new byte[hexStr.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            int iTmp = mHexStr.indexOf(hexs[2 * i]) << 4;
            bytes[i] = (byte)((iTmp |= mHexStr.indexOf(hexs[2 * i + 1])) & 0xFF);
        }
        return new String(bytes);
    }

    public static String urlEncode(String source) {
        if (source == null) {
            return "";
        }
        try {
            return URLEncoder.encode(source, "utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getHttpAlbAddr(String alb, String albPort) {
        if (alb != null) {
            String http = "http://";
            if (alb.contains("://")) {
                Uri uri = Uri.parse((String)alb);
                int iPort = uri.getPort();
                String port = "";
                if (iPort == 443 || iPort == 0) {
                    port = "80";
                }
                if (StringUtil.isEmpty(port)) {
                    String string = port = albPort == null ? "" : albPort;
                }
                if (!StringUtil.isEmpty(port)) {
                    port = ":" + port;
                }
                return http + uri.getHost() + port;
            }
            int index = alb.indexOf(58);
            if (index > 0) {
                alb = alb.substring(0, index);
            }
            alb = http + alb;
            if (!StringUtil.isEmpty(albPort)) {
                alb = alb + ":" + albPort;
            }
        }
        return alb;
    }

    public static String urlRemovePortParam(String sourceUrl) {
        return StringUtil.urlRemovePort(sourceUrl, true);
    }

    public static String urlRemovePort(String sourceUrl, boolean isRemoveParam) {
        if (!StringUtil.isEmpty(sourceUrl)) {
            String param;
            Uri uri = Uri.parse((String)sourceUrl);
            String ret = GenseeConfig.getScheme() + uri.getHost() + uri.getPath();
            if (!isRemoveParam && !StringUtil.isEmpty(param = uri.getQuery())) {
                ret = ret + '?' + param;
            }
            return ret;
        }
        return sourceUrl;
    }

    public static String fixUrlScheme(String sourceUrl) {
        if (!StringUtil.isEmpty(sourceUrl)) {
            Uri uri = Uri.parse((String)sourceUrl);
            String ret = GenseeConfig.getScheme() + uri.getHost() + uri.getPath();
            String param = uri.getQuery();
            if (!StringUtil.isEmpty(param)) {
                ret = ret + '?' + param;
            }
            return ret;
        }
        return sourceUrl;
    }

    public static String fixScheme(String sourceUrl) {
        String sc;
        Uri uri;
        if (!StringUtil.isEmpty(sourceUrl) && (uri = Uri.parse((String)sourceUrl)) != null && (sc = uri.getScheme()) != null) {
            sourceUrl = GenseeConfig.getScheme() + sourceUrl.substring(sc.length() + 3, sourceUrl.length());
        }
        return sourceUrl;
    }

    public static String getFirstSpitRet(String src, String reg) {
        if (StringUtil.isEmpty(src) || StringUtil.isEmpty(reg)) {
            return src;
        }
        String[] darr = src.split(reg);
        if (darr != null && darr.length > 0) {
            src = darr[0];
        }
        return src;
    }

    public static long longValue(String strLong) {
        if (StringUtil.isEmpty(strLong)) {
            return 0L;
        }
        try {
            return Long.valueOf(strLong);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static int intValue(String strLong) {
        if (StringUtil.isEmpty(strLong)) {
            return 0;
        }
        try {
            return Integer.valueOf(strLong);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }
}

