/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.gensee.common.GenseeConfig;
import com.gensee.common.ServiceType;
import com.gensee.net.AbsHttpAction;
import com.gensee.net.StringRes;
import com.gensee.report.ReportInfo;
import com.gensee.utils.FileUtil;
import com.gensee.utils.StringUtil;
import com.gensee.utils.ThreadPool;
import com.gensee.utils.upload.FileUploader;
import com.gensee.utils.upload.LogProperty;
import com.gensee.utils.upload.UpLoadFileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@SuppressLint(value={"LogTagMismatch"})
public class GenseeLog {
    public static ReportInfo reportInfo = null;
    private static final String GS_TAG = "Gensee";
    private static final String GS_TAG_DATA = "GS_DATA";
    public static String MYLOG_PATH_SDCARD_DIR = "/sdcard/gensee/log/";
    private static SimpleDateFormat myLogFileNameSdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    private static SimpleDateFormat myLogTimeSdf = new SimpleDateFormat("HH:mm:ss.SSS");
    private static SimpleDateFormat myLogTimeSdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static boolean isWriteTestLog = false;
    private static volatile boolean isInited = false;
    private static boolean isLoadLib = false;
    private static boolean isDebug = true;
    private static final String LOG_INFO = "info-";
    private static final String LOG_APP = "app-";
    private static String LOG_STACK = "stack-";
    private static final String LOG_DIAGNOSE = "And-";
    private static final String LOG_DIAGNOSE_STACK = "stack-And-";
    private static String logInfoFileName = "";
    private static String logAppFileName = "";
    public static String logCrashFileName = "";
    public static String LOG_UPLOAD_DEF_URL = "http://traceupload.gensee.com/traupload";
    private static String LOG_TRACK_UPLOAD_DEF_URL = "https://kibana1.gensee.com/client-lua";
    private JSONArray trackLogList = new JSONArray();
    private JSONArray logUploadCache = new JSONArray();
    private static String curZipDest = "";
    private String confId = "";
    private String userId = "";
    private String userName = "";
    private boolean bindToObj = false;
    private boolean serverRefuseUpload = false;
    public static GenseeLog logEntry;
    public static final String REPORT_NO_FILE = "REPORT_NO_FILE";
    private AbsHttpAction absHttpAction = new AbsHttpAction(null);
    private Handler logHandler = new Handler(Looper.getMainLooper());

    public void setWebcastAndUserInfo(String webcastId, String userID, String userName) {
        this.confId = webcastId;
        this.userId = userID;
        this.userName = userName;
    }

    public static void setLogStackPrefix(String prefix) {
        LOG_STACK = prefix;
    }

    public static void initLog(Context context) {
        GenseeLog.initLog(context, null);
    }

    public static boolean isInited() {
        return isInited;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void initLog(Context context, String fileName) {
        MYLOG_PATH_SDCARD_DIR = FileUtil.getDocumentDir(context, "log");
        File f = new File(MYLOG_PATH_SDCARD_DIR);
        if (!f.exists() && !f.mkdirs()) {
            return;
        }
        FileUtil.deleteFileByTime(f, System.currentTimeMillis(), 259200000L);
        if (isInited || !GenseeLog.loadlibrary()) {
            GenseeLog.i(GenseeConfig.getSDKVersionInfo());
            return;
        }
        logAppFileName = fileName == null ? MYLOG_PATH_SDCARD_DIR + LOG_APP + myLogFileNameSdf.format(new Date()) + ".log" : MYLOG_PATH_SDCARD_DIR + fileName;
        File file = new File(logAppFileName);
        boolean fileOk = false;
        try {
            fileOk = file.createNewFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fileOk) {
                GenseeLog.stdLog(logAppFileName);
            } else {
                GenseeLog.w(logAppFileName + " is open faild");
            }
        }
        isInited = true;
        GenseeLog.i(GenseeConfig.getSDKVersionInfo());
    }

    public static void v(String msg) {
        if (null == msg) {
            return;
        }
        if (GenseeLog.isLoggable(2) || isDebug) {
            Log.v((String)GS_TAG, (String)msg);
        }
        GenseeLog.writeLogtoFile("VERBOSE", GS_TAG, msg);
    }

    public static void v(String TAG, String msg) {
        GenseeLog.v(TAG + "][" + msg);
    }

    public static void d(String msg) {
        if (null == msg) {
            return;
        }
        msg = '[' + msg + ']';
        if (GenseeLog.isLoggable(3) || isDebug) {
            Log.d((String)GS_TAG, (String)msg);
        }
        GenseeLog.writeLogtoFile("D", GS_TAG, msg);
    }

    public static void data(String tag, String msg) {
        if (msg == null || tag == null) {
            return;
        }
        if (Log.isLoggable((String)GS_TAG_DATA, (int)3) || isDebug) {
            msg = '[' + msg + ']';
            Log.d((String)GS_TAG_DATA, (String)msg);
            GenseeLog.writeLogtoFile("D", GS_TAG_DATA, msg);
        }
    }

    public static void trackLog(int level, int code, String tag, String msg) {
        if (logEntry == null) {
            return;
        }
        logEntry.saveTrackLog(level, code, tag, msg);
    }

    private synchronized void saveTrackLog(int level, int code, String tag, String msg) {
        if (msg == null || tag == null) {
            return;
        }
        if (!this.serverRefuseUpload) {
            JSONObject object = new JSONObject();
            try {
                object.put("appName", (Object)"Android-logger");
                object.put("confId", (Object)this.confId);
                object.put("text", (Object)("[" + tag + "][" + msg + "]"));
                object.put("time", (Object)myLogTimeSdf2.format(new Date()));
                object.put("type", (Object)this.getLevelStr(level));
                object.put("userId", (Object)this.userId);
                object.put("userName", (Object)this.userName);
                object.put("code", (Object)("" + code));
            }
            catch (JSONException e) {
                e.printStackTrace();
                GenseeLog.e(e);
            }
            this.trackLogList.put((Object)object);
        }
        switch (level) {
            case 4: {
                GenseeLog.i(tag, msg);
                break;
            }
            case 3: {
                GenseeLog.d(tag, msg);
                break;
            }
            case 5: {
                GenseeLog.w(tag, msg);
                break;
            }
            case 6: {
                GenseeLog.e(tag, msg);
                break;
            }
            default: {
                GenseeLog.i(tag, msg);
            }
        }
    }

    private String getLevelStr(int level) {
        switch (level) {
            case 4: {
                return "INFO";
            }
            case 3: {
                return "DEBUG";
            }
            case 5: {
                return "WARN";
            }
            case 6: {
                return "ERROR";
            }
        }
        return "INFO";
    }

    public static void d(String TAG, String msg) {
        GenseeLog.d(TAG + "][" + msg);
    }

    public static void d(String TAG, String funcName, String msg) {
        GenseeLog.d(TAG, funcName + "][" + msg);
    }

    public static void w(String TAG, String msg) {
        GenseeLog.w(TAG + "][" + msg);
    }

    public static void w(final String TAG, final Throwable e) {
        ThreadPool.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                GenseeLog.w(TAG + "][" + Log.getStackTraceString((Throwable)e));
            }
        });
    }

    public static void w(String msg) {
        if (null == msg) {
            return;
        }
        msg = '[' + msg + ']';
        if (GenseeLog.isLoggable(5) || isDebug) {
            Log.w((String)GS_TAG, (String)msg);
        }
        GenseeLog.writeLogtoFile("W", GS_TAG, msg);
    }

    private static boolean isLoggable(int level) {
        return Log.isLoggable((String)GS_TAG, (int)level);
    }

    public static void e(Throwable e) {
        GenseeLog.e("", e);
    }

    public static void e(final String TAG, final Throwable e) {
        ThreadPool.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                GenseeLog.e(TAG, Log.getStackTraceString((Throwable)e));
            }
        });
    }

    public static void e(String TAG, String msg) {
        GenseeLog.e(TAG + "][" + msg);
    }

    public static void e(String string) {
        if (null == string) {
            return;
        }
        string = '[' + string + ']';
        if (GenseeLog.isLoggable(6) || isDebug) {
            Log.e((String)GS_TAG, (String)string);
        }
        GenseeLog.writeLogtoFile("E", GS_TAG, string);
    }

    public static void i(String TAG, String msg) {
        GenseeLog.i(TAG + "][" + msg);
    }

    public static void i(String string) {
        if (null == string) {
            return;
        }
        if (GenseeLog.isLoggable(4) || isDebug) {
            Log.i((String)GS_TAG, (String)string);
        }
        string = '[' + string + ']';
        GenseeLog.writeLogtoFile("I", GS_TAG, string);
    }

    protected static void writeLogtoFile(final String level, final String tag, final String text) {
        if (!isInited) {
            return;
        }
        if (text == null) {
            return;
        }
        Date nowtime = new Date();
        final String time = myLogTimeSdf.format(nowtime);
        try {
            ThreadPool.getInstance().execute(new Runnable(){

                @Override
                public void run() {
                    StringBuilder sb = new StringBuilder().append('[').append(time).append(']').append('[').append(level).append(']').append('[').append(tag).append(']').append(text).append('\n');
                    GenseeLog.writeLog(sb.toString());
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wirteCrashInfo(String sCrashInfo) {
        logCrashFileName = MYLOG_PATH_SDCARD_DIR + LOG_STACK + myLogFileNameSdf.format(new Date()) + ".log";
        FileOutputStream stream = null;
        File path = new File(MYLOG_PATH_SDCARD_DIR);
        File file = new File(logCrashFileName);
        if (!path.exists()) {
            path.mkdirs();
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            stream = new FileOutputStream(logCrashFileName);
            stream.write(sCrashInfo.getBytes());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != stream) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeAppInfo(String sJsonInfo) {
        logInfoFileName = MYLOG_PATH_SDCARD_DIR + LOG_INFO + myLogFileNameSdf.format(new Date()) + ".log";
        FileOutputStream stream = null;
        File path = new File(MYLOG_PATH_SDCARD_DIR);
        File file = new File(logInfoFileName);
        if (!path.exists() && !path.mkdirs()) {
            return;
        }
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    return;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        try {
            stream = new FileOutputStream(logInfoFileName);
            stream.write(sJsonInfo.getBytes());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != stream) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean containsStackFile() {
        File[] entries;
        boolean bStackFile = false;
        File fileOrDirectory = new File(MYLOG_PATH_SDCARD_DIR);
        if (fileOrDirectory.exists() && (entries = fileOrDirectory.listFiles()) != null && entries.length > 0) {
            for (int i = 0; i < entries.length; ++i) {
                File file = entries[i];
                if (!file.isFile() || !file.getName().startsWith(LOG_STACK)) continue;
                bStackFile = true;
                break;
            }
        }
        return bStackFile;
    }

    public static boolean containsZipStackFile() {
        File[] entries;
        boolean bZipStackFile = false;
        File fileOrDirectory = new File(MYLOG_PATH_SDCARD_DIR);
        if (fileOrDirectory.exists() && (entries = fileOrDirectory.listFiles()) != null && entries.length > 0) {
            for (int i = 0; i < entries.length; ++i) {
                File file = entries[i];
                if (!file.isFile() || !file.getName().startsWith(LOG_DIAGNOSE_STACK)) continue;
                bZipStackFile = true;
                break;
            }
        }
        return bZipStackFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFile(boolean isZipCurLog, String siteId, String liveId, String userId, String userNickName) {
        try {
            GenseeLog.flush();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        userNickName = StringUtil.filtration(userNickName);
        curZipDest = MYLOG_PATH_SDCARD_DIR + LOG_DIAGNOSE + siteId + "-" + liveId + "-" + userId + "-" + userNickName + "-" + myLogFileNameSdf.format(new Date()) + ".zip";
        if (GenseeLog.containsStackFile()) {
            curZipDest = MYLOG_PATH_SDCARD_DIR + LOG_DIAGNOSE_STACK + siteId + "-" + liveId + "-" + userId + "-" + userNickName + "-" + myLogFileNameSdf.format(new Date()) + ".zip";
        }
        ZipOutputStream out = null;
        try {
            File[] entries;
            File fileOrDirectory = new File(MYLOG_PATH_SDCARD_DIR);
            if (fileOrDirectory.exists() && (entries = fileOrDirectory.listFiles()) != null && entries.length > 0) {
                ArrayList<File> deleteFileList = new ArrayList<File>();
                for (int i = 0; i < entries.length; ++i) {
                    File file = entries[i];
                    if (!file.isFile() || !file.getName().startsWith(LOG_INFO) && !file.getName().startsWith(LOG_APP) && !file.getName().startsWith(LOG_STACK)) continue;
                    if (file.getName().startsWith(LOG_STACK) && !file.getAbsolutePath().equals(logCrashFileName)) {
                        if (null == out) {
                            out = new ZipOutputStream(new FileOutputStream(curZipDest));
                        }
                        FileUtil.zip(entries[i], out);
                        deleteFileList.add(file);
                        continue;
                    }
                    if (file.getName().startsWith(LOG_INFO)) {
                        if (file.getAbsolutePath().equals(logInfoFileName)) {
                            if (!isZipCurLog) continue;
                            if (null == out) {
                                out = new ZipOutputStream(new FileOutputStream(curZipDest));
                            }
                            FileUtil.zip(entries[i], out);
                            continue;
                        }
                        if (null == out) {
                            out = new ZipOutputStream(new FileOutputStream(curZipDest));
                        }
                        FileUtil.zip(entries[i], out);
                        deleteFileList.add(file);
                        continue;
                    }
                    if (!file.getName().startsWith(LOG_APP)) continue;
                    if (file.getAbsolutePath().equals(logAppFileName)) {
                        if (!isZipCurLog) continue;
                        if (null == out) {
                            out = new ZipOutputStream(new FileOutputStream(curZipDest));
                        }
                        FileUtil.zip(entries[i], out);
                        continue;
                    }
                    if (null == out) {
                        out = new ZipOutputStream(new FileOutputStream(curZipDest));
                    }
                    FileUtil.zip(entries[i], out);
                    deleteFileList.add(file);
                }
                for (File file : deleteFileList) {
                    file.delete();
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private static String reportDiagonse(File uploadFile, String uploadUrl) {
        String url = new FileUploader().addFile("file1", uploadFile).addParam("submit", "Upload").addParam("test", "value").upload(uploadUrl);
        if (url != null && !"".equals(url)) {
            uploadFile.delete();
        }
        return url;
    }

    public static String reportDiagonse(Context context, String desc, ServiceType serviceType, boolean isZipCurLog) {
        List<ReportResult> ret = GenseeLog.reportDiagonse(context, LogProperty.getIns().getDomain(), serviceType, desc, isZipCurLog);
        if (ret == null || ret.size() == 0) {
            return REPORT_NO_FILE;
        }
        return ret.get(0).getUrl();
    }

    public static List<ReportResult> reportDiagonse(Context context, String domain, ServiceType serviceType, String desc, boolean isZipCurLog) {
        if (StringUtil.isEmpty(domain)) {
            GenseeLog.e("GenseeLog", "reportDiagonse error ,Domain is empty:" + domain);
            return null;
        }
        return GenseeLog.reportDiagonse(context, domain, serviceType, desc, isZipCurLog, true, false);
    }

    public static List<ReportResult> reportDiagonse(Context context, String domain, ServiceType serviceType, String desc, boolean isZipCurLog, boolean isZipFile, boolean isOnlyUploadCurLog) {
        Map<String, String> datas = LogProperty.getIns().getPropertyList(context);
        if (isZipFile) {
            Map<String, String> texts;
            String siteId = "";
            String liveId = "";
            String userId = "";
            String nickName = "";
            if (null != datas) {
                String string = siteId = null == datas.get("siteid") ? "" : datas.get("siteid");
                if (siteId.equals("0")) {
                    siteId = "";
                }
                String string2 = userId = null == datas.get("userid") ? "" : datas.get("userid");
                if (userId.equals("0")) {
                    userId = "";
                }
                String string3 = liveId = null == datas.get("confid") ? "" : datas.get("confid");
            }
            if (null != (texts = LogProperty.getIns().getTextList(""))) {
                nickName = null == texts.get("username") ? "" : texts.get("username");
            }
            GenseeLog.zipFile(isZipCurLog, siteId, liveId, userId, nickName);
        }
        String uploadUrl = LOG_UPLOAD_DEF_URL;
        String notifyUrl = GenseeConfig.getScheme() + domain + "/clientapi/apichannel";
        Map<String, String> urls = LogProperty.getIns().getUrls(context);
        if (urls != null) {
            String resNotifyUrl;
            String resUploadUrl = urls.get("log_updateurl");
            if (!StringUtil.isEmpty(resUploadUrl)) {
                uploadUrl = StringUtil.urlRemovePort(resUploadUrl, false);
            }
            if (!StringUtil.isEmpty(resNotifyUrl = urls.get("log_notifyurl"))) {
                notifyUrl = StringUtil.urlRemovePortParam(resNotifyUrl);
            }
        }
        int sc = 0;
        switch (serviceType) {
            case TRAINING: 
            case ST_TRAINING: {
                sc = 1;
                break;
            }
            case WEBCAST: 
            case ST_CASTLINE: {
                sc = 0;
                break;
            }
            case ST_MEETING: {
                sc = 2;
                break;
            }
        }
        return GenseeLog.reportDiagonse(uploadUrl, notifyUrl + "?sc=" + sc, datas, LogProperty.getIns().getTextList(desc), false, isOnlyUploadCurLog);
    }

    public static String rtReport(String uploadUrl, String notifyWebUrl, Map<String, String> propertyList, Map<String, String> textList, boolean bOnlyStatck, boolean isOnlyUploadCurLog) {
        List<ReportResult> ret = GenseeLog.reportDiagonse(uploadUrl, notifyWebUrl, propertyList, textList, bOnlyStatck, isOnlyUploadCurLog);
        if (ret == null || ret.size() == 0) {
            return REPORT_NO_FILE;
        }
        return ret.get(0).getUrl();
    }

    private static List<ReportResult> reportDiagonse(String uploadUrl, String notifyWebUrl, Map<String, String> propertyList, Map<String, String> textList, boolean bOnlyStatck, boolean isOnlyUploadCurLog) {
        String ret = "";
        ArrayList<ReportResult> results = new ArrayList<ReportResult>();
        if (isOnlyUploadCurLog) {
            File file;
            if (!"".equals(curZipDest) && (file = new File(curZipDest)).exists()) {
                results.add(GenseeLog.uploadAndNotify(file, uploadUrl, notifyWebUrl, propertyList, textList));
            }
            return results;
        }
        File fileOrDirectory = new File(MYLOG_PATH_SDCARD_DIR);
        if (fileOrDirectory.exists()) {
            File[] entries = fileOrDirectory.listFiles();
            Object file = null;
            if (null != entries && entries.length > 0) {
                for (int i = 0; i < entries.length; ++i) {
                    File tmpFile = entries[i];
                    if (bOnlyStatck) {
                        if (!tmpFile.getName().startsWith(LOG_DIAGNOSE_STACK)) continue;
                        results.add(GenseeLog.uploadAndNotify(tmpFile, uploadUrl, notifyWebUrl, propertyList, textList));
                        continue;
                    }
                    if (!tmpFile.getName().startsWith(LOG_DIAGNOSE) && !tmpFile.getName().startsWith(LOG_DIAGNOSE_STACK)) continue;
                    results.add(GenseeLog.uploadAndNotify(tmpFile, uploadUrl, notifyWebUrl, propertyList, textList));
                }
            }
        }
        return results;
    }

    private static ReportResult uploadAndNotify(File file, String uploadUrl, String notifyWebUrl, Map<String, String> propertyList, Map<String, String> textList) {
        ReportResult result = new ReportResult();
        String url = GenseeLog.reportDiagonse(file, uploadUrl);
        result.setFile(file.getName());
        result.setUrl(url);
        if (TextUtils.isEmpty((CharSequence)notifyWebUrl)) {
            return result;
        }
        if (!"".equals(url) && null != notifyWebUrl && !"".equals(notifyWebUrl) && null != propertyList && null != textList) {
            textList.put("file", url);
            String ret = new UpLoadFileUtil().notifyWeb(notifyWebUrl, propertyList, textList);
            result.setNotifyRet(ret);
        }
        return result;
    }

    private static synchronized native void stdLog(String var0);

    private static native void writeLog(String var0);

    public static native void flush();

    public static native void crashTest();

    private static boolean loadlibrary() {
        try {
            System.loadLibrary("stlport_shared");
            System.loadLibrary("gensee-log");
            isLoadLib = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            GenseeLog.w("GenseeLog", e);
        }
        catch (Error e) {
            e.printStackTrace();
            GenseeLog.w("GenseeLog", e);
        }
        return isLoadLib;
    }

    public static void setLogEntry(GenseeLog log) {
        logEntry = log;
        GenseeLog.logEntry.bindToObj = true;
    }

    public static void clearLogEntry() {
        Log.i((String)GS_TAG, (String)"clearLogEntry: ");
        if (logEntry != null) {
            GenseeLog.logEntry.bindToObj = false;
        }
        logEntry = null;
    }

    public void startUploadTrackLog() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                GenseeLog.this.logHandler.postDelayed((Runnable)this, 5000L);
                if (GenseeLog.this.trackLogList.length() == 0) {
                    GenseeLog.i("There is no log data to upload currently.");
                    if (!GenseeLog.this.bindToObj) {
                        GenseeLog.this.endUploadTrackLog();
                    }
                    return;
                }
                String data = GenseeLog.this.getLogDataStr();
                HashMap<String, String> header = new HashMap<String, String>();
                header.put("Content-Type", "application/json");
                GenseeLog.this.absHttpAction.doPostRequest(LOG_TRACK_UPLOAD_DEF_URL, data, header, new StringRes(){

                    @Override
                    public void onRes(String result) {
                        try {
                            JSONObject object = new JSONObject(result);
                            if (object.getInt("rate") == -1) {
                                GenseeLog.w(GenseeLog.GS_TAG, "server refuse upload log.");
                                GenseeLog.this.serverRefuseUpload = true;
                                GenseeLog.this.endUploadTrackLog();
                            } else {
                                GenseeLog.i("GenseeLog", "Log upload successful. Currently, there are " + GenseeLog.this.trackLogList.length() + " logs pending upload");
                                if (GenseeLog.this.trackLogList.length() == 0 && !GenseeLog.this.bindToObj) {
                                    GenseeLog.this.endUploadTrackLog();
                                }
                            }
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            GenseeLog.e(e);
                        }
                    }

                    @Override
                    public void onConnectError(int errorType, String errorInfo) {
                        GenseeLog.e(GenseeLog.GS_TAG, "upload log error :" + errorInfo);
                        try {
                            if (GenseeLog.this.logUploadCache.length() > 0) {
                                GenseeLog.e(GenseeLog.GS_TAG, "re upload log size:" + GenseeLog.this.logUploadCache.length());
                                for (int i = 0; i < GenseeLog.this.logUploadCache.length(); ++i) {
                                    GenseeLog.this.trackLogList.put(i, GenseeLog.this.logUploadCache.get(i));
                                }
                            }
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            GenseeLog.e(e);
                        }
                    }
                });
            }
        };
        this.logHandler.postDelayed(runnable, 5000L);
    }

    private synchronized String getLogDataStr() {
        JSONObject object = new JSONObject();
        try {
            if (this.trackLogList.length() > 200) {
                JSONArray subList = new JSONArray();
                for (int i = 0; i < 200; ++i) {
                    subList.put(this.trackLogList.get(i));
                }
                object.put("msg", (Object)subList);
                this.logUploadCache = subList;
                JSONArray newTrackLogList = new JSONArray();
                for (int i = 200; i < this.trackLogList.length(); ++i) {
                    newTrackLogList.put(this.trackLogList.get(i));
                }
                this.trackLogList = newTrackLogList;
            } else {
                object.put("msg", (Object)this.trackLogList);
                this.trackLogList = new JSONArray();
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            GenseeLog.e(e);
        }
        Log.i((String)"TAG", (String)("getLogDataStr: " + object.toString()));
        return object.toString();
    }

    public void endUploadTrackLog() {
        this.logHandler.removeCallbacksAndMessages(null);
    }

    static {
        GenseeLog.loadlibrary();
    }

    public static class ReportResult {
        private String file;
        private String url;
        private String notifyRet = "";

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getNotifyRet() {
            return this.notifyRet;
        }

        public void setNotifyRet(String notifyRet) {
            this.notifyRet = notifyRet;
        }
    }

    private static class WiteRunnable
    implements Runnable {
        private RandomAccessFile file;
        private String msg;

        private WiteRunnable() {
        }

        @Override
        public void run() {
            if (this.file == null) {
                try {
                    this.file = new RandomAccessFile("/sdcard/genseelog.log", "rw");
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
            if (this.file != null && this.msg != null) {
                try {
                    this.file.writeBytes(this.msg + "\n");
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }
}

