/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.utils;

import android.text.TextUtils;

public class EmojiTools {
    public static boolean containsEmoji(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            int cp = str.codePointAt(i);
            if (!EmojiTools.isEmojiCharacter(cp)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEmojiCharacter(int first) {
        return first != 0 && first != 9 && first != 10 && first != 13 && (first < 32 || first > 55295) && (first < 57344 || first > 65533) && first < 65536 || first == 169 || first == 174 || first == 8482 || first == 12336 || first >= 9654 && first <= 10175 || first == 9000 || first >= 9193 && first <= 9210 || first >= 126976 && first <= 131071 || first >= 9986 && first <= 10160 || first >= 128513 && first <= 128591;
    }

    public static String filterEmoji(String str) {
        if (!EmojiTools.containsEmoji(str)) {
            return str;
        }
        StringBuilder buf = null;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char codePoint = str.charAt(i);
            if (EmojiTools.isEmojiCharacter(codePoint)) continue;
            if (buf == null) {
                buf = new StringBuilder(str.length());
            }
            buf.append(codePoint);
        }
        if (buf == null) {
            return "";
        }
        return buf.toString();
    }
}

