/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.utils;

import com.gensee.utils.StringUtil;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Random;

public class DateUtil {
    public static Date getNowDate() {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
        String dateString = formatter.format(currentTime);
        ParsePosition pos = new ParsePosition(8);
        Date currentTime_2 = formatter.parse(dateString, pos);
        return currentTime_2;
    }

    public static Date getNowDateShort() {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
        String dateString = formatter.format(currentTime);
        ParsePosition pos = new ParsePosition(8);
        Date currentTime_2 = formatter.parse(dateString, pos);
        return currentTime_2;
    }

    public static String getStringDate() {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
        String dateString = formatter.format(currentTime);
        return dateString;
    }

    public static String getStringDateShort() {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
        String dateString = formatter.format(currentTime);
        return dateString;
    }

    public static String getStringDateShort(long questTime) {
        Date date = new Date(questTime * 1000L);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
        String dateString = formatter.format(date);
        return dateString;
    }

    public static String getTimeShort() {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss", Locale.ENGLISH);
        Date currentTime = new Date();
        String dateString = formatter.format(currentTime);
        return dateString;
    }

    public static String getTimeShort(long time) {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm", Locale.ENGLISH);
        Date date = new Date(time * 1000L);
        String dateString = formatter.format(date);
        return dateString;
    }

    public static Date strToDateLong(String strDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ParsePosition pos = new ParsePosition(0);
        return strDate == null ? null : formatter.parse(strDate, pos);
    }

    public static String dateToStrLong(Date dateDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(dateDate);
        return dateString;
    }

    public static String dateToStr(Date dateDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(dateDate);
        return dateString;
    }

    public static Date strToDate(String strDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(strDate, pos);
        return strtodate;
    }

    public static Date getNow() {
        Date currentTime = new Date();
        return currentTime;
    }

    public static Date getLastDate(long day) {
        Date date = new Date();
        long date_3_hm = date.getTime() - 122400000L * day;
        Date date_3_hm_date = new Date(date_3_hm);
        return date_3_hm_date;
    }

    public static String getStringToday() {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd HHmmss");
        String dateString = formatter.format(currentTime);
        return dateString;
    }

    public static String getHour() {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(currentTime);
        String hour = dateString.substring(11, 13);
        return hour;
    }

    public static String getTime() {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(currentTime);
        String min = dateString.substring(14, 16);
        return min;
    }

    public static String getUserDate(String sformat) {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat(sformat);
        String dateString = formatter.format(currentTime);
        return dateString;
    }

    public static String getTwoHour(String st1, String st2) {
        double u;
        String[] kk = null;
        String[] jj = null;
        kk = st1.split(":");
        jj = st2.split(":");
        if (Integer.parseInt(kk[0]) < Integer.parseInt(jj[0])) {
            return "0";
        }
        double y = Double.parseDouble(kk[0]) + Double.parseDouble(kk[1]) / 60.0;
        if (y - (u = Double.parseDouble(jj[0]) + Double.parseDouble(jj[1]) / 60.0) > 0.0) {
            return y - u + "";
        }
        return "0";
    }

    public static String getTwoDay(String sj1, String sj2) {
        SimpleDateFormat myFormatter = new SimpleDateFormat("yyyy-MM-dd");
        long day = 0L;
        try {
            Date date = myFormatter.parse(sj1);
            Date mydate = myFormatter.parse(sj2);
            day = (date.getTime() - mydate.getTime()) / 86400000L;
        }
        catch (Exception e) {
            return "";
        }
        return day + "";
    }

    public static String getPreTime(String sj1, String jj) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String mydate1 = "";
        try {
            Date date1 = format.parse(sj1);
            long Time = date1.getTime() / 1000L + (long)(Integer.parseInt(jj) * 60);
            date1.setTime(Time * 1000L);
            mydate1 = format.format(date1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mydate1;
    }

    public static String getNextDay(String nowdate, String delay) {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            String mdate = "";
            Date d = DateUtil.strToDate(nowdate);
            long myTime = d.getTime() / 1000L + (long)(Integer.parseInt(delay) * 24 * 60 * 60);
            d.setTime(myTime * 1000L);
            mdate = format.format(d);
            return mdate;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static boolean isLeapYear(String ddate) {
        Date d = DateUtil.strToDate(ddate);
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(d);
        int year = gc.get(1);
        if (year % 400 == 0) {
            return true;
        }
        if (year % 4 == 0) {
            return year % 100 != 0;
        }
        return false;
    }

    public static String getEDate(String str) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(str, pos);
        String j = strtodate.toString();
        String[] k = j.split(" ");
        return k[2] + k[1].toUpperCase() + k[5].substring(2, 4);
    }

    public static String getEndDateOfMonth(String dat) {
        String str = dat.substring(0, 8);
        String month = dat.substring(5, 7);
        int mon = Integer.parseInt(month);
        str = mon == 1 || mon == 3 || mon == 5 || mon == 7 || mon == 8 || mon == 10 || mon == 12 ? str + "31" : (mon == 4 || mon == 6 || mon == 9 || mon == 11 ? str + "30" : (DateUtil.isLeapYear(dat) ? str + "29" : str + "28"));
        return str;
    }

    public static boolean isSameWeekDates(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        int subYear = cal1.get(1) - cal2.get(1);
        return 0 == subYear ? cal1.get(3) == cal2.get(3) : (1 == subYear && 11 == cal2.get(2) ? cal1.get(3) == cal2.get(3) : -1 == subYear && 11 == cal1.get(2) && cal1.get(3) == cal2.get(3));
    }

    public static String getSeqWeek() {
        Calendar c = Calendar.getInstance(Locale.CHINA);
        String week = Integer.toString(c.get(3));
        if (week.length() == 1) {
            week = "0" + week;
        }
        String year = Integer.toString(c.get(1));
        return year + week;
    }

    public static String getWeek(String sdate, String num) {
        Date dd = DateUtil.strToDate(sdate);
        Calendar c = Calendar.getInstance();
        c.setTime(dd);
        if (num.equals("1")) {
            c.set(7, 2);
        } else if (num.equals("2")) {
            c.set(7, 3);
        } else if (num.equals("3")) {
            c.set(7, 4);
        } else if (num.equals("4")) {
            c.set(7, 5);
        } else if (num.equals("5")) {
            c.set(7, 6);
        } else if (num.equals("6")) {
            c.set(7, 7);
        } else if (num.equals("0")) {
            c.set(7, 1);
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(c.getTime());
    }

    public static String getWeek(String sdate) {
        Date date = DateUtil.strToDate(sdate);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return new SimpleDateFormat("EEEE").format(c.getTime());
    }

    public static String getWeekStr(String sdate) {
        String str = "";
        str = DateUtil.getWeek(sdate);
        if ("1".equals(str)) {
            str = "\u661f\u671f\u65e5";
        } else if ("2".equals(str)) {
            str = "\u661f\u671f\u4e00";
        } else if ("3".equals(str)) {
            str = "\u661f\u671f\u4e8c";
        } else if ("4".equals(str)) {
            str = "\u661f\u671f\u4e09";
        } else if ("5".equals(str)) {
            str = "\u661f\u671f\u56db";
        } else if ("6".equals(str)) {
            str = "\u661f\u671f\u4e94";
        } else if ("7".equals(str)) {
            str = "\u661f\u671f\u516d";
        }
        return str;
    }

    public static long getDays(String date1, String date2) {
        if (date1 == null || date1.equals("")) {
            return 0L;
        }
        if (date2 == null || date2.equals("")) {
            return 0L;
        }
        SimpleDateFormat myFormatter = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        Date mydate = null;
        try {
            date = myFormatter.parse(date1);
            mydate = myFormatter.parse(date2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        long day = (date.getTime() - mydate.getTime()) / 86400000L;
        return day;
    }

    public static String getNowMonth(String sdate) {
        sdate = sdate.substring(0, 8) + "01";
        Date date = DateUtil.strToDate(sdate);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int u = c.get(7);
        String newday = DateUtil.getNextDay(sdate, 1 - u + "");
        return newday;
    }

    public static String getNo(int k) {
        return DateUtil.getUserDate("yyyyMMddhhmmss") + DateUtil.getRandom(k);
    }

    public static String getRandom(int i) {
        Random jjj = new Random();
        if (i == 0) {
            return "";
        }
        String jj = "";
        for (int k = 0; k < i; ++k) {
            jj = jj + jjj.nextInt(9);
        }
        return jj;
    }

    public static boolean RightDate(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        if (date == null) {
            return false;
        }
        sdf = date.length() > 10 ? new SimpleDateFormat("yyyy-MM-dd hh:mm:ss") : new SimpleDateFormat("yyyy-MM-dd");
        try {
            sdf.parse(date);
        }
        catch (ParseException pe) {
            return false;
        }
        return true;
    }

    public static long utcTimeToLocal(String utcTime) {
        if (StringUtil.isEmpty(utcTime)) {
            return 0L;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Calendar calendar = Calendar.getInstance();
            long m_timezoneOffset = calendar.get(15) + calendar.get(16);
            return utcTime == null ? 0L : formatter.parse(utcTime).getTime() + m_timezoneOffset;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }
}

