/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.IAppController;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

public class AppExceptionHandler
implements Thread.UncaughtExceptionHandler {
    public static final String TAG = "ExceptionHandler";
    private Thread.UncaughtExceptionHandler mDefaultHandler;
    private Map<String, String> infos = new HashMap<String, String>();
    private DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
    private IAppController appController;

    public AppExceptionHandler() {
        this.mDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();
    }

    public void init(IAppController appController) {
        Thread.setDefaultUncaughtExceptionHandler(this);
        this.appController = appController;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        if (!this.handleException(ex) && this.mDefaultHandler != null) {
            this.mDefaultHandler.uncaughtException(thread, ex);
        } else {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Log.e((String)TAG, (String)"error : ", (Throwable)e);
            }
            if (this.appController != null) {
                this.appController.restartApp();
            }
        }
    }

    private boolean handleException(Throwable ex) {
        if (ex == null) {
            return false;
        }
        GenseeLog.w(TAG, Log.getStackTraceString((Throwable)ex));
        this.saveCrashInfo2File(ex);
        return true;
    }

    public void collectDeviceInfo(Context ctx) {
        Field[] fields;
        try {
            PackageManager pm = ctx.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(ctx.getPackageName(), 1);
            if (pi != null) {
                String versionName = pi.versionName == null ? "null" : pi.versionName;
                String versionCode = pi.versionCode + "";
                this.infos.put("versionName", versionName);
                this.infos.put("versionCode", versionCode);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)"an error occured when collect package info", (Throwable)e);
        }
        for (Field field : fields = Build.class.getDeclaredFields()) {
            try {
                field.setAccessible(true);
                this.infos.put(field.getName(), field.get(null).toString());
                Log.d((String)TAG, (String)(field.getName() + " : " + field.get(null)));
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"an error occured when collect crash info", (Throwable)e);
            }
        }
    }

    private void saveCrashInfo2File(Throwable ex) {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, String> entry : this.infos.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            sb.append(key + "=" + value + "\n");
        }
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        ex.printStackTrace(printWriter);
        for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
            cause.printStackTrace(printWriter);
        }
        printWriter.close();
        String result = ((Object)writer).toString();
        sb.append(result);
        sb.append("os.version=" + Build.MODEL + "," + Build.VERSION.SDK_INT + "," + Build.VERSION.RELEASE);
        try {
            GenseeLog.wirteCrashInfo(sb.toString());
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"an error occured while writing file...", (Throwable)e);
        }
    }
}

