/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.user;

import com.gensee.routine.UserInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class UserManager {
    private static UserManager ins = null;
    private ReentrantReadWriteLock userLock = new ReentrantReadWriteLock();
    private UpdateUserInterface updateUserInterface;
    private HashMap<Long, UserInfo> userMap = new HashMap(8);
    private UserInfo localInfo;
    private int nUserCount;

    private UserManager() {
    }

    public void seUpdateUserInterface(UpdateUserInterface updateUserInterface) {
        this.updateUserInterface = updateUserInterface;
    }

    private void updateUserView() {
        if (null != this.updateUserInterface) {
            this.updateUserInterface.updateUserView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UserManager getIns() {
        if (ins != null) return ins;
        Class<UserManager> clazz = UserManager.class;
        synchronized (UserManager.class) {
            if (null != ins) return ins;
            ins = new UserManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ins;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userJoin(UserInfo user, long localUserId) {
        if (user == null) {
            return;
        }
        this.userLock.writeLock().lock();
        try {
            UserInfo oldUser;
            long userId = user.getId();
            if (localUserId == userId) {
                this.localInfo = user;
            }
            if ((oldUser = this.userMap.get(userId)) == null) {
                this.userMap.put(userId, user);
            } else {
                oldUser.copyUser(user);
            }
        }
        finally {
            this.userLock.writeLock().unlock();
        }
        this.updateUserView();
    }

    public void userLeave(long userId) {
        this.userLock.writeLock().lock();
        try {
            this.userMap.remove(userId);
        }
        finally {
            this.userLock.writeLock().unlock();
        }
        this.updateUserView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userUpdate(UserInfo user, int updateFlag) {
        this.userLock.writeLock().lock();
        try {
            UserInfo oldUser = this.userMap.get(user.getId());
            if (oldUser != null) {
                oldUser.copyUser(user);
            }
        }
        finally {
            this.userLock.writeLock().unlock();
        }
        this.updateUserView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UserInfo> getStudentUserList() {
        ArrayList<UserInfo> returnList = new ArrayList<UserInfo>();
        this.userLock.readLock().lock();
        try {
            Set<Map.Entry<Long, UserInfo>> sets = this.userMap.entrySet();
            for (Map.Entry<Long, UserInfo> set : sets) {
                UserInfo user = set.getValue();
                if (user.isHost() || user.isAssistant() || user.isPresenter()) continue;
                returnList.add(user);
            }
        }
        finally {
            this.userLock.readLock().unlock();
        }
        return returnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UserInfo> getUserList() {
        ArrayList<UserInfo> returnList = new ArrayList<UserInfo>();
        this.userLock.readLock().lock();
        try {
            Set<Map.Entry<Long, UserInfo>> sets = this.userMap.entrySet();
            for (Map.Entry<Long, UserInfo> set : sets) {
                returnList.add(set.getValue());
            }
        }
        finally {
            this.userLock.readLock().unlock();
        }
        return returnList;
    }

    public List<UserInfo> getSortUserList() {
        List<UserInfo> userList = this.getUserList();
        Collections.sort(userList, new ComparatorSortUtil());
        return userList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserInfo getUserByUserId(long userId) {
        UserInfo user = null;
        this.userLock.readLock().lock();
        try {
            user = this.userMap.get(userId);
        }
        finally {
            this.userLock.readLock().unlock();
        }
        return user;
    }

    public String getUserNameByUserId(long userId) {
        UserInfo info = this.getUserByUserId(userId);
        if (info != null) {
            return info.getName();
        }
        return "";
    }

    public void clear() {
        this.userLock.writeLock().lock();
        try {
            this.userMap.clear();
            this.nUserCount = 0;
        }
        finally {
            this.userLock.writeLock().unlock();
        }
    }

    public UserInfo getMyUserInfo() {
        return this.localInfo;
    }

    public boolean isHost() {
        return this.localInfo != null && this.localInfo.isHost();
    }

    public boolean isPanlist() {
        return this.localInfo != null && this.localInfo.IsPanelist();
    }

    public boolean isHandUp() {
        return this.localInfo != null && this.localInfo.IsHandup();
    }

    public String getLocalName() {
        return this.localInfo == null ? "" : this.localInfo.getName();
    }

    public int getUserCount() {
        int count = 0;
        this.userLock.writeLock().lock();
        try {
            count = this.nUserCount > 0 ? this.nUserCount : this.userMap.size();
        }
        finally {
            this.userLock.writeLock().unlock();
        }
        return count;
    }

    public void setUserCount(int nCount) {
        this.userLock.writeLock().lock();
        try {
            this.nUserCount = nCount;
        }
        finally {
            this.userLock.writeLock().unlock();
        }
    }

    public boolean isRtUser(long id) {
        UserInfo user = this.getUserByUserId(id);
        return user != null && (user.IsAndroidPadClient() || user.IsAndroidPhoneClient() || user.IsIPadClient() || user.IsMacClient() || user.IsPcClient() || user.IsIPhoneClient());
    }

    private class ComparatorSortUtil
    implements Comparator<UserInfo> {
        private ComparatorSortUtil() {
        }

        @Override
        public int compare(UserInfo lhs, UserInfo rhs) {
            boolean rIsHandUp;
            boolean lIsHandUp;
            if (lhs.isHost()) {
                return -1;
            }
            if (rhs.isHost()) {
                return 1;
            }
            if (lhs.isPresenter()) {
                return -1;
            }
            if (rhs.isPresenter()) {
                return 1;
            }
            if (lhs.IsPanelist()) {
                return -1;
            }
            if (rhs.IsPanelist()) {
                return 1;
            }
            if (null != UserManager.this.localInfo) {
                if (lhs.getId() == UserManager.this.localInfo.getId()) {
                    return -1;
                }
                if (rhs.getId() == UserManager.this.localInfo.getId()) {
                    return 1;
                }
            }
            if ((lIsHandUp = lhs.IsHandup()) != (rIsHandUp = rhs.IsHandup())) {
                if (lIsHandUp) {
                    return -1;
                }
                if (rIsHandUp) {
                    return 1;
                }
            }
            if (lhs.IsAttendee()) {
                return -1;
            }
            if (rhs.IsAttendee()) {
                return 1;
            }
            if (lhs.IsAttendeeWeb()) {
                return -1;
            }
            if (rhs.IsAttendeeWeb()) {
                return 1;
            }
            if (lhs.IsLodUser()) {
                return -1;
            }
            if (rhs.IsLodUser()) {
                return 1;
            }
            return lhs.getName().compareTo(rhs.getName());
        }
    }

    public static interface UpdateUserInterface {
        public void updateUserView();
    }
}

