/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.texture;

import com.gensee.utils.GenseeLog;
import java.util.concurrent.ConcurrentLinkedQueue;

public class GSPendingThreadAider {
    private final ConcurrentLinkedQueue<Runnable> mRunOnDraw = new ConcurrentLinkedQueue();
    private long lastTime;
    private final int MAX_SLEEP_TIME = 25;
    private final int MIN_SLEEP_TIME = 10;
    private final int MAX_REMAIN_DRAWS = 15;
    private final int MAX_RUN_ON_DRAW_SIZE = 8;
    private int sleepTime;

    public void removeAllPendings() {
        this.mRunOnDraw.clear();
    }

    public void runPendings() {
        while (!this.mRunOnDraw.isEmpty()) {
            this.antiShake();
            Runnable runnable = this.mRunOnDraw.poll();
            if (null == runnable) continue;
            runnable.run();
        }
    }

    private void antiShake() {
        long now = System.currentTimeMillis();
        if (now - this.lastTime > 1000L) {
            this.lastTime = now;
            int remainDraws = this.mRunOnDraw.size();
            if (remainDraws == 1) {
                this.sleepTime = 25;
            } else {
                int fixTime = remainDraws * 15 / 15;
                this.sleepTime = Math.max(25 - fixTime, 10);
            }
            GenseeLog.i("GSPendingThreadAider mRunOnDraw remains:" + remainDraws + ",sleepTime:" + this.sleepTime);
        }
        try {
            Thread.sleep(this.sleepTime);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void addToPending(Runnable runnable) {
        if (this.mRunOnDraw.size() > 8) {
            return;
        }
        this.mRunOnDraw.offer(runnable);
    }
}

